/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.application;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.PrintWriter;

public class JnlpCreator {
    public static void main(String[] args) throws Exception {
        String[] mems;
        for (String m : mems = new String[]{"1100m", "2048m", "10240m"}) {
            JnlpCreator.createJnlpFile(true, m);
            JnlpCreator.createJnlpFile(false, m);
        }
    }

    public static void createJnlpFile(boolean isDev, String maxMem) throws FileNotFoundException {
        String jnlp;
        String memFilePart;
        File[] jars = new File("C:\\Users\\jgould\\workspace\\client\\lib").listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jar");
            }
        });
        if (maxMem.equals("1100m")) {
            memFilePart = "-1g";
        } else if (maxMem.equals("2048m")) {
            memFilePart = "";
        } else if (maxMem.equals("10240m")) {
            memFilePart = "-10g";
        } else {
            throw new IllegalArgumentException();
        }
        String cb = "https://software.broadinstitute.org/GENE-E/";
        String title = "GENE-E";
        if (isDev) {
            cb = cb + "dev/";
            title = title + " Dev";
            jnlp = "GENE-E-dev" + memFilePart + ".jnlp";
        } else {
            jnlp = "GENE-E" + memFilePart + ".jnlp";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        sb.append("<jnlp spec=\"1.0+\" codebase=\"" + cb + "\" href=\"" + jnlp + "\">");
        sb.append("<information>\n");
        sb.append("<title>");
        sb.append(title);
        sb.append("</title>\n");
        sb.append("    <vendor>The Broad Institute</vendor>\n");
        sb.append("    <homepage href=\"" + cb + "\"/>\n");
        sb.append("    <description>GENE-E Software</description>\n");
        sb.append("    <description kind=\"short\">GENE-E</description>\n");
        sb.append("    <icon href=\"img/GENE-E-64.gif\"/>\n");
        sb.append("    <icon kind=\"splash\" href=\"img/GENE-E-splash.gif\"/>\n");
        sb.append("    <shortcut online=\"true\">\n");
        sb.append("\t  <desktop/>\n");
        sb.append("\t  <menu submenu=\"" + title + "\"/>\n");
        sb.append("\t</shortcut>\n");
        sb.append("  </information>\n");
        sb.append("  <security>\n");
        sb.append("      <all-permissions/>\n");
        sb.append("  </security>\n");
        sb.append("  <resources>\n");
        sb.append("    <j2se version=\"1.7+\" initial-heap-size=\"256m\" max-heap-size=\"" + maxMem + "\" href=\"http://java.sun.com/products/autodl/j2se\"/>\n");
        sb.append("    <jar href=\"GENE-E.jar\" main=\"true\" />\n");
        for (File jar : jars) {
            sb.append("    <jar href=\"" + jar.getName() + "\" />\n");
        }
        sb.append("    <property name=\"apple.laf.useScreenMenuBar\" value=\"true\"/>\n");
        sb.append("   </resources>\n");
        sb.append("   <resources os=\"Mac OS X\" arch=\"x86_64\">\n");
        sb.append("      <nativelib href=\"macosx/64/njhdf.jar\" />\n");
        sb.append("    </resources>\n");
        sb.append("    <resources os=\"Mac OS X\" arch=\"amd64\">\n");
        sb.append("      <nativelib href=\"macosx/64/njhdf.jar\" />\n");
        sb.append("    </resources>\n");
        sb.append("    <resources os=\"Mac OS X\" arch=\"x86\">\n");
        sb.append("      <nativelib href=\"macosx/32/njhdf.jar\" />\n");
        sb.append("    </resources>\n");
        sb.append("   <resources os=\"Windows\" arch=\"x86_64\">\n");
        sb.append("      <nativelib href=\"windows/64/njhdf.jar\" />\n");
        sb.append("    </resources>\n");
        sb.append("    <resources os=\"Windows\" arch=\"x86\">\n");
        sb.append("      <nativelib href=\"windows/32/njhdf.jar\" />\n");
        sb.append("    </resources>\n");
        sb.append("    <resources os=\"Windows\" arch=\"amd64\">\n");
        sb.append("      <nativelib href=\"windows/64/njhdf.jar\" />\n");
        sb.append("    </resources>\n");
        sb.append("    <resources os=\"Windows\" arch=\"amd\">\n");
        sb.append("      <nativelib href=\"windows/32/njhdf.jar\" />\n");
        sb.append("    </resources>\n");
        sb.append("    <resources os=\"Linux\" arch=\"x86_64\">\n");
        sb.append("      <nativelib href=\"linux/64/njhdf.jar\" />\n");
        sb.append("    </resources>\n");
        sb.append("    <resources os=\"Linux\" arch=\"amd64\">\n");
        sb.append("      <nativelib href=\"linux/64/njhdf.jar\" />\n");
        sb.append("    </resources>\n");
        sb.append("    <resources os=\"Linux\" arch=\"x86\">\n");
        sb.append("      <nativelib href=\"linux/32/njhdf.jar\" />\n");
        sb.append("    </resources>\n");
        sb.append("  <application-desc name=\"" + title + "\"");
        sb.append(" main-class=\"org.broadinstitute.genee.application.Application\">\n");
        sb.append("</application-desc>\n");
        sb.append("<update check=\"always\" policy=\"always\" />");
        sb.append("</jnlp>");
        File file = new File("C:\\Users\\jgould\\workspace\\website" + (isDev ? "\\dev" : ""), jnlp);
        PrintWriter pw = new PrintWriter(file);
        pw.print(sb.toString());
        pw.close();
    }
}

