/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.application;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.AbstractAction;
import javax.swing.tree.TreeNode;
import org.broadinstitute.genee.application.GENEETreeNode;
import org.broadinstitute.genee.io.util.IOUtil;
import org.jdesktop.swingx.util.OS;

public class RevealInFinder
extends AbstractAction {
    private WeakReference<GENEETreeNode> node;

    public RevealInFinder(GENEETreeNode node) {
        super((OS.isMacOSX() ? "Reveal In Finder" : "Reveal In Explorer") + " (" + IOUtil.getPath(node.getFile().getParentFile()) + ")");
        this.node = new WeakReference<GENEETreeNode>(node);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        GENEETreeNode r = (GENEETreeNode)this.node.get();
        if (r != null) {
            RevealInFinder.reveal(r);
        }
    }

    public static boolean isEnabled(TreeNode node) {
        if (node instanceof GENEETreeNode) {
            File file = ((GENEETreeNode)node).getFile();
            return (OS.isMacOSX() || OS.isWindows()) && file != null && file.exists();
        }
        return false;
    }

    public static void reveal(GENEETreeNode node) {
        File file = node.getFile();
        if (file != null && file.exists()) {
            String path = IOUtil.getPath(file);
            if (OS.isMacOSX()) {
                ScriptEngineManager engineManager = new ScriptEngineManager();
                ScriptEngine applescript = engineManager.getEngineByName("AppleScript");
                String script = "tell application \"Finder\"\n\tset fullpath to \"" + path + "\"\n" + "\tset fullpath to POSIX file fullpath as text\n" + "\treveal fullpath\n" + "\tactivate\n" + "end tell";
                try {
                    applescript.eval(script, applescript.getContext());
                }
                catch (ScriptException e1) {
                    e1.printStackTrace();
                }
            } else {
                String[] cmd = new String[]{"Explorer", "/select," + path};
                ProcessBuilder pb = new ProcessBuilder(cmd);
                pb.redirectErrorStream(true);
                try {
                    Process p = pb.start();
                    BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    while (br.readLine() != null) {
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }
    }
}

