/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.application;

import java.awt.Component;
import java.awt.Cursor;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.broadinstitute.genee.gui.BrowserLauncher;
import org.broadinstitute.genee.gui.UIUtil;

public class WelcomePage {
    private JEditorPane editorPane = new JEditorPane();
    private JScrollPane sp;
    private static final String URL = System.getProperty("welcome.page", "https://software.broadinstitute.org/GENE-E/dev/");

    public WelcomePage() {
        this.editorPane.setEditable(false);
        this.editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    WelcomePage.this.editorPane.setCursor(Cursor.getPredefinedCursor(12));
                } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    WelcomePage.this.editorPane.setCursor(Cursor.getDefaultCursor());
                } else {
                    WelcomePage.this.editorPane.setCursor(Cursor.getDefaultCursor());
                    URL url = e.getURL();
                    if (e.getDescription() != null) {
                        try {
                            WelcomePage.this.editorPane.setPage(URL);
                        }
                        catch (IOException e1) {}
                    } else if (url != null) {
                        String s = url.toString();
                        BrowserLauncher.openURL(s);
                    }
                }
            }
        });
        new Thread(){

            @Override
            public void run() {
                try {
                    WelcomePage.this.editorPane.setPage(URL);
                }
                catch (IOException e1) {
                    WelcomePage.this.editorPane.setContentType("text/html");
                    WelcomePage.this.editorPane.setText("<html><p>Unable to connect to server. <a href=\"_i_tryAgain\">Try connecting again</a>.");
                }
            }
        }.start();
        this.sp = UIUtil.createNoBorderScrollPane(this.editorPane);
    }

    public Component getComponent() {
        return this.sp;
    }
}

