/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.category;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Paint;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.broadinstitute.genee.category.VectorColorModel;
import org.broadinstitute.genee.gui.ColorByIcon;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.HeatMapColorScheme;
import org.broadinstitute.genee.heatmap.HeatMapColorSchemeLegend;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class CategoryLegend
extends JPanel {
    private MetadataModel metadata;
    private VectorColorModel colorModel;
    private boolean rows;
    private int boxSize;

    public CategoryLegend(boolean rows, int boxSize) {
        this.rows = rows;
        this.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
        this.setBackground(Color.WHITE);
        this.boxSize = boxSize;
    }

    public void setProject(Project project) {
        if (project != null) {
            this.colorModel = this.rows ? project.getRowColorModel() : project.getColumnColorModel();
            this.metadata = MetadataUtil.getCategoryColumns(this.rows ? project.getOriginalDataset().getRowMetadata() : project.getOriginalDataset().getColumnMetadata());
            this._update();
        }
    }

    private void _update() {
        if (this.colorModel == null) {
            return;
        }
        this.setLayout((LayoutManager)new FormLayout(UIUtil.rep("p:g", 3, ", 6px, "), "top:p"));
        LayoutManager2[] layouts = new LayoutManager2[3];
        JPanel[] panels = new JPanel[3];
        CellConstraints cc = new CellConstraints();
        int i = 0;
        int j = 1;
        while (i < panels.length) {
            panels[i] = new JPanel();
            layouts[i] = new BoxLayout(panels[i], 1);
            panels[i].setLayout(layouts[i]);
            panels[i].setBackground(Color.WHITE);
            this.add((Component)panels[i], cc.xy(j, 1));
            ++i;
            j += 2;
        }
        int column = 0;
        for (int i2 = 0; i2 < this.metadata.getMetadataCount(); ++i2) {
            Vector vector = this.metadata.get(i2);
            JPanel p = panels[column];
            if (vector.getName() != null) {
                JLabel label = new JLabel(vector.getName());
                label.setFont(label.getFont().deriveFont((float)(this.boxSize + 1)));
                p.add(label);
            }
            if (MetadataUtil.getBoolean(vector, "Continuous Key")) {
                HeatMapColorScheme cs = this.colorModel.getContinuousColorScheme(vector);
                JComponent legend = cs.getLegend();
                legend.setPreferredSize(new Dimension(200, 30));
                legend.setMinimumSize(new Dimension());
                ((HeatMapColorSchemeLegend)legend).setScalingStringVisible(false);
                p.add(legend);
            } else {
                Set possibleValues = VectorUtil.getValues(vector);
                for (Object value : possibleValues) {
                    String text = Formatter.toString(value);
                    Color color = (Color)this.colorModel.getMappedValue(vector, value);
                    JLabel label = new JLabel(text);
                    label.setFont(label.getFont().deriveFont((float)this.boxSize));
                    label.setIcon(new ColorByIcon((Paint)color, this.boxSize));
                    p.add(label);
                }
            }
            p.add(new JLabel(" "));
            if (++column != panels.length) continue;
            column = 0;
        }
        this.revalidate();
        this.repaint();
    }
}

