/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.category;

import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.genee.category.AbstractVectorVisualMapper;
import org.broadinstitute.genee.category.QualitativeColorSchemes;
import org.broadinstitute.genee.category.VectorColorModel;
import org.broadinstitute.genee.category.VectorVisualMapperEvent;
import org.broadinstitute.genee.heatmap.DefaultHeatMapColorScheme;
import org.broadinstitute.genee.heatmap.HeatMapColorScheme;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class DefaultVectorColorModel
extends AbstractVectorVisualMapper<Color>
implements VectorColorModel {
    public static final Color[] DEFAULT_CONTINUOUS_COLORS = new Color[]{new Color(229, 245, 249), new Color(53, 216, 201), new Color(44, 162, 95)};
    private static final Color YES_COLOR = new Color(216, 179, 101);
    private static final Color FEMALE = new Color(255, 153, 255);
    private static final Color MALE = new Color(102, 204, 255);
    private int colorIndex;
    private HashMap<String, Map<Object, Color>> vectorNameToColorMap = new LinkedHashMap<String, Map<Object, Color>>();
    private HashMap<String, HeatMapColorScheme> vectorNameToColorScheme = new HashMap();

    public void clear(Vector vector) {
        this.vectorNameToColorMap.remove(vector.getName());
        this.vectorNameToColorScheme.remove(vector.getName());
    }

    public void clearAll() {
        this.vectorNameToColorMap.clear();
        this.vectorNameToColorScheme.clear();
        this.colorIndex = 0;
    }

    @Override
    public boolean containsDiscreteColor(Vector vector, Object value) {
        Map<Object, Color> metadataValueToColorMap = this.vectorNameToColorMap.get(vector.getName());
        if (metadataValueToColorMap == null) {
            return false;
        }
        Color c = metadataValueToColorMap.get(value);
        return c != null;
    }

    @Override
    public HeatMapColorScheme getContinuousColorScheme(Vector vector) {
        HeatMapColorScheme cs = this.vectorNameToColorScheme.get(vector.getName());
        if (cs == null) {
            cs = this.createContinuousColorMap(vector);
        }
        return cs;
    }

    @Override
    public Color getMappedValue(Vector vector, Object value) {
        Color color;
        if (MetadataUtil.getBoolean(vector, "Continuous Key")) {
            HeatMapColorScheme cs = this.vectorNameToColorScheme.get(vector.getName());
            if (cs == null) {
                cs = this.createContinuousColorMap(vector);
            }
            float val = !(value instanceof Number) ? Float.NaN : ((Number)value).floatValue();
            return cs.getColor(0, 0, val);
        }
        Map<Object, Color> metadataValueToColorMap = this.vectorNameToColorMap.get(vector.getName());
        if (metadataValueToColorMap == null) {
            metadataValueToColorMap = new HashMap<Object, Color>();
            this.vectorNameToColorMap.put(vector.getName(), metadataValueToColorMap);
        }
        if ((color = metadataValueToColorMap.get(value)) == null) {
            if (value == null) {
                color = Color.WHITE;
            } else {
                String stringValue = Formatter.toString(value).trim();
                if ("na".equalsIgnoreCase(stringValue) || "nan".equalsIgnoreCase(stringValue)) {
                    color = Color.LIGHT_GRAY;
                } else if ("".equals(stringValue) || "wt".equalsIgnoreCase(stringValue) || "n".equalsIgnoreCase(stringValue) || "0".equals(stringValue)) {
                    color = Color.WHITE;
                } else if ("y".equalsIgnoreCase(stringValue) || "1".equals(stringValue)) {
                    color = YES_COLOR;
                } else if ("male".equalsIgnoreCase(stringValue) || "m".equalsIgnoreCase(stringValue)) {
                    color = MALE;
                } else if ("female".equalsIgnoreCase(stringValue) || "f".equalsIgnoreCase(stringValue)) {
                    color = FEMALE;
                }
                if (color == null) {
                    Map<Object, Color> existingMetadataValueToColorMap;
                    Iterator<Map<Object, Color>> i$ = this.vectorNameToColorMap.values().iterator();
                    while (i$.hasNext() && (color = (existingMetadataValueToColorMap = i$.next()).get(value)) == null) {
                    }
                }
                if (color == null) {
                    color = QualitativeColorSchemes.TWENTY_COLORS[this.colorIndex % QualitativeColorSchemes.TWENTY_COLORS.length];
                    ++this.colorIndex;
                }
            }
            metadataValueToColorMap.put(value, color);
        }
        return color;
    }

    @Override
    public void setContinuousColorScheme(Vector vector, HeatMapColorScheme colorScheme) {
        this.vectorNameToColorScheme.put(vector.getName(), colorScheme);
        this.fireVectorVisualMapperListenerChanged(new VectorVisualMapperEvent(this));
    }

    @Override
    public void setMappedValue(Vector vector, Object value, Color color) {
        Map<Object, Color> map = this.vectorNameToColorMap.get(vector.getName());
        if (map == null) {
            map = new HashMap<Object, Color>();
            this.vectorNameToColorMap.put(vector.getName(), map);
        }
        map.put(value, color);
        this.fireVectorVisualMapperListenerChanged(new VectorVisualMapperEvent(this));
    }

    private HeatMapColorScheme createContinuousColorMap(Vector vector) {
        float min = VectorUtil.getMin(vector);
        float max = VectorUtil.getMax(vector);
        DefaultHeatMapColorScheme cs = new DefaultHeatMapColorScheme(min, max);
        Color[] colors = DEFAULT_CONTINUOUS_COLORS;
        cs.setColors(colors);
        this.vectorNameToColorScheme.put(vector.getName(), cs);
        if (min < 0.0f && max > 0.0f) {
            float span = max - min;
            float zeroFraction = (0.0f - min) / span;
            if (Float.isInfinite(span)) {
                zeroFraction = 1.0E-5f;
            }
            cs.setColors(colors, new float[]{0.0f, zeroFraction, 1.0f});
        }
        return cs;
    }

    public static DefaultVectorColorModel copy(MetadataModel metadata, VectorColorModel colorModel) {
        DefaultVectorColorModel newColorModel = new DefaultVectorColorModel();
        int size = metadata.getMetadataCount();
        for (int i = 0; i < size; ++i) {
            String columnName = metadata.getColumnName(i);
            if (MetadataUtil.getBoolean(metadata.get(i), "Continuous Key")) {
                HeatMapColorScheme colorScheme = colorModel.getContinuousColorScheme(metadata.get(i));
                if (colorScheme == null) continue;
                HeatMapColorScheme copy = colorScheme.copy();
                copy.setGlobalMin(colorScheme.getMin());
                copy.setGlobalMax(colorScheme.getMax());
                newColorModel.vectorNameToColorScheme.put(columnName, copy);
                continue;
            }
            Set possibleValues = VectorUtil.getValues(metadata.get(metadata.getColumnIndex(columnName)));
            for (Object category : possibleValues) {
                Color color = (Color)colorModel.getMappedValue(metadata.get(i), category);
                Map<Object, Color> map = newColorModel.vectorNameToColorMap.get(columnName);
                if (map == null) {
                    map = new HashMap<Object, Color>();
                    newColorModel.vectorNameToColorMap.put(columnName, map);
                }
                map.put(category, color);
            }
        }
        return newColorModel;
    }
}

