/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.category;

import chemaxon.struc.Molecule;
import com.google.common.base.Objects;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.broadinstitute.genee.application.UserUtil;
import org.broadinstitute.genee.gui.ButtonGroupHelper;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.actions.MetadataDataType;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.Vector;

public class MetadataPopup {
    private static final String TYPE = "org.broadinstitute.genee.type";
    private Project project;
    private JPopupMenu popupMenu;
    private boolean rows;
    private MetadataModel metadataModel;
    private HeatMapPanel heatMapPanel;
    private Object key;
    private Vector vector;
    private MOVE_MODE moveMode;

    public MetadataPopup(HeatMapPanel heatMapPanel, Project project, MetadataModel metadataModel, Vector vector, JPopupMenu popupMenu, boolean rows, MOVE_MODE moveMode, Object key) {
        this.heatMapPanel = heatMapPanel;
        this.vector = vector;
        this.project = project;
        this.metadataModel = metadataModel;
        this.popupMenu = popupMenu;
        this.rows = rows;
        this.key = key;
        this.moveMode = moveMode;
        this.buildMenu(true);
    }

    private void buildMenu(boolean enableDelete) {
        if (this.vector != null) {
            JMenuItem menuItem = new JMenuItem(this.vector.getName());
            menuItem.setEnabled(false);
            this.popupMenu.add(menuItem);
            this.popupMenu.addSeparator();
            if (this.moveMode != MOVE_MODE.NONE) {
                JMenu moveMenu = new JMenu("Move");
                moveMenu.add(new AbstractAction(this.rows ? "Right" : "Up"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int count = MetadataPopup.this.metadataModel.getMetadataCount();
                        for (int i = 0; i < count; ++i) {
                            MetadataPopup.this.metadataModel.get(i).setProperty(MetadataPopup.this.key + "_order", i);
                        }
                        float index = MetadataPopup.this.metadataModel.getColumnIndex(MetadataPopup.this.vector.getName());
                        index = MetadataPopup.this.moveMode == MOVE_MODE.REVERSED ? index + 1.1f : index - 1.1f;
                        MetadataPopup.this.vector.setProperty(MetadataPopup.this.key + "_order", Float.valueOf(index));
                        if (MetadataPopup.this.rows) {
                            MetadataPopup.this.project.fireRowMetadataChanged();
                        } else {
                            MetadataPopup.this.project.fireColumnMetadataChanged();
                        }
                    }
                });
                moveMenu.add(new AbstractAction(this.rows ? "Left" : "Down"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int count = MetadataPopup.this.metadataModel.getMetadataCount();
                        for (int i = 0; i < count; ++i) {
                            MetadataPopup.this.metadataModel.get(i).setProperty(MetadataPopup.this.key + "_order", i);
                        }
                        float index = MetadataPopup.this.metadataModel.getColumnIndex(MetadataPopup.this.vector.getName());
                        index = MetadataPopup.this.moveMode == MOVE_MODE.REVERSED ? index - 1.1f : index + 1.1f;
                        MetadataPopup.this.vector.setProperty(MetadataPopup.this.key + "_order", Float.valueOf(index));
                        if (MetadataPopup.this.rows) {
                            MetadataPopup.this.project.fireRowMetadataChanged();
                        } else {
                            MetadataPopup.this.project.fireColumnMetadataChanged();
                        }
                    }
                });
                this.popupMenu.add(moveMenu);
            }
            JMenu displayMenu = new JMenu("Display");
            displayMenu.add(this.createCheckBoxMenuItem("Color", "Color Visible", Boolean.TRUE, null));
            displayMenu.add(this.createCheckBoxMenuItem("Text", "Text Visible", Boolean.TRUE, null));
            displayMenu.add(this.createCheckBoxMenuItem("Text Color", "Text Color Visible", Boolean.TRUE, new Object[]{"Text Visible"}));
            displayMenu.add(this.createCheckBoxMenuItem("Tooltip", "Tooltip Visible", Boolean.TRUE, null));
            JMenu showChartMenu = new JMenu("Chart");
            showChartMenu.add(this.createCheckBoxMenuItem("(None)", "Chart Style", null, null));
            showChartMenu.add(this.createCheckBoxMenuItem("Bar", "Chart Style", 64, null));
            showChartMenu.add(this.createCheckBoxMenuItem("Line", "Chart Style", 2, null));
            showChartMenu.add(this.createCheckBoxMenuItem("Point", "Chart Style", 4, null));
            displayMenu.add(showChartMenu);
            Class<?> c = this.vector.getColumnClass();
            showChartMenu.setEnabled(Number.class.isAssignableFrom(c));
            this.popupMenu.add(displayMenu);
            this.popupMenu.addSeparator();
            JMenu dataTypeMenu = new JMenu("Data Type");
            ActionListener dataTypeListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCheckBoxMenuItem source = (JCheckBoxMenuItem)e.getSource();
                    MetadataDataType newMetadataType = (MetadataDataType)((Object)source.getClientProperty(MetadataPopup.TYPE));
                    Class<?> newClass = MetadataDataType.getClass(newMetadataType);
                    if (!newClass.equals(MetadataPopup.this.vector.getColumnClass())) {
                        try {
                            DatasetUtil.changeDataType(MetadataPopup.this.project, true, MetadataPopup.this.vector.getName(), newMetadataType);
                            if (MetadataPopup.this.rows) {
                                MetadataPopup.this.project.fireRowMetadataChanged();
                            } else {
                                MetadataPopup.this.project.fireColumnMetadataChanged();
                            }
                        }
                        catch (IllegalArgumentException x) {
                            UIUtil.showErrorDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), x.getMessage());
                        }
                    }
                }
            };
            ButtonGroupHelper bg = new ButtonGroupHelper();
            JCheckBoxMenuItem textDataType = bg.createCheckBoxMenuItem(MetadataDataType.TEXT.toString(), String.class.isAssignableFrom(c));
            textDataType.putClientProperty(TYPE, (Object)MetadataDataType.TEXT);
            textDataType.addActionListener(dataTypeListener);
            dataTypeMenu.add(textDataType);
            JCheckBoxMenuItem numberDataType = bg.createCheckBoxMenuItem(MetadataDataType.NUMBER.toString(), Number.class.isAssignableFrom(c));
            numberDataType.putClientProperty(TYPE, (Object)MetadataDataType.NUMBER);
            numberDataType.addActionListener(dataTypeListener);
            dataTypeMenu.add(numberDataType);
            JCheckBoxMenuItem urlDataType = bg.createCheckBoxMenuItem(MetadataDataType.URL.toString(), URL.class.isAssignableFrom(c));
            urlDataType.putClientProperty(TYPE, (Object)MetadataDataType.URL);
            urlDataType.addActionListener(dataTypeListener);
            dataTypeMenu.add(urlDataType);
            JCheckBoxMenuItem dateDataType = bg.createCheckBoxMenuItem(MetadataDataType.DATE.toString(), Date.class.isAssignableFrom(c));
            dateDataType.putClientProperty(TYPE, (Object)MetadataDataType.DATE);
            dateDataType.addActionListener(dataTypeListener);
            dataTypeMenu.add(dateDataType);
            if (UserUtil.isBroadUser()) {
                JCheckBoxMenuItem moleculeDataType = bg.createCheckBoxMenuItem(MetadataDataType.MOLECULE.toString(), Molecule.class.isAssignableFrom(c));
                moleculeDataType.putClientProperty(TYPE, (Object)MetadataDataType.MOLECULE);
                moleculeDataType.addActionListener(dataTypeListener);
                dataTypeMenu.add(moleculeDataType);
            }
            this.popupMenu.add(dataTypeMenu);
            JMenuItem discreteMenuItem = this.createCheckBoxMenuItem("Discrete", "Continuous Key", Boolean.FALSE, null);
            discreteMenuItem.setEnabled(Number.class.isAssignableFrom(c));
            this.popupMenu.add(discreteMenuItem);
            this.popupMenu.addSeparator();
            JMenuItem delete = new JMenuItem("Delete");
            delete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (UIUtil.showOkCancelDialog(MetadataPopup.this.popupMenu, "Are you sure you want to delete " + MetadataPopup.this.vector.getName() + "?", "")) {
                        MetadataPopup.this.metadataModel.remove(MetadataPopup.this.metadataModel.getColumnIndex(MetadataPopup.this.vector.getName()));
                        if (MetadataPopup.this.rows) {
                            MetadataPopup.this.project.fireRowMetadataChanged();
                        } else {
                            MetadataPopup.this.project.fireColumnMetadataChanged();
                        }
                    }
                }
            });
            delete.setEnabled(enableDelete);
            this.popupMenu.add(delete);
            this.popupMenu.addSeparator();
        }
        String text = this.vector != null ? "More Options" : "Edit " + (this.rows ? "Row" : "Column") + " Annotations";
        this.popupMenu.add(new AbstractAction(text + "\u2026"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MetadataPopup.this.rows) {
                    MetadataPopup.this.heatMapPanel.getHeatMapEditorKit().getEditRowAnnotationsAction().actionPerformed(e);
                } else {
                    MetadataPopup.this.heatMapPanel.getHeatMapEditorKit().getEditColumnAnnotationsAction().actionPerformed(e);
                }
            }
        });
    }

    private JMenuItem createCheckBoxMenuItem(String text, final Object key, final Object selectedValue, final Object[] additionalKeys) {
        final JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(text, Objects.equal((Object)selectedValue, (Object)this.vector.getProperty(key)));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (menuItem.isSelected()) {
                    MetadataPopup.this.vector.setProperty(key, selectedValue);
                    if (additionalKeys != null) {
                        for (Object additionalKey : additionalKeys) {
                            MetadataPopup.this.vector.setProperty(additionalKey, selectedValue);
                        }
                    }
                } else {
                    MetadataPopup.this.vector.removeProperty(key);
                    if (additionalKeys != null) {
                        for (Object additionalKey : additionalKeys) {
                            MetadataPopup.this.vector.removeProperty(additionalKey);
                        }
                    }
                }
                if (MetadataPopup.this.rows) {
                    MetadataPopup.this.project.fireRowMetadataChanged();
                } else {
                    MetadataPopup.this.project.fireColumnMetadataChanged();
                }
            }
        });
        return menuItem;
    }

    public static enum MOVE_MODE {
        NONE,
        REVERSED,
        NORMAL;

    }
}

