/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.category;

import chemaxon.marvin.beans.MViewPane;
import chemaxon.struc.Molecule;
import com.google.common.base.Objects;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import org.broadinstitute.genee.application.UserUtil;
import org.broadinstitute.genee.compound.MoleculeUtil;
import org.broadinstitute.genee.heatmap.HeatMapDrawable;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectEvent;
import org.broadinstitute.genee.heatmap.ProjectListener;
import org.broadinstitute.genee.heatmap.SizesAndPositions;
import org.broadinstitute.genee.heatmap.SizesAndPositionsEvent;
import org.broadinstitute.genee.heatmap.SizesAndPositionsListener;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.Vector;

public class MoleculePanel
extends JPanel
implements HeatMapDrawable {
    private SizesAndPositions sizesAndPositions;
    private ProjectListener projectListener;
    private Vector vector;
    private Map<Integer, Integer> rowAndColumnToStartEnd = new HashMap<Integer, Integer>();
    private MViewPane pane;
    private SizesAndPositionsListener sizesAndPositionsListener;
    private Project project;
    private JPanel panel;

    public MoleculePanel(final Project project, SizesAndPositions sizesAndPositions, final String name) {
        this.sizesAndPositions = sizesAndPositions;
        this.project = project;
        this.pane = new MViewPane();
        this.pane.getMolPanel().setBackground(new Color(255, 255, 255, 0));
        this.pane.setBackground(new Color(255, 255, 255, 0));
        this.pane.setPreferredSize(new Dimension(300, 300));
        this.pane.setVisible(true);
        JPanel p = new JPanel();
        p.add((Component)this.pane);
        this.setMinimumSize(new Dimension());
        this.setBackground(Color.WHITE);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int index;
                if (e.getClickCount() >= 2 && UserUtil.isBroadUser() && (index = MoleculePanel.this.sizesAndPositions.getIndex(e.getY(), true)) != -1) {
                    Molecule m = (Molecule)MoleculePanel.this.vector.getValue(index);
                    MViewPane p = new MViewPane();
                    p.setM(0, m);
                }
            }
        });
        this.sizesAndPositionsListener = new SizesAndPositionsListener(){

            @Override
            public void sizesAndPositionsChanged(SizesAndPositionsEvent e) {
                MoleculePanel.this.revalidate();
                MoleculePanel.this.repaint();
            }
        };
        this.projectListener = new ProjectListener(){

            @Override
            public void projectChanged(ProjectEvent e) {
                Dataset dataset = project.getSortedFilteredDataset();
                MoleculePanel.this.vector = dataset.getRowMetadata().get(name);
                MoleculePanel.this.redraw();
            }
        };
        this.projectListener.projectChanged(null);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.sizesAndPositions.removeSizesAndPositionsListener(this.sizesAndPositionsListener);
        this.project.removeProjectListener(this.projectListener);
        this.sizesAndPositions.addSizesAndPositionsListener(this.sizesAndPositionsListener);
        this.project.addProjectListener(this.projectListener);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.sizesAndPositions.removeSizesAndPositionsListener(this.sizesAndPositionsListener);
        this.project.removeProjectListener(this.projectListener);
    }

    private void buildRowAndColumnToStartEnd() {
        String previous = MoleculeUtil.toSmile((Molecule)this.vector.getValue(0));
        this.rowAndColumnToStartEnd = new HashMap<Integer, Integer>();
        int start = 0;
        int nrows = this.vector.size();
        for (int i = 1; i < nrows; ++i) {
            String val = MoleculeUtil.toSmile((Molecule)this.vector.getValue(i));
            if (Objects.equal((Object)previous, (Object)val)) continue;
            previous = val;
            this.rowAndColumnToStartEnd.put(start, i);
            start = i;
        }
        this.rowAndColumnToStartEnd.put(start, this.vector.size());
    }

    @Override
    public void draw(Graphics g, Rectangle clip) {
        int rowIndexStart = 0;
        int rowIndexEnd = this.vector.size();
        if (clip != null) {
            rowIndexStart = Math.max(this.sizesAndPositions.getIndex(clip.y, false) - 1, 0);
            rowIndexEnd = Math.min(this.sizesAndPositions.getIndex(clip.y + clip.height, false) + 1, this.vector.size());
        }
        if (rowIndexStart > rowIndexEnd) {
            int tmp = rowIndexStart;
            rowIndexStart = rowIndexEnd;
            rowIndexEnd = tmp;
        }
        Graphics2D g2 = (Graphics2D)g;
        int width = (int)(clip != null ? clip.getWidth() : (double)this.getWidth());
        this.pane.setVisible(true);
        for (int rowIndex = rowIndexStart; rowIndex < rowIndexEnd; ++rowIndex) {
            Integer end = this.rowAndColumnToStartEnd.get(rowIndex);
            if (end == null) continue;
            float starty = this.sizesAndPositions.getPosition(rowIndex);
            float endy = this.sizesAndPositions.getPosition(end - 1) + this.sizesAndPositions.getSize();
            this.pane.setM(0, (Molecule)this.vector.getValue(rowIndex));
            this.pane.setPreferredSize(new Dimension(width, (int)(endy - starty)));
            this.pane.setSize(width, (int)(endy - starty));
            this.pane.setBounds(new Rectangle(this.pane.getPreferredSize()));
            this.pane.addNotify();
            this.pane.invalidate();
            this.pane.validate();
            g2.translate(0.0, starty);
            this.pane.print((Graphics)g2);
            g2.translate(0.0, -starty);
        }
    }

    @Override
    public Dimension getDrawableSize() {
        Dimension d = new Dimension(this.getPreferredSize());
        d.width += 4;
        return d;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = new Dimension();
        preferredSize.width = 200;
        preferredSize.height = HeatMapPanel.getSize(this.sizesAndPositions);
        return preferredSize;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.draw(g, g.getClipBounds());
    }

    @Override
    public void redraw() {
        this.buildRowAndColumnToStartEnd();
        this.revalidate();
        this.repaint();
    }
}

