/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import org.broadinstitute.genee.chart.XYChartSeries;

public abstract class AbstractXYChartSeries
implements XYChartSeries {
    protected String seriesName;
    protected float xmax = -3.4028235E38f;
    protected float xmin = Float.MAX_VALUE;
    protected float ymax = -3.4028235E38f;
    protected float ymin = Float.MAX_VALUE;

    public AbstractXYChartSeries(String seriesName) {
        this.seriesName = seriesName;
    }

    public void autoscaleX() {
        int nitems = this.getItemCount();
        for (int i = 0; i < nitems; ++i) {
            float x = this.getXStart(i);
            if (!Float.isNaN(x)) {
                this.xmin = Math.min(this.xmin, x);
                this.xmax = Math.max(this.xmax, x);
            }
            if (Float.isNaN(x = this.getXEnd(i))) continue;
            this.xmin = Math.min(this.xmin, x);
            this.xmax = Math.max(this.xmax, x);
        }
    }

    public void autoscaleY() {
        int nitems = this.getItemCount();
        for (int i = 0; i < nitems; ++i) {
            float y = this.getYStart(i);
            if (!Float.isNaN(y)) {
                this.ymin = Math.min(this.ymin, y);
                this.ymax = Math.max(this.ymax, y);
            }
            if (Float.isNaN(y = this.getYEnd(i))) continue;
            this.ymin = Math.min(this.ymin, y);
            this.ymax = Math.max(this.ymax, y);
        }
    }

    @Override
    public String getName() {
        return this.seriesName;
    }

    @Override
    public float getXEnd(int index) {
        return this.getX(index);
    }

    @Override
    public float getXMax() {
        return this.xmax;
    }

    @Override
    public float getXMin() {
        return this.xmin;
    }

    @Override
    public float getXStart(int index) {
        return this.getX(index);
    }

    @Override
    public float getYEnd(int index) {
        return this.getY(index);
    }

    @Override
    public float getYMax() {
        return this.ymax;
    }

    @Override
    public float getYMin() {
        return this.ymin;
    }

    @Override
    public float getYStart(int index) {
        return this.getY(index);
    }

    public String toString() {
        int i;
        StringBuilder buf = new StringBuilder();
        int size = this.getItemCount();
        for (i = 0; i < size; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.getX(i));
        }
        buf.append("\n");
        size = this.getItemCount();
        for (i = 0; i < size; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.getY(i));
        }
        return buf.toString();
    }

    public void setYMin(float value) {
        this.ymin = value;
    }

    public void setYMax(float value) {
        this.ymax = value;
    }
}

