/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import java.util.List;

public class BoxAndWhiskerItem {
    private float lowerAdjacentValue;
    private List<Outlier> lowerOutliers;
    private float max;
    private float mean;
    private float median;
    private float min;
    private String name;
    private float q1;
    private float q3;
    private float standardDeviation;
    private float upperAdjacentValue;
    private List<Outlier> upperOutliers;

    public BoxAndWhiskerItem(float mean, float median, float standardDeviation, float q1, float q3, float minValue, float maxValue, float lowerAdjacentValue, float upperAdjacentValue, List<Outlier> lowerOutliers, List<Outlier> upperOutliers) {
        this.mean = mean;
        this.median = median;
        this.standardDeviation = standardDeviation;
        this.q1 = q1;
        this.q3 = q3;
        if (mean - standardDeviation < minValue) {
            minValue = mean - standardDeviation;
        }
        if (mean + standardDeviation > maxValue) {
            maxValue = mean + standardDeviation;
        }
        this.min = minValue;
        this.max = maxValue;
        this.lowerAdjacentValue = lowerAdjacentValue;
        this.upperAdjacentValue = upperAdjacentValue;
        this.lowerOutliers = lowerOutliers;
        this.upperOutliers = upperOutliers;
    }

    public float getLowerAdjacentValue() {
        return this.lowerAdjacentValue;
    }

    public List<Outlier> getLowerOutliers() {
        return this.lowerOutliers;
    }

    public float getMax() {
        return this.max;
    }

    public float getMean() {
        return this.mean;
    }

    public float getMedian() {
        return this.median;
    }

    public float getMin() {
        return this.min;
    }

    public String getName() {
        return this.name;
    }

    public float getQ1() {
        return this.q1;
    }

    public float getQ3() {
        return this.q3;
    }

    public float getStandardDeviation() {
        return this.standardDeviation;
    }

    public float getUpperAdjacentValue() {
        return this.upperAdjacentValue;
    }

    public List<Outlier> getUpperOutliers() {
        return this.upperOutliers;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static class Outlier {
        private int itemIndex;
        private int seriesIndex;
        private float value;

        public Outlier(int seriesIndex, int itemIndex, float value) {
            this.seriesIndex = seriesIndex;
            this.itemIndex = itemIndex;
            this.value = value;
        }

        public int getItemIndex() {
            return this.itemIndex;
        }

        public int getSeriesIndex() {
            return this.seriesIndex;
        }

        public float getValue() {
            return this.value;
        }

        public void setItemIndex(int itemIndex) {
            this.itemIndex = itemIndex;
        }

        public void setSeriesIndex(int seriesIndex) {
            this.seriesIndex = seriesIndex;
        }

        public void setValue(float value) {
            this.value = value;
        }
    }
}

