/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import com.google.common.base.Function;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.combobox.ColorComboBox;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.broadinstitute.genee.chart.ShapeComboBox;
import org.broadinstitute.genee.chart.ShapeUtil;
import org.broadinstitute.genee.filter.AbstractFloatFilter;
import org.broadinstitute.genee.filter.BetweenFloatFilter;
import org.broadinstitute.genee.filter.GT;
import org.broadinstitute.genee.filter.GTE;
import org.broadinstitute.genee.filter.LT;
import org.broadinstitute.genee.filter.LTE;
import org.broadinstitute.genee.gui.CloseablePanel;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.TimerTextField;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.parameters.BasicMapEntry;
import org.broadinstitute.genee.heatmap.DefaultElementPainter;
import org.broadinstitute.genee.heatmap.ElementPainter;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.ParserHelper;

public class ConditionalDrawingOptionsPanel
extends JPanel {
    private HeatMapPanel heatMapPanel;
    private FilterPanel filterPanel;

    public ConditionalDrawingOptionsPanel(HeatMapPanel heatMapPanel) {
        this.heatMapPanel = heatMapPanel;
        this.filterPanel = new FilterPanel(heatMapPanel);
        this.setLayout(new BorderLayout());
        this.add(UIUtil.createNoBorderScrollPane(this.filterPanel.getComponent()));
        Collection<DefaultElementPainter.Condition> predicates = heatMapPanel.getColorScheme().getPredicateAndShapes();
        for (DefaultElementPainter.Condition p : predicates) {
            this.filterPanel.addFilterControl.add(new BetweenFilterPanel(heatMapPanel, p));
        }
    }

    public void rebuild() {
        UIUtil.applyRecursively(this.filterPanel.getComponent(), (Function<? super Component, Void>)new Function<Component, Void>(){

            public Void apply(Component c) {
                if (c instanceof BetweenFilterPanel) {
                    UIUtil.rebuildDatasetCombobox(ConditionalDrawingOptionsPanel.this.heatMapPanel.getProject(), ((BetweenFilterPanel)c).datasetComboBox);
                }
                return null;
            }
        });
    }

    private static class FilterPanel {
        private CellConstraints cc = new CellConstraints();
        private JPanel filtersPanel;
        private JScrollPane filtersScrollPane;
        private FormLayout formLayout;
        private HeatMapPanel heatMapPanel;
        private AddFilterControl addFilterControl;

        public FilterPanel(HeatMapPanel heatMapPanel) {
            this.heatMapPanel = heatMapPanel;
            FormBuilder topPanel = new FormBuilder();
            this.formLayout = new FormLayout("p", "");
            this.filtersPanel = new JPanel((LayoutManager)this.formLayout);
            this.filtersPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            JPanel filtersPanelPlusAddButton = new JPanel(new BorderLayout());
            filtersPanelPlusAddButton.add((Component)topPanel.getPanel(), "North");
            filtersPanelPlusAddButton.add((Component)this.filtersPanel, "Center");
            this.addFilterControl = new AddFilterControl();
            filtersPanelPlusAddButton.add((Component)this.addFilterControl.getComponent(), "South");
            this.filtersScrollPane = new JScrollPane(filtersPanelPlusAddButton, 20, 31);
            this.filtersScrollPane.setBorder(null);
        }

        public Component getComponent() {
            return this.filtersScrollPane;
        }

        private class AddFilterControl {
            private JPanel mainPanel;
            private JComponent panel;

            public AddFilterControl() {
                JButton addConditionButton = new JButton("Add Condition");
                addConditionButton.setOpaque(false);
                this.panel = new JPanel();
                this.panel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
                this.panel.setLayout(new GridBagLayout());
                this.panel.add((Component)addConditionButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.panel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                addConditionButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ElementPainter painter = FilterPanel.this.heatMapPanel.getElementPainter();
                        if (painter instanceof DefaultElementPainter) {
                            BetweenFilterPanel filterPanel = new BetweenFilterPanel(FilterPanel.this.heatMapPanel);
                            AddFilterControl.this.add(filterPanel);
                            FilterPanel.this.heatMapPanel.getColorScheme().addCondition(filterPanel.predicateAndShape);
                            FilterPanel.this.heatMapPanel.setElementPainter(FilterPanel.this.heatMapPanel.getElementPainter());
                        }
                    }
                });
                this.mainPanel = new JPanel(new FlowLayout(3));
                this.mainPanel.add(this.panel);
            }

            public JComponent getComponent() {
                return this.mainPanel;
            }

            private void add(final BetweenFilterPanel filterPanel) {
                FilterPanel.this.formLayout.appendRow(UIUtil.decodeRowSpec("p"));
                final CloseablePanel closeablePanel = new CloseablePanel(filterPanel, filterPanel.toString(), true, filterPanel.predicateAndShape.isEnabled());
                ActionListener enabledActionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        boolean enabled = closeablePanel.isEnabled();
                        filterPanel.predicateAndShape.setEnabled(enabled);
                        System.out.println(filterPanel.predicateAndShape.isEnabled());
                        FilterPanel.this.heatMapPanel.invalidateImage();
                    }
                };
                closeablePanel.addEnabledActionListener(enabledActionListener);
                ActionListener deleteActionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FilterPanel.this.filtersPanel.remove(closeablePanel.getComponent());
                        ElementPainter painter = FilterPanel.this.heatMapPanel.getElementPainter();
                        if (painter instanceof DefaultElementPainter) {
                            FilterPanel.this.heatMapPanel.getColorScheme().removeCondition(filterPanel.predicateAndShape);
                            FilterPanel.this.heatMapPanel.invalidateImage();
                        }
                        FilterPanel.this.filtersPanel.revalidate();
                        FilterPanel.this.filtersPanel.repaint();
                    }
                };
                closeablePanel.addCloseActionListener(deleteActionListener);
                FilterPanel.this.filtersPanel.add(closeablePanel.getComponent(), FilterPanel.this.cc.xy(1, FilterPanel.this.formLayout.getRowCount()));
                FilterPanel.this.filtersPanel.revalidate();
                FilterPanel.this.filtersPanel.repaint();
            }
        }
    }

    public static class BetweenFilterPanel
    extends JPanel {
        public static final int GREATER_THAN = 0;
        public static final int GREATER_THAN_OR_EQUAL = 2;
        public static final int LESS_THAN = 1;
        public static final int LESS_THAN_OR_EQUAL = 3;
        private HeatMapPanel heatMapPanel;
        private ShapeComboBox shapeComboBox;
        private JComboBox datasetComboBox;
        private DefaultElementPainter.Condition predicateAndShape;

        public static AbstractFloatFilter createAbstractFloatFilter(int comparison) {
            if (comparison == 0) {
                return new GT();
            }
            if (comparison == 1) {
                return new LT();
            }
            if (comparison == 2) {
                return new GTE();
            }
            if (comparison == 3) {
                return new LTE();
            }
            return null;
        }

        public BetweenFilterPanel(HeatMapPanel heatMapPanel) {
            this(heatMapPanel, new DefaultElementPainter.Condition(new BetweenFloatFilter(), ShapeUtil.getShape(1, 12.0f), -1, null));
        }

        private static void selectRangeComboBox(JComboBox comboBox, Object filter) {
            if (filter instanceof GT) {
                comboBox.setSelectedIndex(0);
            } else if (filter instanceof GTE) {
                comboBox.setSelectedIndex(1);
            } else if (filter instanceof LT) {
                comboBox.setSelectedIndex(2);
            } else if (filter instanceof LTE) {
                comboBox.setSelectedIndex(3);
            }
        }

        public BetweenFilterPanel(final HeatMapPanel heatMapPanel, final DefaultElementPainter.Condition predicateAndShape) {
            this.heatMapPanel = heatMapPanel;
            this.predicateAndShape = predicateAndShape;
            this.datasetComboBox = UIUtil.createComboBox();
            UIUtil.rebuildDatasetCombobox(heatMapPanel.getProject(), this.datasetComboBox);
            if (predicateAndShape.getDatasetName() != null) {
                this.datasetComboBox.setSelectedItem(predicateAndShape.getDatasetName());
            } else {
                predicateAndShape.setDatasetName((String)this.datasetComboBox.getItemAt(0));
            }
            this.datasetComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String dataset = (String)BetweenFilterPanel.this.datasetComboBox.getSelectedItem();
                    predicateAndShape.setDatasetName(dataset);
                    if (heatMapPanel.getElementPainter() instanceof DefaultElementPainter) {
                        heatMapPanel.setElementPainter(heatMapPanel.getElementPainter());
                    }
                }
            });
            final JComboBox lowerComboBox = UIUtil.createComboBox(new BasicMapEntry[]{new BasicMapEntry<Integer>(">", 0), new BasicMapEntry<Integer>(">=", 2), new BasicMapEntry<Integer>("<", 1), new BasicMapEntry<Integer>("<=", 3)});
            BetweenFloatFilter filter = (BetweenFloatFilter)predicateAndShape.getPredicate();
            BetweenFilterPanel.selectRangeComboBox(lowerComboBox, filter.f1);
            lowerComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BetweenFloatFilter filter = (BetweenFloatFilter)predicateAndShape.getPredicate();
                    float val = filter.f1.getValue();
                    filter.f1 = BetweenFilterPanel.createAbstractFloatFilter((Integer)((BasicMapEntry)lowerComboBox.getSelectedItem()).getValue());
                    filter.f1.setValue(val);
                    heatMapPanel.setElementPainter(heatMapPanel.getElementPainter());
                }
            });
            final JComboBox upperComboBox = UIUtil.createComboBox(new BasicMapEntry[]{new BasicMapEntry<Integer>(">", 0), new BasicMapEntry<Integer>(">=", 2), new BasicMapEntry<Integer>("<", 1), new BasicMapEntry<Integer>("<=", 3)});
            BetweenFilterPanel.selectRangeComboBox(upperComboBox, filter.f2);
            upperComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BetweenFloatFilter filter = (BetweenFloatFilter)predicateAndShape.getPredicate();
                    float val = filter.f2.getValue();
                    filter.f2 = BetweenFilterPanel.createAbstractFloatFilter((Integer)((BasicMapEntry)upperComboBox.getSelectedItem()).getValue());
                    filter.f2.setValue(val);
                    heatMapPanel.setElementPainter(heatMapPanel.getElementPainter());
                }
            });
            CellConstraints cc = new CellConstraints();
            TimerTextField lowerValueTextField = new TimerTextField(Float.isNaN(filter.f1.getValue()) ? "" : Formatter.toString(Float.valueOf(filter.f1.getValue()))){

                @Override
                public void update() {
                    try {
                        String text = this.getText();
                        if (text != null) {
                            BetweenFilterPanel.this.setLowerValue(ParserHelper.parseFloat(text.trim()));
                        } else {
                            BetweenFilterPanel.this.setLowerValue(Float.NaN);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        BetweenFilterPanel.this.setLowerValue(Float.NaN);
                    }
                }
            };
            TimerTextField upperValueTextField = new TimerTextField(Float.isNaN(filter.f2.getValue()) ? "" : Formatter.toString(Float.valueOf(filter.f2.getValue()))){

                @Override
                public void update() {
                    try {
                        String text = this.getText();
                        if (text != null) {
                            BetweenFilterPanel.this.setUpperValue(ParserHelper.parseFloat(text.trim()));
                        } else {
                            BetweenFilterPanel.this.setUpperValue(Float.NaN);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        BetweenFilterPanel.this.setUpperValue(Float.NaN);
                    }
                }
            };
            JPanel topPanel = new JPanel((LayoutManager)new FormLayout(UIUtil.createColumnStringForFormLayout(5), "p"));
            topPanel.add((Component)lowerComboBox, cc.xy(1, 1));
            topPanel.add((Component)lowerValueTextField, cc.xy(3, 1));
            topPanel.add((Component)new JLabel("and"), cc.xy(5, 1));
            topPanel.add((Component)upperComboBox, cc.xy(7, 1));
            topPanel.add((Component)upperValueTextField, cc.xy(9, 1));
            FormBuilder bottomPanel = new FormBuilder();
            bottomPanel.nextRow();
            bottomPanel.addLabel("Shape:");
            this.shapeComboBox = new ShapeComboBox();
            this.shapeComboBox.setSelectedItem(predicateAndShape.getShapeIndex());
            this.shapeComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Shape shape = BetweenFilterPanel.this.shapeComboBox.getSelectedShape();
                    predicateAndShape.setShape(shape, BetweenFilterPanel.this.shapeComboBox.getSelectedIndex());
                    heatMapPanel.setElementPainter(heatMapPanel.getElementPainter());
                }
            });
            bottomPanel.add(this.shapeComboBox);
            bottomPanel.nextRow();
            bottomPanel.addLabel("Border Color:");
            final ColorComboBox borderColorComboBox = new ColorComboBox();
            borderColorComboBox.setSelectedColor(predicateAndShape.getBorderColor());
            borderColorComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color color = borderColorComboBox.getSelectedColor();
                    predicateAndShape.setBorderColor(color);
                    heatMapPanel.setElementPainter(heatMapPanel.getElementPainter());
                }
            });
            bottomPanel.add((Component)borderColorComboBox);
            bottomPanel.nextRow();
            bottomPanel.addLabel("Border Thickness:");
            TimerTextField borderThicknessTextField = new TimerTextField(predicateAndShape.getBorderStroke() instanceof BasicStroke ? Formatter.format(((BasicStroke)predicateAndShape.getBorderStroke()).getLineWidth()) : "1"){

                @Override
                public void update() {
                    float border = 1.0f;
                    try {
                        String text = this.getText();
                        if (text != null) {
                            border = ParserHelper.parseFloat(text.trim());
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    predicateAndShape.setBorderStroke(new BasicStroke(border));
                    heatMapPanel.setElementPainter(heatMapPanel.getElementPainter());
                }
            };
            bottomPanel.add(borderThicknessTextField);
            bottomPanel.nextRow();
            bottomPanel.addLabel("Fill Color:");
            final ColorComboBox fillColorComboBox = new ColorComboBox();
            fillColorComboBox.setSelectedColor(predicateAndShape.getFillColor());
            fillColorComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color color = fillColorComboBox.getSelectedColor();
                    predicateAndShape.setFillColor(color);
                    heatMapPanel.setElementPainter(heatMapPanel.getElementPainter());
                }
            });
            bottomPanel.add((Component)fillColorComboBox);
            bottomPanel.nextRow();
            final JCheckBox markCheckBox = new JCheckBox("Mark", predicateAndShape.getMark() != -1);
            bottomPanel.addFirstColumn(markCheckBox);
            final JComboBox markWithComboBox = UIUtil.createComboBox(new String[]{"Circle", "Line"});
            markWithComboBox.setSelectedIndex(predicateAndShape.getMark() != -1 ? predicateAndShape.getMark() : 0);
            bottomPanel.add(markWithComboBox);
            ActionListener l = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    predicateAndShape.setMark(markCheckBox.isSelected() ? markWithComboBox.getSelectedIndex() : -1);
                    heatMapPanel.setElementPainter(heatMapPanel.getElementPainter());
                }
            };
            markCheckBox.addActionListener(l);
            markWithComboBox.addActionListener(l);
            FormBuilder datasetFormBuilder = new FormBuilder();
            datasetFormBuilder.nextRow();
            datasetFormBuilder.addLabel("Dataset:");
            datasetFormBuilder.add(this.datasetComboBox);
            this.setLayout(new BorderLayout());
            this.add((Component)datasetFormBuilder.getPanel(), "North");
            this.add(topPanel);
            this.add((Component)bottomPanel.getPanel(), "South");
        }

        @Override
        public String toString() {
            return "";
        }

        protected void setLowerValue(float value) {
            BetweenFloatFilter filter = (BetweenFloatFilter)this.predicateAndShape.getPredicate();
            filter.f1.setValue(value);
            this.heatMapPanel.setElementPainter(this.heatMapPanel.getElementPainter());
        }

        private void setUpperValue(float value) {
            BetweenFloatFilter filter = (BetweenFloatFilter)this.predicateAndShape.getPredicate();
            filter.f2.setValue(value);
            this.heatMapPanel.setElementPainter(this.heatMapPanel.getElementPainter());
        }
    }
}

