/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.genee.chart.BoxAndWhiskerItem;
import org.broadinstitute.genee.chart.XYChartSeries;
import org.broadinstitute.genee.math.FloatListStatUtils;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.FloatList;

public class DefaultBoxPlotChartSeries
implements XYChartSeries {
    private List<BoxAndWhiskerItem> dataItems;
    private String seriesName;
    private float yMax = -3.4028235E38f;
    private float yMin = Float.MAX_VALUE;

    public DefaultBoxPlotChartSeries(String seriesName, int nitems) {
        this.seriesName = seriesName;
        this.dataItems = new ArrayList<BoxAndWhiskerItem>(nitems);
    }

    public void addItem(String name, Dataset values) {
        BoxAndWhiskerItem item = DefaultBoxPlotChartSeries.createBoxAndWhiskerItem(values);
        item.setName(name);
        this.yMin = Math.min(this.yMin, item.getMin());
        this.yMax = Math.max(this.yMax, item.getMax());
        this.dataItems.add(item);
    }

    public BoxAndWhiskerItem getBoxAndWhiskerItem(int index) {
        return this.dataItems.get(index);
    }

    @Override
    public int getItemCount() {
        return this.dataItems.size();
    }

    public String getItemName(int index) {
        return this.dataItems.get(index).getName();
    }

    @Override
    public String getName() {
        return this.seriesName;
    }

    @Override
    public float getX(int index) {
        return index;
    }

    @Override
    public float getXEnd(int index) {
        return (float)index + 0.5f;
    }

    @Override
    public float getXMax() {
        return (float)(this.getItemCount() - 1) + 0.5f;
    }

    @Override
    public float getXMin() {
        return -0.5f;
    }

    @Override
    public float getXStart(int index) {
        return (float)index - 0.5f;
    }

    @Override
    public float getY(int index) {
        return this.dataItems.get(index).getMedian();
    }

    @Override
    public float getYEnd(int index) {
        return this.dataItems.get(index).getQ3();
    }

    @Override
    public float getYMax() {
        return this.yMax;
    }

    @Override
    public float getYMin() {
        return this.yMin;
    }

    @Override
    public float getYStart(int index) {
        return this.dataItems.get(index).getQ1();
    }

    private static BoxAndWhiskerItem createBoxAndWhiskerItem(Dataset dataset) {
        FloatList values = DatasetUtil.asFloatList(dataset);
        float mean = FloatListStatUtils.mean(values);
        float median = FloatListStatUtils.median(values);
        float q1 = FloatListStatUtils.percentile(values, 25);
        float q3 = FloatListStatUtils.percentile(values, 75);
        float w = 1.5f;
        float upperAdjacentValue = -3.4028235E38f;
        float lowerAdjacentValue = Float.MAX_VALUE;
        ArrayList<BoxAndWhiskerItem.Outlier> upperOutliers = new ArrayList<BoxAndWhiskerItem.Outlier>();
        ArrayList<BoxAndWhiskerItem.Outlier> lowerOutliers = new ArrayList<BoxAndWhiskerItem.Outlier>();
        float upperOutlier = q3 + w * (q3 - q1);
        float lowerOutlier = q1 - w * (q3 - q1);
        int nrows = dataset.getRowCount();
        for (int i = 0; i < nrows; ++i) {
            int ncols = dataset.getColumnCount();
            for (int j = 0; j < ncols; ++j) {
                float value = dataset.getValue(i, j);
                if (Float.isNaN(value)) continue;
                if (value <= upperOutlier) {
                    upperAdjacentValue = Math.max(upperAdjacentValue, value);
                }
                if (value >= lowerOutlier) {
                    lowerAdjacentValue = Math.min(lowerAdjacentValue, value);
                }
                if (value > upperOutlier) {
                    upperOutliers.add(new BoxAndWhiskerItem.Outlier(i, j, value));
                }
                if (!(value < lowerOutlier)) continue;
                lowerOutliers.add(new BoxAndWhiskerItem.Outlier(i, j, value));
            }
        }
        float min = FloatListStatUtils.min(values);
        float max = FloatListStatUtils.max(values);
        float standardDeviation = FloatListStatUtils.stdev(values);
        if (lowerAdjacentValue > q1) {
            lowerAdjacentValue = q1;
        }
        if (upperAdjacentValue < q3) {
            upperAdjacentValue = q3;
        }
        return new BoxAndWhiskerItem(mean, median, standardDeviation, q1, q3, min, max, lowerAdjacentValue, upperAdjacentValue, lowerOutliers, upperOutliers);
    }
}

