/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.Map;
import org.broadinstitute.genee.category.QualitativeColorSchemes;
import org.broadinstitute.genee.category.VectorColorModel;
import org.broadinstitute.genee.category.VectorShapeModel;
import org.broadinstitute.genee.category.VectorVisualMapper;
import org.broadinstitute.genee.chart.ChartPropertiesSupplier;
import org.broadinstitute.genee.chart.ChartSelectionModel;
import org.broadinstitute.genee.chart.ShapeUtil;
import org.broadinstitute.genee.chart.XYChartDataset;
import org.broadinstitute.genee.gui.Highlighter;
import org.broadinstitute.genee.matrix.Vector;

public class DefaultChartPropertiesSupplier
implements ChartPropertiesSupplier {
    public static final Stroke DEFAULT_SELECTED_STROKE = new BasicStroke(2.0f, 1, 1);
    public static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f, 1, 1);
    private static final int FADED_ALPHA = 60;
    private ChartSelectionModel chartSelectionModel;
    private Highlighter colorByChartHighlighter;
    private boolean colorBySeries = true;
    private Vector colorByVector;
    private VectorColorModel colorModel;
    private Color defaultColor = QualitativeColorSchemes.getTenColor(0);
    private int itemShape = 0;
    private float maxBarWidth;
    private float maxPointSize;
    private int maxStrokeSize = 9;
    private float minBarWidth;
    private float minPointSize = 2.0f;
    private int minStrokeSize = 1;
    private int minWidthHeight;
    private Highlighter shapeByChartHighlighter;
    private boolean shapeBySeries = true;
    private Vector shapeByVector;
    private Highlighter sizeByChartHighlighter;
    private boolean sizeBySeries = true;
    private Vector sizeByVector;
    private Map<Object, Float> valueToPercent;
    private VectorVisualMapper<Integer> vectorShapeModel;

    @Override
    public float getBarSize(XYChartDataset chartDataset, int datasetIndex, int seriesIndex, int itemIndex) {
        return this.getSize(chartDataset, datasetIndex, seriesIndex, itemIndex, this.minBarWidth, this.maxBarWidth);
    }

    public Highlighter getColorByChartHighlighter() {
        return this.colorByChartHighlighter;
    }

    @Override
    public Color getDefaultColor() {
        return this.defaultColor;
    }

    @Override
    public float getGutter() {
        return this.maxPointSize / 2.0f + 3.0f;
    }

    @Override
    public Color getItemColor(XYChartDataset chartDataset, int datasetIndex, int seriesIndex, int itemIndex) {
        Color color;
        boolean faded = false;
        if (this.chartSelectionModel != null && !this.chartSelectionModel.isEmpty()) {
            if (this.chartSelectionModel.isSelected(datasetIndex, seriesIndex, itemIndex)) {
                return this.defaultColor;
            }
            faded = true;
        }
        Object colorByValue = this.colorByVector != null ? this.colorByVector.getValue(this.getColorByItemIndex(chartDataset, datasetIndex, seriesIndex, itemIndex)) : null;
        Color color2 = color = this.colorByVector != null ? (Color)this.colorModel.getMappedValue(this.colorByVector, colorByValue) : this.defaultColor;
        if (this.colorByVector != null && !this.colorByChartHighlighter.isHighlighted(colorByValue)) {
            faded = true;
        }
        if (this.sizeByVector != null && !this.sizeByChartHighlighter.isHighlighted(this.sizeByVector.getValue(this.getSizeByItemIndex(chartDataset, datasetIndex, seriesIndex, itemIndex)))) {
            faded = true;
        }
        if (this.shapeByVector != null && !this.shapeByChartHighlighter.isHighlighted(this.shapeByVector.getValue(this.getShapeByItemIndex(chartDataset, datasetIndex, seriesIndex, itemIndex)))) {
            faded = true;
        }
        return !faded ? color : new Color(color.getRed(), color.getGreen(), color.getBlue(), 60);
    }

    @Override
    public Shape getItemShape(XYChartDataset chartDataset, int datasetIndex, int seriesIndex, int itemIndex, float pointSize) {
        if (this.shapeByVector != null) {
            Object value = this.shapeByVector != null ? this.shapeByVector.getValue(this.getShapeByItemIndex(chartDataset, datasetIndex, seriesIndex, itemIndex)) : null;
            int index = this.vectorShapeModel.getMappedValue(this.shapeByVector, value);
            return ShapeUtil.getShape(index, pointSize);
        }
        return ShapeUtil.getShape(this.itemShape, pointSize);
    }

    @Override
    public float getItemSize(XYChartDataset chartDataset, int datasetIndex, int seriesIndex, int itemIndex) {
        return this.getSize(chartDataset, datasetIndex, seriesIndex, itemIndex, this.minPointSize, this.maxPointSize);
    }

    @Override
    public Stroke getItemStroke(XYChartDataset chartDataset, int datasetIndex, int seriesIndex, int itemIndex) {
        return this.getStroke(chartDataset, datasetIndex, seriesIndex, itemIndex);
    }

    @Override
    public Stroke getSeriesStroke(XYChartDataset chartDataset, int datasetIndex, int seriesIndex) {
        return this.getStroke(chartDataset, datasetIndex, seriesIndex, 0);
    }

    public Highlighter getShapeByChartHighlighter() {
        return this.shapeByChartHighlighter;
    }

    public Highlighter getSizeByChartHighlighter() {
        return this.sizeByChartHighlighter;
    }

    @Override
    public void init(ChartSelectionModel chartSelectionModel, int width, int height) {
        this.chartSelectionModel = chartSelectionModel;
        this.minWidthHeight = Math.min(width, height);
        this.updateSize();
    }

    public boolean isColorBySeries() {
        return this.colorBySeries;
    }

    @Override
    public boolean isSelected(XYChartDataset chartDataset, int datasetIndex, int seriesIndex, int itemIndex) {
        if (this.chartSelectionModel != null && !this.chartSelectionModel.isEmpty() && this.chartSelectionModel.isSelected(datasetIndex, seriesIndex, itemIndex)) {
            return true;
        }
        if (this.colorByVector != null && !this.colorByChartHighlighter.isHighlightedEmpty() && this.colorByChartHighlighter.isHighlighted(this.colorByVector.getValue(this.getColorByItemIndex(chartDataset, datasetIndex, seriesIndex, itemIndex)))) {
            return true;
        }
        if (this.sizeByVector != null && !this.sizeByChartHighlighter.isHighlightedEmpty() && this.sizeByChartHighlighter.isHighlighted(this.sizeByVector.getValue(this.getSizeByItemIndex(chartDataset, datasetIndex, seriesIndex, itemIndex)))) {
            return true;
        }
        return this.shapeByVector != null && !this.shapeByChartHighlighter.isHighlightedEmpty() && this.shapeByChartHighlighter.isHighlighted(this.shapeByVector.getValue(this.getShapeByItemIndex(chartDataset, datasetIndex, seriesIndex, itemIndex)));
    }

    @Override
    public boolean isSelectionEmpty() {
        if (this.chartSelectionModel != null && !this.chartSelectionModel.isEmpty()) {
            return false;
        }
        if (this.colorByVector != null && !this.colorByChartHighlighter.isHighlightedEmpty()) {
            return false;
        }
        if (this.sizeByVector != null && !this.sizeByChartHighlighter.isHighlightedEmpty()) {
            return false;
        }
        return this.shapeByVector == null || this.shapeByChartHighlighter.isHighlightedEmpty();
    }

    public boolean isShapeBySeries() {
        return this.shapeBySeries;
    }

    @Override
    public boolean isSizeBySeries() {
        return this.sizeBySeries;
    }

    @Override
    public void setColorByChartHighlighter(Highlighter colorByChartHighlighter) {
        this.colorByChartHighlighter = colorByChartHighlighter;
    }

    @Override
    public void setColorBySeries(boolean colorBySeries) {
        this.colorBySeries = colorBySeries;
    }

    @Override
    public void setColorByVector(Vector vector) {
        if (this.colorByChartHighlighter != null) {
            this.colorByChartHighlighter.clearHighlighted(false);
        }
        this.colorByVector = vector;
    }

    @Override
    public void setColorModel(VectorColorModel colorModel) {
        this.colorModel = colorModel;
    }

    @Override
    public void setDefaultColor(Color defaultColor) {
        this.defaultColor = defaultColor;
    }

    public void setItemShape(int itemShape) {
        this.itemShape = itemShape;
    }

    @Override
    public void setShapeByChartHighlighter(Highlighter shapeByChartHighlighter) {
        this.shapeByChartHighlighter = shapeByChartHighlighter;
    }

    @Override
    public void setShapeBySeries(boolean shapeBySeries) {
        this.shapeBySeries = shapeBySeries;
    }

    @Override
    public void setShapeByVector(Vector shapeByVector, VectorVisualMapper<Integer> vectorShapeModel) {
        this.shapeByVector = shapeByVector;
        if (this.shapeByChartHighlighter != null) {
            this.shapeByChartHighlighter.clearHighlighted(false);
        }
        this.vectorShapeModel = vectorShapeModel;
    }

    @Override
    public void setSizeByChartHighlighter(Highlighter sizeByChartHighlighter) {
        this.sizeByChartHighlighter = sizeByChartHighlighter;
    }

    @Override
    public void setSizeBySeries(boolean sizeBySeries) {
        this.sizeBySeries = sizeBySeries;
    }

    @Override
    public void setSizeByVector(Vector sizeByVector, Map<Object, Float> valueToSize) {
        this.sizeByVector = sizeByVector;
        this.valueToPercent = valueToSize;
        this.updateSize();
    }

    public void setVectorShapeModel(VectorShapeModel model) {
        this.vectorShapeModel = model;
    }

    protected int getColorByItemIndex(XYChartDataset chartDataset, int datasetIndex, int seriesIndex, int itemIndex) {
        return this.colorBySeries ? seriesIndex : itemIndex;
    }

    protected int getShapeByItemIndex(XYChartDataset chartDataset, int datasetIndex, int seriesIndex, int itemIndex) {
        return this.shapeBySeries ? seriesIndex : itemIndex;
    }

    protected int getSizeByItemIndex(XYChartDataset chartDataset, int datasetIndex, int seriesIndex, int itemIndex) {
        return this.sizeBySeries ? seriesIndex : itemIndex;
    }

    private float getSize(XYChartDataset chartDataset, int datasetIndex, int seriesIndex, int itemIndex, float minSize, float maxSize) {
        if (this.sizeByVector != null) {
            Object value = this.sizeByVector.getValue(this.getSizeByItemIndex(chartDataset, datasetIndex, seriesIndex, itemIndex));
            Float percent = this.valueToPercent.get(value);
            return maxSize * percent.floatValue() + minSize;
        }
        return maxSize;
    }

    private Stroke getStroke(XYChartDataset chartDataset, int datasetIndex, int seriesIndex, int itemIndex) {
        Stroke stroke;
        boolean selected = this.isSelected(chartDataset, datasetIndex, seriesIndex, itemIndex);
        if (this.sizeByVector != null) {
            Object value = this.sizeByVector.getValue(this.getSizeByItemIndex(chartDataset, datasetIndex, seriesIndex, itemIndex));
            Float percent = this.valueToPercent.get(value);
            stroke = new BasicStroke((selected ? 1.2f : 1.0f) * (percent.floatValue() * (float)this.maxStrokeSize + (float)this.minStrokeSize), 1, 1);
        } else {
            stroke = selected ? DEFAULT_SELECTED_STROKE : DEFAULT_STROKE;
        }
        return stroke;
    }

    private void updateSize() {
        this.maxPointSize = 0.1f * (float)this.minWidthHeight;
        this.maxBarWidth = 0.8f * (float)this.minWidthHeight;
        if (this.valueToPercent != null) {
            if (this.maxPointSize < 8.0f) {
                this.maxPointSize = 8.0f;
            } else if (this.maxPointSize > 22.0f) {
                this.maxPointSize = 22.0f;
            }
            int nvalues = this.valueToPercent.size();
            this.minPointSize = this.maxPointSize / (float)nvalues;
            if (this.minPointSize < 2.0f) {
                this.minPointSize = 2.0f;
            }
            this.minBarWidth = this.maxBarWidth / (float)nvalues;
        } else {
            this.maxPointSize = Math.min(this.maxPointSize, 10.0f);
            if (this.maxPointSize < 4.0f) {
                this.maxPointSize = 4.0f;
            }
            this.minPointSize = 0.0f;
            this.minBarWidth = 0.0f;
        }
    }
}

