/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.TimerTextField;
import org.broadinstitute.genee.io.util.ParserHelper;

public abstract class HistogramOptionsPanel {
    private FormBuilder formBuilder;

    public abstract void setNumberOfBins(int var1);

    public abstract void setLogScale(boolean var1);

    public abstract void setMax(float var1);

    public abstract void setMin(float var1);

    public HistogramOptionsPanel(int initialNumberOfBins) {
        this(initialNumberOfBins, new FormBuilder());
    }

    public HistogramOptionsPanel(int initialNumberOfBins, FormBuilder builder) {
        this(initialNumberOfBins, builder, 200);
    }

    public HistogramOptionsPanel(int initialNumberOfBins, FormBuilder builder, int delay) {
        this.formBuilder = builder;
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 0));
        builder.nextSmallRow();
        TimerTextField binWidthTextField = new TimerTextField("" + initialNumberOfBins, delay){

            @Override
            public void update() {
                try {
                    int tmp = ParserHelper.parseInt(this.getText().trim());
                    if (tmp > 0) {
                        HistogramOptionsPanel.this.setNumberOfBins(tmp);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        final JCheckBox logScaleValuesCheckBox = new JCheckBox("Log 2 values");
        logScaleValuesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistogramOptionsPanel.this.setLogScale(logScaleValuesCheckBox.isSelected());
            }
        });
        builder.addLabel("Number of bins:");
        builder.add(binWidthTextField);
        builder.nextSmallRow();
        builder.add(logScaleValuesCheckBox);
        builder.nextSmallRow();
        final TimerTextField minTextField = new TimerTextField(delay){

            @Override
            public void update() {
                try {
                    String text = this.getText().trim();
                    HistogramOptionsPanel.this.setMin(text.equals("") ? Float.NaN : Float.parseFloat(text));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        final TimerTextField maxTextField = new TimerTextField(delay){

            @Override
            public void update() {
                try {
                    String text = this.getText().trim();
                    HistogramOptionsPanel.this.setMax(text.equals("") ? Float.NaN : Float.parseFloat(text));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        final JCheckBox minCheckBox = new JCheckBox("Custom minimum:");
        builder.addFirstColumn(minCheckBox);
        minCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = minCheckBox.isSelected();
                if (!selected) {
                    HistogramOptionsPanel.this.setMin(Float.NaN);
                } else {
                    String text = minTextField.getText().trim();
                    HistogramOptionsPanel.this.setMin(text.equals("") ? Float.NaN : Float.parseFloat(text));
                }
                minTextField.setEnabled(selected);
            }
        });
        minTextField.setEnabled(false);
        builder.add(minTextField);
        final JCheckBox maxCheckBox = new JCheckBox("Custom maximum:");
        maxCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = maxCheckBox.isSelected();
                if (!selected) {
                    HistogramOptionsPanel.this.setMax(Float.NaN);
                } else {
                    String text = maxTextField.getText().trim();
                    HistogramOptionsPanel.this.setMax(text.equals("") ? Float.NaN : Float.parseFloat(text));
                }
                maxTextField.setEnabled(selected);
            }
        });
        maxTextField.setEnabled(false);
        builder.nextSmallRow();
        builder.addFirstColumn(maxCheckBox);
        builder.add(maxTextField);
    }

    public FormBuilder getFormBuilder() {
        return this.formBuilder;
    }
}

