/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.GeneralPath;
import org.broadinstitute.genee.chart.ChartOverlay;
import org.broadinstitute.genee.chart.GENEEChart;
import org.broadinstitute.genee.heatmap.CoordinateMapper;

public class RegressionOverlay
implements ChartOverlay {
    private float slope = Float.NaN;
    private float b;
    private float xmax;
    private float xmin;
    private Paint paint = Color.GRAY;
    private boolean visible = true;
    private static int STEPS = 10;

    @Override
    public void paint(Graphics2D g2, GENEEChart chartPanel, CoordinateMapper cm) {
        if (Float.isNaN(this.slope) || !this.visible) {
            return;
        }
        g2.setPaint(this.paint);
        float step = (this.xmax - this.xmin) / (float)STEPS;
        float x = this.xmin;
        GeneralPath gp = new GeneralPath();
        for (int i = 0; i <= STEPS; ++i) {
            float y = this.slope * x + this.b;
            if (i == 0) {
                gp.moveTo(cm.xToPix(x), cm.yToPix(y));
            } else {
                gp.lineTo(cm.xToPix(x), cm.yToPix(y));
            }
            x += step;
        }
        g2.draw(gp);
    }

    public void setData(float slope, float b, float xmin, float xmax) {
        this.slope = slope;
        this.b = b;
        this.xmax = xmax;
        this.xmin = xmin;
    }

    public void setPaint(Paint p) {
        this.paint = p;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

