/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class ShapeUtil {
    private ShapeUtil() {
    }

    public static Shape createDiamond(float size) {
        GeneralPath gp = new GeneralPath();
        gp.moveTo(size / 2.0f, 0.0f);
        gp.lineTo(size, size / 2.0f);
        gp.lineTo(size / 2.0f, size);
        gp.lineTo(0.0f, size / 2.0f);
        gp.closePath();
        return gp;
    }

    public static Shape createDownTriangle(float size) {
        GeneralPath gp = new GeneralPath();
        gp.moveTo(size / 2.0f, size);
        gp.lineTo(size, 0.0f);
        gp.lineTo(0.0f, 0.0f);
        gp.closePath();
        return gp;
    }

    public static Shape createLeftTriangle(float size) {
        GeneralPath gp = new GeneralPath();
        gp.moveTo(0.0f, size / 2.0f);
        gp.lineTo(size, 0.0f);
        gp.lineTo(size, size);
        gp.closePath();
        return gp;
    }

    public static Shape createMinus(float size) {
        GeneralPath gp = new GeneralPath();
        gp.moveTo(0.0f, size / 2.0f);
        gp.lineTo(size, size / 2.0f);
        return gp;
    }

    public static Shape createPlus(float size) {
        GeneralPath gp = new GeneralPath();
        gp.moveTo(0.0f, size / 2.0f);
        gp.lineTo(size, size / 2.0f);
        gp.moveTo(size / 2.0f, 0.0f);
        gp.lineTo(size / 2.0f, size);
        return gp;
    }

    public static Shape createRightTriangle(float size) {
        GeneralPath gp = new GeneralPath();
        gp.moveTo(size, size / 2.0f);
        gp.lineTo(0.0f, size);
        gp.lineTo(0.0f, 0.0f);
        gp.closePath();
        return gp;
    }

    public static Shape createUpTriangle(float size) {
        GeneralPath gp = new GeneralPath();
        gp.moveTo(size / 2.0f, 0.0f);
        gp.lineTo(0.0f, size);
        gp.lineTo(size, size);
        gp.closePath();
        return gp;
    }

    public static Shape createX(float size) {
        GeneralPath gp = new GeneralPath();
        gp.moveTo(0.0f, 0.0f);
        gp.lineTo(size, size);
        gp.moveTo(size, 0.0f);
        gp.lineTo(0.0f, size);
        return gp;
    }

    public static Shape getShape(int index, float pointSize) {
        if ((index %= 7) == 0) {
            Ellipse2D.Float circle = new Ellipse2D.Float();
            circle.width = pointSize;
            circle.height = pointSize;
            return circle;
        }
        if (index == 1) {
            Rectangle2D.Float rectangle = new Rectangle2D.Float();
            rectangle.width = pointSize;
            rectangle.height = pointSize;
            return rectangle;
        }
        if (index == 2) {
            return ShapeUtil.createUpTriangle(pointSize);
        }
        if (index == 3) {
            return ShapeUtil.createDownTriangle(pointSize);
        }
        if (index == 4) {
            return ShapeUtil.createLeftTriangle(pointSize);
        }
        if (index == 5) {
            return ShapeUtil.createRightTriangle(pointSize);
        }
        if (index == 6) {
            return ShapeUtil.createDiamond(pointSize);
        }
        Rectangle2D.Float rectangle = new Rectangle2D.Float();
        rectangle.width = pointSize;
        rectangle.height = pointSize;
        return rectangle;
    }
}

