/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart.grid;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.pane.CollapsiblePane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.broadinstitute.genee.chart.grid.ChartGrid;
import org.broadinstitute.genee.chart.grid.ScalingPanel;
import org.broadinstitute.genee.gui.EditColorButton;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.SliderPanel;
import org.broadinstitute.genee.gui.TimerTextField;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.CurveElementList;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.matrix.DatasetUtil;

class ChartGridOptionsComponent {
    private ChartGrid chartGrid;
    private JLabel numberOfBinsLabel;
    private TimerTextField numberOfBinsTextField;
    private ShowCentroidOptionsPanel showCentroidOptionsPanel;
    private JComboBox chartTypeComboBox;
    private JComboBox marksComboBox;
    private JCheckBox ceilingCheckBox;
    private TimerTextField ceilingTextField;
    private JCheckBox floorCheckBox;
    private TimerTextField floorTextField;
    private JLabel marksLabel;
    private JLabel chartWidthLabel;
    private SliderPanel chartWidthPanel;
    private JLabel chartHeightLabel;
    private SliderPanel chartHeightPanel;
    private JPanel mainComponent;
    private JCheckBox synchronizeCheckBox;
    private static final int LABEL_BY_DRAG_DROP_PANEL_INDEX = 0;
    private static final int COLOR_DRAG_DROP_PANEL_INDEX = 1;
    private static final int SIZE_DRAG_DROP_PANEL_INDEX = 2;
    private static final int SHAPE_DRAG_DROP_PANEL_INDEX = 3;
    private JCheckBox boxPlotShowMeanCheckBox = new JCheckBox("Show Mean", true);
    private JCheckBox boxPlotShowMedianCheckBox = new JCheckBox("Show Median", true);
    private JCheckBox boxPlotShowQuantilesCheckBox = new JCheckBox("Show Quantiles", true);
    private JCheckBox boxPlotShowStandardDeviationCheckBox = new JCheckBox("Show Standard Deviation", true);
    private JComboBox boxPlotPointsComboBox;
    private JLabel boxPlotPointsLabel;

    ChartGridOptionsComponent(ChartGrid chartGrid) {
        this.chartGrid = chartGrid;
        FormBuilder basicFormBuilder = new FormBuilder();
        basicFormBuilder.nextRowNoSpace();
        if (!"Row XY Chart".equals(this.chartGrid.getChartType()) && !"Column XY Chart".equals(this.chartGrid.getChartType())) {
            ArrayList<String> items = new ArrayList<String>(Arrays.asList("Row Profile", "Column Profile", "Histogram", "Boxplot"));
            if (DatasetUtil.getSeriesIndex(chartGrid.getProject().getOriginalDataset(), CurveElementList.class) != -1) {
                items.add("Curve Chart");
            }
            this.chartTypeComboBox = UIUtil.createComboBox(items.toArray(new String[0]));
            this.chartTypeComboBox.setSelectedItem(this.chartGrid.getChartType());
            basicFormBuilder.addLabel("Chart Type:");
            basicFormBuilder.add(this.chartTypeComboBox);
        } else {
            this.chartTypeComboBox = UIUtil.createComboBox();
        }
        this.chartTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartGridOptionsComponent.this.chartGrid.setChartType((String)ChartGridOptionsComponent.this.chartTypeComboBox.getSelectedItem());
                String chartType = (String)ChartGridOptionsComponent.this.chartTypeComboBox.getSelectedItem();
                ChartGridOptionsComponent.this.chartGrid.setChartType(chartType);
                ChartGridOptionsComponent.this.setVisibility();
            }
        });
        basicFormBuilder.nextRowNoSpace();
        this.synchronizeCheckBox = new JCheckBox("Synchronize chart with heat map selection", this.chartGrid.isSynchronizeChartWithSelection());
        this.synchronizeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartGridOptionsComponent.this.chartGrid.setSynchronizeChartWithSelection(ChartGridOptionsComponent.this.synchronizeCheckBox.isSelected());
                if (ChartGridOptionsComponent.this.chartGrid.isSynchronizeChartWithSelection()) {
                    ChartGridOptionsComponent.this.chartGrid.updateCharts(false);
                }
            }
        });
        basicFormBuilder.addSpanned(this.synchronizeCheckBox);
        FormBuilder adjustBuilder = new FormBuilder();
        adjustBuilder.nextRowNoSpace();
        this.floorCheckBox = new JCheckBox("Floor");
        this.floorTextField = new TimerTextField(){

            @Override
            public void update() {
                float newValue;
                try {
                    newValue = ParserHelper.parseFloat(this.getText().trim());
                }
                catch (NumberFormatException nfe) {
                    newValue = Float.NaN;
                }
                if (ChartGridOptionsComponent.this.chartGrid.getFloor() != newValue) {
                    ChartGridOptionsComponent.this.chartGrid.setFloor(newValue);
                    ChartGridOptionsComponent.this.chartGrid.updateCharts(true);
                }
            }
        };
        this.floorTextField.setEnabled(false);
        this.floorCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartGridOptionsComponent.this.floorTextField.setEnabled(ChartGridOptionsComponent.this.floorCheckBox.isSelected());
                ChartGridOptionsComponent.this.chartGrid.updateCharts(true);
            }
        });
        adjustBuilder.addFirstColumn(this.floorCheckBox);
        adjustBuilder.add(this.floorTextField);
        adjustBuilder.nextRowNoSpace();
        this.ceilingCheckBox = new JCheckBox("Ceiling");
        this.ceilingTextField = new TimerTextField(){

            @Override
            public void update() {
                float newValue;
                try {
                    newValue = ParserHelper.parseFloat(this.getText().trim());
                }
                catch (NumberFormatException nfe) {
                    newValue = Float.NaN;
                }
                if (ChartGridOptionsComponent.this.chartGrid.getCeiling() != newValue) {
                    ChartGridOptionsComponent.this.chartGrid.setCeiling(newValue);
                    ChartGridOptionsComponent.this.chartGrid.updateCharts(true);
                }
            }
        };
        this.ceilingTextField.setEnabled(false);
        this.ceilingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartGridOptionsComponent.this.ceilingTextField.setEnabled(ChartGridOptionsComponent.this.ceilingCheckBox.isSelected());
                ChartGridOptionsComponent.this.chartGrid.updateCharts(true);
            }
        });
        adjustBuilder.addFirstColumn(this.ceilingCheckBox);
        adjustBuilder.add(this.ceilingTextField);
        adjustBuilder.nextRowNoSpace();
        final JCheckBox logTransformCheckBox = new JCheckBox("Log\u2082", this.chartGrid.isLogScale());
        logTransformCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartGridOptionsComponent.this.chartGrid.setLogScale(logTransformCheckBox.isSelected());
                ChartGridOptionsComponent.this.chartGrid.updateCharts(true);
            }
        });
        adjustBuilder.addSpanned(logTransformCheckBox);
        adjustBuilder.nextRowNoSpace();
        final JCheckBox inverseLogCheckBox = new JCheckBox("Inverse Log\u2082", this.chartGrid.isInverseLogScale());
        inverseLogCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartGridOptionsComponent.this.chartGrid.setInverseLogScale(inverseLogCheckBox.isSelected());
                ChartGridOptionsComponent.this.chartGrid.updateCharts(true);
            }
        });
        adjustBuilder.addSpanned(inverseLogCheckBox);
        adjustBuilder.nextRowNoSpace();
        final JCheckBox zScoreTransformCheckBox = new JCheckBox("Z-Score", this.chartGrid.iszScoreTransform());
        zScoreTransformCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartGridOptionsComponent.this.chartGrid.setzScoreTransform(zScoreTransformCheckBox.isSelected());
                ChartGridOptionsComponent.this.chartGrid.updateCharts(true);
            }
        });
        adjustBuilder.addSpanned(zScoreTransformCheckBox);
        final JCheckBox robustZScoreTransformCheckBox = new JCheckBox("Robust Z-Score", this.chartGrid.isRobustZScoreTransform());
        robustZScoreTransformCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartGridOptionsComponent.this.chartGrid.setRobustZScoreTransform(robustZScoreTransformCheckBox.isSelected());
                ChartGridOptionsComponent.this.chartGrid.updateCharts(true);
            }
        });
        adjustBuilder.nextRowNoSpace();
        adjustBuilder.addSpanned(robustZScoreTransformCheckBox);
        basicFormBuilder.nextRowNoSpace();
        CollapsiblePane adjustPane = new CollapsiblePane("Adjust Data");
        adjustPane.setName("Adjust Data");
        try {
            adjustPane.setCollapsed(true);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        adjustPane.setContentPane((JComponent)adjustBuilder.getPanel());
        basicFormBuilder.addSpanned((Component)adjustPane);
        FormBuilder displayFormBuilder = new FormBuilder();
        displayFormBuilder.nextRowNoSpace();
        displayFormBuilder.addSpanned(this.boxPlotShowMeanCheckBox);
        displayFormBuilder.nextRowNoSpace();
        displayFormBuilder.addSpanned(this.boxPlotShowMedianCheckBox);
        displayFormBuilder.nextRowNoSpace();
        displayFormBuilder.addSpanned(this.boxPlotShowQuantilesCheckBox);
        displayFormBuilder.nextRowNoSpace();
        displayFormBuilder.addSpanned(this.boxPlotShowStandardDeviationCheckBox);
        displayFormBuilder.nextRowNoSpace();
        this.boxPlotPointsComboBox = UIUtil.createComboBox(new String[]{"All points", "Outliers only", "None"});
        this.boxPlotPointsComboBox.setSelectedIndex(1);
        this.boxPlotPointsLabel = displayFormBuilder.addLabel("Points:");
        displayFormBuilder.add(this.boxPlotPointsComboBox);
        this.boxPlotShowMeanCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartGridOptionsComponent.this.chartGrid.getConverter().setProperty("mean", ChartGridOptionsComponent.this.boxPlotShowMeanCheckBox.isSelected());
                ChartGridOptionsComponent.this.chartGrid.updateCharts(false);
            }
        });
        this.boxPlotShowMedianCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartGridOptionsComponent.this.chartGrid.getConverter().setProperty("median", ChartGridOptionsComponent.this.boxPlotShowMedianCheckBox.isSelected());
                ChartGridOptionsComponent.this.chartGrid.updateCharts(false);
            }
        });
        this.boxPlotShowQuantilesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartGridOptionsComponent.this.chartGrid.getConverter().setProperty("quantiles", ChartGridOptionsComponent.this.boxPlotShowQuantilesCheckBox.isSelected());
                ChartGridOptionsComponent.this.chartGrid.updateCharts(false);
            }
        });
        this.boxPlotShowStandardDeviationCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartGridOptionsComponent.this.chartGrid.getConverter().setProperty("standard.deviation", ChartGridOptionsComponent.this.boxPlotShowStandardDeviationCheckBox.isSelected());
                ChartGridOptionsComponent.this.chartGrid.updateCharts(false);
            }
        });
        this.boxPlotPointsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartGridOptionsComponent.this.chartGrid.getConverter().setProperty("points", ChartGridOptionsComponent.this.boxPlotPointsComboBox.getSelectedItem());
                ChartGridOptionsComponent.this.chartGrid.updateCharts(false);
            }
        });
        displayFormBuilder.nextRowNoSpace();
        this.marksLabel = displayFormBuilder.addLabel("Marks:");
        this.marksComboBox = UIUtil.createComboBox(new String[]{"Lines And Points", "Lines Only", "Points Only", "Area"});
        this.marksComboBox.setSelectedIndex(0);
        this.marksComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ChartGridOptionsComponent.this.marksComboBox.getSelectedIndex() == 0) {
                    ChartGridOptionsComponent.this.chartGrid.getConverter().setProperty("points", true);
                    ChartGridOptionsComponent.this.chartGrid.getConverter().setProperty("lines", true);
                    ChartGridOptionsComponent.this.chartGrid.getConverter().setProperty("polygons", false);
                } else if (ChartGridOptionsComponent.this.marksComboBox.getSelectedIndex() == 1) {
                    ChartGridOptionsComponent.this.chartGrid.getConverter().setProperty("points", false);
                    ChartGridOptionsComponent.this.chartGrid.getConverter().setProperty("lines", true);
                    ChartGridOptionsComponent.this.chartGrid.getConverter().setProperty("polygons", false);
                } else if (ChartGridOptionsComponent.this.marksComboBox.getSelectedIndex() == 2) {
                    ChartGridOptionsComponent.this.chartGrid.getConverter().setProperty("points", true);
                    ChartGridOptionsComponent.this.chartGrid.getConverter().setProperty("lines", false);
                    ChartGridOptionsComponent.this.chartGrid.getConverter().setProperty("polygons", false);
                } else if (ChartGridOptionsComponent.this.marksComboBox.getSelectedIndex() == 3) {
                    ChartGridOptionsComponent.this.chartGrid.getConverter().setProperty("points", false);
                    ChartGridOptionsComponent.this.chartGrid.getConverter().setProperty("lines", false);
                    ChartGridOptionsComponent.this.chartGrid.getConverter().setProperty("polygons", true);
                }
                ChartGridOptionsComponent.this.setVisibility();
                ChartGridOptionsComponent.this.chartGrid.updateCharts(false);
            }
        });
        displayFormBuilder.add(this.marksComboBox);
        displayFormBuilder.nextRowNoSpace();
        displayFormBuilder.nextRowNoSpace();
        this.showCentroidOptionsPanel = new ShowCentroidOptionsPanel(this.chartGrid.isCentroidChart(), this.chartGrid.isUseMeanForCentroid()){

            @Override
            protected void setShowCentroid(boolean b) {
                ChartGridOptionsComponent.this.chartGrid.setCentroidChart(b);
                ChartGridOptionsComponent.this.chartGrid.getConverter().setProperty("Centroid", ChartGridOptionsComponent.this.chartGrid.isCentroidChart());
                ChartGridOptionsComponent.this.chartGrid.updateCharts(false);
            }

            @Override
            protected void setUseMeanForCentroid(boolean b) {
                ChartGridOptionsComponent.this.chartGrid.setUseMeanForCentroid(b);
                ChartGridOptionsComponent.this.chartGrid.getConverter().setProperty("Centroid Mean", ChartGridOptionsComponent.this.chartGrid.isUseMeanForCentroid());
                ChartGridOptionsComponent.this.chartGrid.updateCharts(true);
            }
        };
        displayFormBuilder.addSpanned(this.showCentroidOptionsPanel);
        displayFormBuilder.nextRowNoSpace();
        this.numberOfBinsLabel = displayFormBuilder.addLabel("Number of bins:");
        this.numberOfBinsTextField = new TimerTextField("100"){

            @Override
            public void update() {
                try {
                    int numberOfBins = ParserHelper.parseInt(this.getText());
                    ChartGridOptionsComponent.this.chartGrid.getConverter().setProperty("numberOfBins", numberOfBins);
                    ChartGridOptionsComponent.this.chartGrid.updateCharts(true);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        displayFormBuilder.add(this.numberOfBinsTextField);
        displayFormBuilder.nextRowNoSpace();
        displayFormBuilder.addLabel("Y Minimum:");
        displayFormBuilder.add(new ScalingPanel(true, this.chartGrid.getyMinScaling(), this.chartGrid.getCustomYMin()){

            @Override
            protected void setCustomValue(float value) {
                ChartGridOptionsComponent.this.chartGrid.setCustomYMin(value);
                ChartGridOptionsComponent.this.chartGrid.setYAxisScale();
                ChartGridOptionsComponent.this.chartGrid.repaintCharts();
            }

            @Override
            protected void setScalingMode(ChartGrid.ScalingMode scalingMode) {
                ChartGridOptionsComponent.this.chartGrid.setyMinScaling(scalingMode);
                ChartGridOptionsComponent.this.chartGrid.setYAxisScale();
                ChartGridOptionsComponent.this.chartGrid.repaintCharts();
            }
        });
        displayFormBuilder.nextRowNoSpace();
        displayFormBuilder.addLabel("Y Maximum:");
        displayFormBuilder.add(new ScalingPanel(false, this.chartGrid.getyMaxScaling(), this.chartGrid.getCustomYMax()){

            @Override
            protected void setCustomValue(float value) {
                ChartGridOptionsComponent.this.chartGrid.setCustomYMax(value);
                ChartGridOptionsComponent.this.chartGrid.setYAxisScale();
                ChartGridOptionsComponent.this.chartGrid.repaintCharts();
            }

            @Override
            protected void setScalingMode(ChartGrid.ScalingMode scalingMode) {
                ChartGridOptionsComponent.this.chartGrid.setYMaxScalingMode(scalingMode);
                ChartGridOptionsComponent.this.chartGrid.setYAxisScale();
                ChartGridOptionsComponent.this.chartGrid.repaintCharts();
            }
        });
        displayFormBuilder.nextRowNoSpace();
        this.chartWidthLabel = displayFormBuilder.addLabel("Chart Width:");
        this.chartWidthPanel = new SliderPanel(this.chartGrid.getChartWidth(), 10.0f, 1000.0f, 1.0f);
        this.chartWidthPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ChartGridOptionsComponent.this.chartGrid.setChartWidth((int)ChartGridOptionsComponent.this.chartWidthPanel.getValue());
                ChartGridOptionsComponent.this.chartGrid.setChartWidth(ChartGridOptionsComponent.this.chartGrid.getChartWidth());
            }
        });
        displayFormBuilder.add(this.chartWidthPanel);
        displayFormBuilder.nextRowNoSpace();
        this.chartHeightLabel = displayFormBuilder.addLabel("Chart Height:");
        this.chartHeightPanel = new SliderPanel(this.chartGrid.getChartHeight(), 10.0f, 1000.0f, 1.0f);
        this.chartHeightPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ChartGridOptionsComponent.this.chartGrid.setChartHeight((int)ChartGridOptionsComponent.this.chartHeightPanel.getValue());
                ChartGridOptionsComponent.this.chartGrid.setChartHeight(ChartGridOptionsComponent.this.chartGrid.getChartHeight());
            }
        });
        displayFormBuilder.add(this.chartHeightPanel);
        displayFormBuilder.nextRow();
        displayFormBuilder.addLabel("Default Color:");
        final EditColorButton editColorButton = new EditColorButton(this.chartGrid.getDefaultChartColor());
        editColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = editColorButton.getColor();
                ChartGridOptionsComponent.this.chartGrid.setDefaultChartColor(color);
            }
        });
        displayFormBuilder.add(editColorButton);
        CollapsiblePane displayPane = new CollapsiblePane("Display");
        displayPane.setName("Display");
        displayPane.setContentPane((JComponent)displayFormBuilder.getPanel());
        basicFormBuilder.nextRowNoSpace();
        basicFormBuilder.addSpanned((Component)displayPane);
        if (!"Row XY Chart".equals(this.chartGrid.getChartType()) && !"Column XY Chart".equals(this.chartGrid.getChartType())) {
            CollapsiblePane moviePane = new CollapsiblePane("Animate");
            try {
                moviePane.setCollapsed(true);
            }
            catch (PropertyVetoException e1) {
                // empty catch block
            }
            moviePane.setName("Animate");
            moviePane.setContentPane((JComponent)this.chartGrid.getChartMovieControlPanel());
            basicFormBuilder.nextRowNoSpace();
            basicFormBuilder.addSpanned((Component)moviePane);
        }
        basicFormBuilder.getPanel().setMinimumSize(new Dimension());
        this.mainComponent = basicFormBuilder.getPanel();
    }

    public Component getComponent() {
        return this.mainComponent;
    }

    public boolean isCeiling() {
        return this.ceilingCheckBox.isSelected();
    }

    public boolean isFloor() {
        return this.floorCheckBox.isSelected();
    }

    public void setVisibility(int rowCount, int columnCount) {
        this.chartHeightPanel.setVisible(rowCount > 1 || columnCount > 1);
        this.chartHeightLabel.setVisible(this.chartHeightPanel.isVisible());
        this.chartWidthLabel.setVisible(this.chartHeightPanel.isVisible());
        this.chartWidthPanel.setVisible(this.chartHeightPanel.isVisible());
    }

    void setVisibility() {
        int selectedIndex = this.chartTypeComboBox.getSelectedIndex();
        boolean isProfileChart = selectedIndex == 0 || selectedIndex == 1;
        boolean isHistogram = selectedIndex == 2;
        boolean isXYChart = this.chartTypeComboBox.getItemCount() == 0;
        boolean isBoxPlot = selectedIndex == 3;
        this.boxPlotShowMeanCheckBox.setVisible(isBoxPlot);
        this.boxPlotShowMedianCheckBox.setVisible(isBoxPlot);
        this.boxPlotShowQuantilesCheckBox.setVisible(isBoxPlot);
        this.boxPlotShowStandardDeviationCheckBox.setVisible(isBoxPlot);
        this.boxPlotPointsComboBox.setVisible(isBoxPlot);
        this.boxPlotPointsLabel.setVisible(isBoxPlot);
        this.numberOfBinsLabel.setVisible(isHistogram);
        this.numberOfBinsTextField.setVisible(isHistogram);
        this.showCentroidOptionsPanel.setVisible(isProfileChart);
        this.marksLabel.setVisible(isProfileChart);
        this.marksComboBox.setVisible(isProfileChart);
        boolean size = this.chartGrid.getConverter().isSizeBySupported();
        boolean shape = this.chartGrid.getConverter().isShapeBySupported();
        this.chartGrid.getAttributesDragAndDropComponent().setAdditionalDropListPanelVisible(0, isProfileChart);
        this.chartGrid.getAttributesDragAndDropComponent().setAdditionalDropListPanelVisible(1, true);
        this.chartGrid.getAttributesDragAndDropComponent().setAdditionalDropListPanelVisible(2, (isProfileChart || isXYChart) && size);
        this.chartGrid.getAttributesDragAndDropComponent().setAdditionalDropListPanelVisible(3, isProfileChart && shape || isXYChart);
    }

    static abstract class ShowCentroidOptionsPanel
    extends JPanel {
        private JCheckBox showCentroidCheckBox;

        private ShowCentroidOptionsPanel(boolean centroid, boolean mean) {
            this.setLayout((LayoutManager)new FormLayout("p, 6px, p, 6px, p", "p"));
            this.showCentroidCheckBox = new JCheckBox("Show", centroid);
            CellConstraints cc = new CellConstraints();
            final JComboBox meanOrMedianComboBox = UIUtil.createComboBox(new String[]{"mean", "median"});
            meanOrMedianComboBox.setSelectedIndex(mean ? 0 : 1);
            meanOrMedianComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ShowCentroidOptionsPanel.this.setUseMeanForCentroid(meanOrMedianComboBox.getSelectedIndex() == 0);
                }
            });
            this.showCentroidCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ShowCentroidOptionsPanel.this.setShowCentroid(ShowCentroidOptionsPanel.this.showCentroidCheckBox.isSelected());
                }
            });
            this.add((Component)this.showCentroidCheckBox, cc.xy(1, 1));
            this.add((Component)meanOrMedianComboBox, cc.xy(3, 1));
            this.add((Component)new JLabel("profile"), cc.xy(5, 1));
        }

        protected abstract void setShowCentroid(boolean var1);

        protected abstract void setUseMeanForCentroid(boolean var1);
    }
}

