/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart.grid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.chart.Axis;
import org.broadinstitute.genee.chart.BoxPlotChartRenderer;
import org.broadinstitute.genee.chart.ChartToolTipProvider;
import org.broadinstitute.genee.chart.DefaultBoxPlotChartDataset;
import org.broadinstitute.genee.chart.DefaultBoxPlotChartSeries;
import org.broadinstitute.genee.chart.DefaultXYChartDataset;
import org.broadinstitute.genee.chart.DotPlotRenderer;
import org.broadinstitute.genee.chart.GENEEChart;
import org.broadinstitute.genee.chart.ProfileChartSeries;
import org.broadinstitute.genee.chart.XYChartDataset;
import org.broadinstitute.genee.chart.grid.ChartGrid;
import org.broadinstitute.genee.chart.grid.ChartUtil;
import org.broadinstitute.genee.chart.grid.ConvertToChart;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetRowView;
import org.broadinstitute.genee.matrix.DatasetUtil;

public class ConvertToBoxplot
implements ConvertToChart {
    public static final String ALL_POINTS = "All points";
    public static final String NONE = "None";
    public static final String OUTLIERS_ONLY = "Outliers only";
    public static final String POINTS = "points";
    private ChartGrid chartGrid;
    private String points = "Outliers only";
    private Map<String, Boolean> properies = new HashMap<String, Boolean>();
    private float xmax = Float.NaN;
    private float xmin = Float.NaN;

    @Override
    public ConvertToChart copy() {
        ConvertToBoxplot copy = new ConvertToBoxplot();
        copy.properies = new HashMap<String, Boolean>(this.properies);
        return copy;
    }

    @Override
    public void customize(GENEEChart chartPanel, Dataset modelDataset, int[] gridRowIndices, int[] gridColumnIndices, int rowIndex, int columnIndex) {
        BoxPlotChartRenderer boxPlotRenderer = new BoxPlotChartRenderer();
        for (String key : this.properies.keySet()) {
            boxPlotRenderer.setProperty(key, this.properies.get(key));
        }
        DotPlotRenderer dotPlotRenderer = new DotPlotRenderer();
        final Dataset dataset = DatasetUtil.sliceView(modelDataset, gridRowIndices, gridColumnIndices);
        DefaultBoxPlotChartDataset boxPlotDataset = new DefaultBoxPlotChartDataset();
        DefaultBoxPlotChartSeries boxPlotSeries = new DefaultBoxPlotChartSeries("Boxplot", 1);
        boxPlotDataset.addSeries(boxPlotSeries);
        boxPlotSeries.addItem(null, dataset);
        ArrayList<XYChartDataset> chartDatasets = new ArrayList<XYChartDataset>();
        chartDatasets.add(boxPlotDataset);
        if (ALL_POINTS.equals(this.points)) {
            DefaultXYChartDataset chartDataset = new DefaultXYChartDataset();
            int rows = dataset.getRowCount();
            for (int i = 0; i < rows; ++i) {
                DatasetRowView rowView = new DatasetRowView(dataset);
                rowView.setIndex(i);
                ProfileChartSeries series = new ProfileChartSeries(rowView, null, ""){

                    @Override
                    public float getXMax() {
                        return 0.5f;
                    }
                };
                chartDataset.addSeries(series);
            }
            chartDatasets.add(chartDataset);
            dotPlotRenderer.setChartToolTipProvider(new ChartToolTipProvider(){

                @Override
                public List<Map.Entry> getToolTipText(XYChartDataset chartDataset, int seriesIndex, int itemIndex) {
                    return DatasetUtil.getToolTipText(dataset, seriesIndex, itemIndex, null, null);
                }
            });
        }
        this.chartGrid.setProperties(chartPanel, boxPlotRenderer);
        ChartUtil.setChartProperties(chartPanel, this.chartGrid, rowIndex, columnIndex, true, true, boxPlotRenderer);
        this.chartGrid.setProperties(chartPanel, dotPlotRenderer);
        ChartUtil.setChartProperties(chartPanel, this.chartGrid, rowIndex, columnIndex, true, true, dotPlotRenderer);
        chartPanel.setChartRenderer(boxPlotRenderer);
        chartPanel.setChartRenderer(1, dotPlotRenderer);
        chartPanel.setChartDatasets(chartDatasets);
    }

    @Override
    public void customizeXAxis(Axis axis, GENEEChart[][] chartPanelMatrix, int columnIndex) {
    }

    @Override
    public void customizeYAxis(Axis axis, GENEEChart[][] chartPanelMatrix, int rowIndex) {
        axis.setIntegerTicks(false);
    }

    @Override
    public void dispose() {
    }

    public float getXMax() {
        return this.xmax;
    }

    public float getXMin() {
        return this.xmin;
    }

    @Override
    public void init(ChartGrid chartGrid) {
        this.chartGrid = chartGrid;
    }

    @Override
    public boolean isShapeBySupported() {
        return false;
    }

    @Override
    public boolean isSizeBySupported() {
        return false;
    }

    @Override
    public boolean isXAxisVisible() {
        return false;
    }

    @Override
    public void setProperty(String property, Object value) {
        if (POINTS.equals(property)) {
            this.points = (String)value;
            this.properies.put("outliers", this.points.equals(OUTLIERS_ONLY));
        } else {
            this.properies.put(property, (Boolean)value);
        }
    }

    public void setXMax(float xmax) {
        this.xmax = xmax;
    }

    public void setXMin(float xmin) {
        this.xmin = xmin;
    }
}

