/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart.grid;

import com.google.common.base.Function;
import com.jidesoft.swing.StyledLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.broadinstitute.genee.chart.Axis;
import org.broadinstitute.genee.chart.ChartOverlay;
import org.broadinstitute.genee.chart.ChartToolTipProvider;
import org.broadinstitute.genee.chart.DatasetBackedXYChartSeries;
import org.broadinstitute.genee.chart.DefaultXYChartDataset;
import org.broadinstitute.genee.chart.DefaultXYChartSeries;
import org.broadinstitute.genee.chart.GENEEChart;
import org.broadinstitute.genee.chart.LineAndShapeRenderer;
import org.broadinstitute.genee.chart.XYChartDataset;
import org.broadinstitute.genee.chart.grid.ChartGrid;
import org.broadinstitute.genee.chart.grid.ChartUtil;
import org.broadinstitute.genee.chart.grid.ConvertToChart;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.heatmap.CoordinateMapper;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.ToStringUtil;
import org.broadinstitute.genee.math.stat.function.FloatListFunction;
import org.broadinstitute.genee.math.stat.function.Mean;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetAdapter;
import org.broadinstitute.genee.matrix.DatasetRowView;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.FixedSizeAbstractDataset;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataModelItemView;

public class ConvertToXYChart
implements ConvertToChart {
    private ChartGrid chartGrid;
    private boolean columnChart = true;
    private int[] modelXAxisIndices;
    private int[] modelYAxisIndices;
    private StyledLabel xAxisSelectionLabel;
    private StyledLabel yAxisSelectionLabel;

    public ConvertToXYChart(boolean isColumnChart) {
        this.columnChart = isColumnChart;
    }

    @Override
    public ConvertToChart copy() {
        ConvertToXYChart copy = new ConvertToXYChart(this.columnChart);
        return copy;
    }

    @Override
    public void customize(GENEEChart chartPanel, Dataset modelDataset, int[] gridRowIndices, int[] gridColumnIndices, int rowIndex, int columnIndex) {
        Dataset d2;
        Dataset d1;
        Dataset dataset = DatasetUtil.sliceView(modelDataset, gridRowIndices, gridColumnIndices);
        if (!this.columnChart) {
            dataset = DatasetUtil.transposeView(dataset);
        }
        Dataset dataset2 = d1 = this.modelXAxisIndices == null || this.modelXAxisIndices.length == 0 ? new NullDataset("", dataset.getRowCount(), 1) : DatasetUtil.sliceView(dataset, null, this.modelXAxisIndices);
        if (d1.getColumnCount() > 1) {
            d1 = new MeanDataset(d1);
        }
        Dataset dataset3 = d2 = this.modelYAxisIndices == null || this.modelYAxisIndices.length == 0 ? new NullDataset("", dataset.getRowCount(), 1) : DatasetUtil.sliceView(dataset, null, this.modelYAxisIndices);
        if (d2.getColumnCount() > 1) {
            d2 = new MeanDataset(d2);
        }
        boolean addSeries = true;
        if (d1 instanceof NullDataset || d2 instanceof NullDataset) {
            this.chartGrid.setNoDataMessage("Please set the " + (this.columnChart ? "columns" : "rows") + " on the x and y axes");
            addSeries = false;
        } else {
            this.chartGrid.setNoDataMessage("Select " + (this.columnChart ? "rows" : "columns") + " in the heat map");
        }
        LineAndShapeRenderer renderer = new LineAndShapeRenderer();
        renderer.setProperty("lines", false);
        chartPanel.setChartRenderer(renderer);
        this.chartGrid.setProperties(chartPanel, renderer);
        ArrayList<DefaultXYChartDataset> chartDatasets = new ArrayList<DefaultXYChartDataset>();
        DefaultXYChartDataset chartDataset = new DefaultXYChartDataset();
        chartDatasets.add(chartDataset);
        if (addSeries) {
            DatasetBackedXYChartSeries series = new DatasetBackedXYChartSeries(d1, d2, "");
            chartDataset.addSeries(series);
            final SimpleRegression regression = new SimpleRegression();
            int nrows = d2.getRowCount();
            for (int i = 0; i < nrows; ++i) {
                regression.addData((double)d1.getValue(i, 0), (double)d2.getValue(i, 0));
            }
            float intercept = (float)regression.getIntercept();
            float slope = (float)regression.getSlope();
            int npoints = 100;
            float xmin = series.getXMin();
            float xmax = series.getXMax();
            float step = (xmax - xmin) / (float)npoints;
            float x = xmin;
            DefaultXYChartSeries regressionSeries = new DefaultXYChartSeries("Fit", npoints);
            for (int i = 0; i < npoints; ++i) {
                float y = slope * x + intercept;
                regressionSeries.add(x, y);
                x += step;
            }
            chartDatasets.add(new DefaultXYChartDataset(regressionSeries));
            LineAndShapeRenderer regressionRenderer = new LineAndShapeRenderer();
            regressionRenderer.setProperty("lines", true);
            regressionRenderer.setProperty("points", false);
            regressionRenderer.getChartPropertiesSupplier().setDefaultColor(Color.BLACK);
            chartPanel.setChartRenderer(1, regressionRenderer);
            chartPanel.getCoordinateMapper().setRightGutter(250.0f);
            float _x = x - step;
            chartPanel.clearChartOverlays();
            chartPanel.addChartOverlay(new ChartOverlay(){

                @Override
                public void paint(Graphics2D g2, GENEEChart chart, CoordinateMapper coordinateMapper) {
                    String text = "r = " + Formatter.format(regression.getR());
                    int w = g2.getFontMetrics().stringWidth(text);
                    g2.drawString(text, coordinateMapper.getWidth() / 2.0f - (float)(w / 2), 12.0f);
                }
            });
        }
        ChartUtil.setChartProperties(chartPanel, this.chartGrid, rowIndex, columnIndex, true, false, renderer);
        final Dataset _dataset = dataset;
        renderer.setChartToolTipProvider(new ChartToolTipProvider(){

            @Override
            public List<Map.Entry> getToolTipText(XYChartDataset chartDataset, int seriesIndex, int itemIndex) {
                return DatasetUtil.getToolTipText(_dataset, itemIndex, -1, null, null);
            }
        });
        chartPanel.setChartDatasets(chartDatasets);
    }

    @Override
    public void customizeXAxis(Axis axis, GENEEChart[][] charts, int columnIndex) {
        axis.setHorizontalLabelsRotated(false);
        axis.setTickLabels(null, null);
    }

    @Override
    public void customizeYAxis(Axis axis, GENEEChart[][] charts, int rowIndex) {
        axis.setIntegerTicks(false);
    }

    @Override
    public void dispose() {
    }

    @Override
    public void init(ChartGrid _chartGrid) {
        if (this.chartGrid != null) {
            return;
        }
        this.chartGrid = _chartGrid;
        this.chartGrid.setUpdateSelectedDatasetFunction(new Function<Void, ChartGrid.UpdateSelection>(){

            public ChartGrid.UpdateSelection apply(Void v) {
                int[] selectedModelRowIndices = null;
                int[] selectedModelColumnIndices = null;
                if (ConvertToXYChart.this.columnChart) {
                    selectedModelRowIndices = ConvertToXYChart.this.chartGrid.getProject().getModelRowIndices(true, false);
                } else {
                    selectedModelColumnIndices = ConvertToXYChart.this.chartGrid.getProject().getModelColumnIndices(true, false);
                }
                Dataset dataset = ConvertToXYChart.this.chartGrid.getProject().getOriginalDataset();
                return new ChartGrid.UpdateSelection(dataset, selectedModelRowIndices, selectedModelColumnIndices);
            }
        });
        this.xAxisSelectionLabel = new StyledLabel();
        this.xAxisSelectionLabel.setLineWrap(true);
        this.yAxisSelectionLabel = new StyledLabel();
        this.yAxisSelectionLabel.setLineWrap(true);
        JButton xAxisSelectioButton = new JButton("Set to selected " + (this.columnChart ? "columns" : "rows"));
        xAxisSelectioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConvertToXYChart.access$302(ConvertToXYChart.this, ConvertToXYChart.this.columnChart ? ConvertToXYChart.this.chartGrid.getProject().getModelColumnIndices(true, false) : ConvertToXYChart.this.chartGrid.getProject().getModelRowIndices(true, false));
                MetadataModel metadata = ConvertToXYChart.this.columnChart ? ConvertToXYChart.this.chartGrid.getProject().getOriginalDataset().getColumnMetadata() : ConvertToXYChart.this.chartGrid.getProject().getOriginalDataset().getRowMetadata();
                metadata = new MetadataModelItemView(metadata, ConvertToXYChart.this.modelXAxisIndices);
                ConvertToXYChart.this.xAxisSelectionLabel.setText(ToStringUtil.toString(metadata));
                ConvertToXYChart.this.repaintChart(true);
            }
        });
        JButton yAxisSelectioButton = new JButton("Set to selected " + (this.columnChart ? "columns" : "rows"));
        yAxisSelectioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConvertToXYChart.access$602(ConvertToXYChart.this, ConvertToXYChart.this.columnChart ? ConvertToXYChart.this.chartGrid.getProject().getModelColumnIndices(true, false) : ConvertToXYChart.this.chartGrid.getProject().getModelRowIndices(true, false));
                MetadataModel metadata = ConvertToXYChart.this.columnChart ? ConvertToXYChart.this.chartGrid.getProject().getOriginalDataset().getColumnMetadata() : ConvertToXYChart.this.chartGrid.getProject().getOriginalDataset().getRowMetadata();
                metadata = new MetadataModelItemView(metadata, ConvertToXYChart.this.modelYAxisIndices);
                ConvertToXYChart.this.yAxisSelectionLabel.setText(ToStringUtil.toString(metadata));
                ConvertToXYChart.this.repaintChart(true);
            }
        });
        FormBuilder formBuilder = this.chartGrid.getAttributesDragAndDropComponent().getDropListPanelFormBuilder();
        formBuilder.nextRowNoSpace();
        formBuilder.addLabel("X Axis:");
        formBuilder.add(xAxisSelectioButton);
        formBuilder.nextRowNoSpace();
        formBuilder.addSpanned((Component)this.xAxisSelectionLabel);
        formBuilder.nextRowNoSpace();
        formBuilder.addLabel("Y Axis:");
        formBuilder.add(yAxisSelectioButton);
        formBuilder.nextRowNoSpace();
        formBuilder.addSpanned((Component)this.yAxisSelectionLabel);
        this.chartGrid.setNoDataMessage("Please set the " + (this.columnChart ? "columns" : "rows") + " on the x and y axes");
        this.chartGrid.getAttributesDragAndDropComponent().setColumnsDropListPanelVisible(false);
        this.chartGrid.getAttributesDragAndDropComponent().setRowsDropListPanelVisible(false);
        this.chartGrid.getAttributesDragAndDropComponent().setColumnAnnotationsDragPanelVisible(!this.columnChart);
        this.chartGrid.getAttributesDragAndDropComponent().setRowAnnotationsDragPanelVisible(this.columnChart);
    }

    @Override
    public boolean isShapeBySupported() {
        return true;
    }

    @Override
    public boolean isSizeBySupported() {
        return true;
    }

    @Override
    public boolean isXAxisVisible() {
        return true;
    }

    @Override
    public void setProperty(String property, Object value) {
    }

    private void repaintChart(boolean transition) {
        this.chartGrid.updateSelectedDataset(transition);
    }

    static /* synthetic */ int[] access$302(ConvertToXYChart x0, int[] x1) {
        x0.modelXAxisIndices = x1;
        return x1;
    }

    static /* synthetic */ int[] access$602(ConvertToXYChart x0, int[] x1) {
        x0.modelYAxisIndices = x1;
        return x1;
    }

    private static class NullDataset
    extends FixedSizeAbstractDataset {
        protected NullDataset(String name, int rows, int columns) {
            super(name, rows, columns);
        }

        @Override
        public float getValue(int rowIndex, int columnIndex) {
            return rowIndex;
        }

        @Override
        public void setValue(int rowIndex, int columnIndex, float value) {
        }
    }

    private static class MeanDataset
    extends DatasetAdapter {
        private int cachedRow = -1;
        private float cachedRowMean;
        private FloatListFunction f = new Mean();
        private DatasetRowView rowView;

        private MeanDataset(Dataset dataset) {
            super(dataset);
            this.rowView = new DatasetRowView(dataset);
        }

        @Override
        public float getValue(int rowIndex, int columnIndex) {
            if (this.cachedRow != rowIndex) {
                this.rowView.setIndex(rowIndex);
                this.cachedRowMean = this.f.evaluate(this.rowView);
                this.cachedRow = rowIndex;
            }
            return this.cachedRowMean;
        }
    }
}

