/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.clustering.hierarchical;

import gnu.trove.list.array.TIntArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import org.broadinstitute.genee.clustering.hierarchical.AtrGtrDendrogram;
import org.broadinstitute.genee.clustering.hierarchical.DendrogramList;
import org.broadinstitute.genee.clustering.hierarchical.Node;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.HCLCluster;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.LinkageMethod;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.DistanceFunction;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.Identifier;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

class GroupBy {
    int[] reorderedIndices;
    DendrogramList groupByDendrogram;
    Map<Identifier, TIntArrayList> groupByToRowIndices;

    GroupBy(Dataset dataset, String[] groupBy, DistanceFunction metric, LinkageMethod linkageMethod) {
        MetadataModel model = dataset.getRowMetadata();
        Vector[] vectors = new Vector[groupBy.length];
        for (int j = 0; j < vectors.length; ++j) {
            vectors[j] = model.get(groupBy[j]);
        }
        this.groupByToRowIndices = VectorUtil.createValuesToIndicesMap(vectors);
        this.groupByDendrogram = new DendrogramList(metric, linkageMethod);
        TIntArrayList reorderedIndicesList = new TIntArrayList();
        int rowIndexOffset = 0;
        for (final Identifier group : this.groupByToRowIndices.keySet()) {
            TIntArrayList originalRowIndicesForGroup = this.groupByToRowIndices.get(group);
            Dataset groupDataset = DatasetUtil.sliceView(dataset, originalRowIndicesForGroup.toArray(), null);
            if (groupDataset.getRowCount() > 1) {
                HCLCluster hcl = new HCLCluster(groupDataset, linkageMethod, metric){

                    @Override
                    protected String makeID(String name, int i) {
                        String ID = name + i + group + "X";
                        return ID;
                    }
                };
                int[] reorderedGroupIndices = hcl.getIndices();
                int rows = groupDataset.getRowCount();
                for (int i = 0; i < rows; ++i) {
                    int originalIndex = originalRowIndicesForGroup.get(reorderedGroupIndices[i]);
                    reorderedIndicesList.add(originalIndex);
                }
                StringWriter gtrWriter = new StringWriter();
                hcl.writeAtrGtr(new PrintWriter(gtrWriter));
                gtrWriter.flush();
                try {
                    AtrGtrDendrogram gtrReader = new AtrGtrDendrogram(hcl.getReorderedIds(), new AtrGtrDendrogram.BufferedReaderDendrogramReader(new BufferedReader(new StringReader(gtrWriter.getBuffer().toString()))), rowIndexOffset, hcl.getDistanceFunction(), linkageMethod);
                    this.groupByDendrogram.add(gtrReader);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                Node dummyNode = new Node(String.valueOf(group));
                dummyNode.setDistance(0.0f);
                reorderedIndicesList.add(originalRowIndicesForGroup.get(0));
                dummyNode.setIndex(rowIndexOffset);
                this.groupByDendrogram.addRoot(dummyNode);
            }
            rowIndexOffset += groupDataset.getRowCount();
        }
        this.reorderedIndices = reorderedIndicesList.toArray();
    }
}

