/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics;

import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.DistanceFunction;
import org.broadinstitute.genee.matrix.Dataset;

public class Correlation
implements DistanceFunction {
    @Override
    public float evaluate(Dataset dataset, float[] weight, int index1, int index2) {
        float result = 0.0f;
        float sum1 = 0.0f;
        float sum2 = 0.0f;
        float denom1 = 0.0f;
        float denom2 = 0.0f;
        float tweight = 0.0f;
        int n = dataset.getColumnCount();
        for (int i = 0; i < n; ++i) {
            float term1 = dataset.getValue(index1, i);
            float term2 = dataset.getValue(index2, i);
            if (Float.isNaN(term1) || Float.isNaN(term2)) continue;
            float w = weight[i];
            sum1 += w * term1;
            sum2 += w * term2;
            result += w * term1 * term2;
            denom1 += w * term1 * term1;
            denom2 += w * term2 * term2;
            tweight += w;
        }
        if (tweight == 0.0f) {
            return 0.0f;
        }
        result -= sum1 * sum2 / tweight;
        denom1 -= sum1 * sum1 / tweight;
        denom2 -= sum2 * sum2 / tweight;
        if (denom1 <= 0.0f) {
            return 1.0f;
        }
        if (denom2 <= 0.0f) {
            return 1.0f;
        }
        result = (float)((double)result / Math.sqrt(denom1 * denom2));
        result = 1.0f - result;
        return result;
    }

    public String toString() {
        return "One minus pearson correlation";
    }
}

