/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics;

import gnu.trove.list.array.TDoubleArrayList;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.apache.commons.math3.stat.ranking.NaNStrategy;
import org.apache.commons.math3.stat.ranking.NaturalRanking;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.DistanceFunction;
import org.broadinstitute.genee.matrix.Dataset;

public class Spearman
implements DistanceFunction {
    private PearsonsCorrelation corr = new PearsonsCorrelation();
    private NaturalRanking ranking = new NaturalRanking(NaNStrategy.FIXED);

    @Override
    public float evaluate(Dataset dataset, float[] weights, int index1, int index2) {
        TDoubleArrayList list1 = new TDoubleArrayList();
        TDoubleArrayList list2 = new TDoubleArrayList();
        int n = dataset.getColumnCount();
        for (int i = 0; i < n; ++i) {
            float v1 = dataset.getValue(index1, i);
            float v2 = dataset.getValue(index2, i);
            if (Float.isNaN(v1) || Float.isNaN(v2)) continue;
            list1.add((double)v1);
            list2.add((double)v2);
        }
        double[] rank1 = this.ranking.rank(list1.toArray());
        double[] rank2 = this.ranking.rank(list2.toArray());
        return 1.0f - (float)this.corr.correlation(rank1, rank2);
    }

    public static void columnRankNormalize(float[][] array2d) {
        int columns = array2d[0].length;
        int rows = array2d.length;
        NaturalRanking ranking = new NaturalRanking(NaNStrategy.FIXED);
        double[] tmpArray = new double[rows];
        for (int j = 0; j < columns; ++j) {
            for (int i = 0; i < rows; ++i) {
                tmpArray[i] = array2d[i][j];
            }
            double[] ranks = ranking.rank(tmpArray);
            for (int i = 0; i < rows; ++i) {
                array2d[i][j] = (float)ranks[i];
            }
        }
    }

    public String toString() {
        return "One minus spearman's rank correlation";
    }

    public boolean isScaleToOne() {
        return false;
    }
}

