/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.molecule;

import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.DistanceFunction;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.molecule.ExtendedConnectivityFingerprintDistanceFunction;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.molecule.PharmacophoreFingerprintDistanceFunction;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.molecule.TanimotoDistanceFunction;
import org.broadinstitute.genee.matrix.Dataset;

public abstract class AbstractMoleculeDistanceFunction
implements DistanceFunction {
    protected String moleculeColumnName;

    public AbstractMoleculeDistanceFunction(String moleculeColumnName) {
        this.moleculeColumnName = moleculeColumnName;
    }

    @Override
    public float evaluate(Dataset dataset, float[] weight, int index1, int index2) {
        Molecule term1 = (Molecule)dataset.getRowMetadata().getValue(index1, this.moleculeColumnName);
        Molecule term2 = (Molecule)dataset.getRowMetadata().getValue(index2, this.moleculeColumnName);
        if (term1 == null || term2 == null) {
            return 0.0f;
        }
        return this.getDistance(term1, term2);
    }

    public String getMoleculeColumnName() {
        return this.moleculeColumnName;
    }

    public void setMoleculeColumnName(String moleculeColumnName) {
        this.moleculeColumnName = moleculeColumnName;
    }

    public abstract String toString();

    protected abstract float getDistance(Molecule var1, Molecule var2);

    public static List<AbstractMoleculeDistanceFunction> getFunctions(String moleculeColumnName) {
        ArrayList<AbstractMoleculeDistanceFunction> functions = new ArrayList<AbstractMoleculeDistanceFunction>();
        functions.add(new TanimotoDistanceFunction(moleculeColumnName));
        functions.add(new PharmacophoreFingerprintDistanceFunction(moleculeColumnName));
        functions.add(new ExtendedConnectivityFingerprintDistanceFunction(moleculeColumnName));
        return functions;
    }
}

