/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap;

import chemaxon.descriptors.CFParameters;
import chemaxon.descriptors.ChemicalFingerprint;
import chemaxon.formats.MolImporter;
import chemaxon.struc.Molecule;

public class ClusterCompounds {
    static final String smile = "CC1CCC2CC(C(=CC=CC=CC(CC(C(=O)C(C(C(=CC(C(=O)CC(OC(=O)C3CCCCN3C(=O)C(=O)C1(O2)O)C(C)CC4CCC(C(C4)OC)O)C)C)O)OC)C)C)C)OC";
    private static Molecule mol;

    public static void main(String[] args) throws Exception {
        ClusterCompounds.test1();
    }

    public static void test1() throws Exception {
        Molecule mol1 = mol;
        Molecule mol2 = mol;
        CFParameters pars = new CFParameters();
        ChemicalFingerprint cfp1 = new ChemicalFingerprint(pars);
        ChemicalFingerprint cfp2 = new ChemicalFingerprint(pars);
        cfp1.generate(mol1);
        cfp2.generate(mol2);
        float dissim = cfp1.getTanimoto(cfp2);
        System.out.println("Tanimoto dissimilarity = " + dissim);
        System.out.println(cfp1.toBinaryString());
    }

    static {
        try {
            mol = MolImporter.importMol((String)smile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

