/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap;

import chemaxon.descriptors.CFParameters;
import chemaxon.descriptors.ChemicalFingerprint;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.formats.MolFormatException;
import chemaxon.struc.Molecule;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.broadinstitute.genee.compound.MoleculeUtil;
import org.broadinstitute.genee.io.excel.Array2DContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.util.IOUtil;

public class ToSmart {
    public static void main(String[] args) throws MolFormatException, IOException {
        String file = args[0];
        if (file.toLowerCase().endsWith(".sdf")) {
            File f = new File(file);
            List<Molecule> molecules = MoleculeUtil.read(f);
            PrintWriter pw = new PrintWriter(new FileWriter(new File(f.getParentFile(), IOUtil.getBaseFileName(f) + "-smarts.txt")));
            pw.print("Name\tFormula\tComment");
            Molecule test = molecules.get(0);
            String[] properties = new String[test.getPropertyCount()];
            int count = test.getPropertyCount();
            for (int i = 0; i < count; ++i) {
                properties[i] = test.getPropertyKey(i);
                pw.print("\t");
                pw.print(properties[i]);
            }
            pw.print("\tSMILE\tBit String");
            for (Molecule m : molecules) {
                pw.print(m.getName());
                pw.print("\t");
                pw.print(m.getFormula());
                pw.print("\t");
                pw.print(m.getComment());
                int nprops = properties.length;
                for (int i = 0; i < nprops; ++i) {
                    pw.print("\t");
                    pw.print(m.getPropertyObject(properties[i]));
                }
                ChemicalFingerprint cfp1 = new ChemicalFingerprint(new CFParameters());
                String bitString = "";
                try {
                    cfp1.generate(m);
                    bitString = cfp1.toBinaryString();
                }
                catch (MDGeneratorException e) {
                    // empty catch block
                }
                pw.print("\t");
                try {
                    pw.print(m.toFormat("smiles"));
                }
                catch (Exception x) {
                    pw.print("");
                }
                pw.print("\t");
                pw.println(bitString);
            }
            pw.close();
        } else {
            String[][] data = ((Array2DContentHandler)new ExcelReader(file, new Array2DContentHandler()).getContentHandler()).getData();
            File f = new File(file);
            PrintWriter pw = new PrintWriter(new FileWriter(new File(f.getParentFile(), IOUtil.getBaseFileName(f) + "-smarts.txt")));
            int smileIndex = -1;
            int cols = data[0].length;
            for (int j = 0; j < cols; ++j) {
                if (j > 0) {
                    pw.print("\t");
                }
                if (data[0][j].toLowerCase().indexOf("smile") != -1) {
                    smileIndex = j;
                }
                pw.print(data[0][j]);
            }
            pw.println("\tBit String");
            if (smileIndex == -1) {
                System.err.println("No SMILE column found.");
                return;
            }
            int length = data.length;
            for (int i = 1; i < length; ++i) {
                int cols2 = data[0].length;
                for (int j = 0; j < cols2; ++j) {
                    if (j > 0) {
                        pw.print("\t");
                    }
                    pw.print(data[i][j]);
                    ChemicalFingerprint cfp1 = new ChemicalFingerprint(new CFParameters());
                    String bitString = "";
                    try {
                        Molecule m = MoleculeUtil.read(data[i][smileIndex]);
                        cfp1.generate(m);
                        bitString = cfp1.toBinaryString();
                    }
                    catch (MDGeneratorException e) {
                        // empty catch block
                    }
                    pw.print("\t");
                    pw.println(bitString);
                }
            }
            pw.close();
        }
    }
}

