/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.geo;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPTransferType;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.broadinstitute.genee.io.excel.Array2DContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.util.ArchiveUtil;
import org.broadinstitute.genee.io.util.IOUtil;

public class ArrayExpressUtil {
    private static FTPClient ftp;

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Usage array-express-id dest-dir");
            System.exit(0);
        }
        ArrayExpressUtil.downloadRawFiles(args[0], new File(args[1]));
    }

    public static synchronized List<String> listBaseCelFileNames(String id) throws Exception {
        ArrayExpressUtil.init();
        id = id.toUpperCase();
        String base = id.substring(id.indexOf(45) + 1, id.lastIndexOf(45));
        String dir = "/pub/databases/microarray/data/experiment/" + base + "/" + id;
        ArrayList<String> names = new ArrayList<String>();
        try {
            ftp.chdir(dir);
            String name = id + ".sdrf.txt";
            File tmpFile = File.createTempFile("array_express", ".txt");
            ftp.get(tmpFile.getCanonicalPath(), name);
            String[][] data = ((Array2DContentHandler)new ExcelReader(tmpFile.getCanonicalPath(), new Array2DContentHandler()).getContentHandler()).getData();
            int arrayIndex = Arrays.asList(data[0]).indexOf("Array Data File");
            int length = data.length;
            for (int i = 1; i < length; ++i) {
                String[] row = data[i];
                names.add(id + "-" + IOUtil.getBaseFileName(row[arrayIndex]));
            }
        }
        catch (Exception x) {
            // empty catch block
        }
        return names;
    }

    public static synchronized List<File> downloadRawFiles(String id, File destDir) throws Exception {
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        ArrayExpressUtil.init();
        id = id.toUpperCase();
        String base = id.substring(id.indexOf(45) + 1, id.lastIndexOf(45));
        String dir = "/pub/databases/microarray/data/experiment/" + base + "/" + id;
        try {
            ftp.chdir(dir);
            String[] files = ftp.dir();
            if (files != null) {
                for (String f : files) {
                    String name = f.toLowerCase();
                    if (!name.contains("raw") || !name.endsWith(".zip")) continue;
                    ftp.get(new File(destDir, f).getCanonicalPath(), f);
                }
            }
        }
        catch (Exception x) {
            // empty catch block
        }
        File[] zips = destDir.listFiles();
        for (File zip : zips) {
            ArchiveUtil.unzip(zip, destDir);
            zip.delete();
        }
        File[] celFiles = destDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().toLowerCase().contains(".cel");
            }
        });
        ArrayList<File> files = new ArrayList<File>();
        for (File cel : celFiles) {
            File renamed = new File(cel.getParentFile(), id + "-" + cel.getName());
            cel.renameTo(renamed);
            if (!renamed.getName().toLowerCase().endsWith(".gz")) {
                ArchiveUtil.gzip(renamed);
                renamed = new File(renamed.getParentFile(), renamed.getName() + ".gz");
            }
            files.add(renamed);
        }
        return files;
    }

    private static synchronized void init() {
        if (ftp == null) {
            try {
                FTPClient ftp = new FTPClient();
                ftp.setTimeout(2000);
                ftp.setRetryCount(0);
                ftp.setRemoteHost("ftp.ebi.ac.uk");
                ftp.connect();
                ftp.login("anonymous", "anonymous");
                ftp.setType(FTPTransferType.BINARY);
                ArrayExpressUtil.ftp = ftp;
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        } else if (!ftp.connected()) {
            try {
                ftp.setRemoteHost("ftp.ncbi.nih.gov");
                ftp.connect();
                ftp.login("anonymous", "anonymous");
                ftp.setType(FTPTransferType.BINARY);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }
}

