/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.gui;

import java.io.File;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.h5.H5File;

public class H5TreeView
extends JTree {
    private final DefaultMutableTreeNode root = new DefaultMutableTreeNode(){

        @Override
        public boolean isLeaf() {
            return false;
        }
    };
    private final DefaultTreeModel treeModel;
    private final List fileList = new Vector();
    private FileFormat selectedFile;
    private DefaultMutableTreeNode selectedNode = null;
    private HObject selectedObject;
    private boolean moveFlag = false;
    private TreePath[] currentSelectionsForMove = null;

    public H5TreeView() {
        this.treeModel = new DefaultTreeModel(this.root);
        this.setModel(this.treeModel);
        this.setLargeModel(true);
        this.setRootVisible(false);
    }

    public void addObject(HObject newObject, Group parentGroup) throws Exception {
        if (newObject == null || parentGroup == null) {
            return;
        }
        TreeNode pnode = this.findTreeNode((HObject)parentGroup);
        DefaultMutableTreeNode newnode = null;
        newnode = newObject instanceof Group ? new DefaultMutableTreeNode(newObject){

            @Override
            public boolean isLeaf() {
                return false;
            }
        } : new DefaultMutableTreeNode(newObject);
        this.treeModel.insertNodeInto(newnode, (DefaultMutableTreeNode)pnode, pnode.getChildCount());
    }

    public void closeFile(FileFormat file) throws Exception {
        if (file == null) {
            return;
        }
        FileFormat theFile = null;
        DefaultMutableTreeNode theNode = null;
        Enumeration<TreeNode> enumeration = this.root.children();
        while (enumeration.hasMoreElements()) {
            theNode = (DefaultMutableTreeNode)enumeration.nextElement();
            Group g = (Group)theNode.getUserObject();
            theFile = g.getFileFormat();
            if (!theFile.equals((Object)file)) continue;
            this.treeModel.removeNodeFromParent(theNode);
            try {
                theFile.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.fileList.remove(theFile);
            if (!theFile.equals((Object)this.selectedFile)) break;
            this.selectedFile = null;
            this.selectedNode = null;
            break;
        }
    }

    public TreeNode findTreeNode(HObject obj) {
        if (obj == null) {
            return null;
        }
        TreeNode theFileRoot = obj.getFileFormat().getRootNode();
        if (theFileRoot == null) {
            return null;
        }
        DefaultMutableTreeNode theNode = null;
        HObject theObj = null;
        Enumeration<TreeNode> local_enum = ((DefaultMutableTreeNode)theFileRoot).breadthFirstEnumeration();
        while (local_enum.hasMoreElements()) {
            theNode = (DefaultMutableTreeNode)local_enum.nextElement();
            theObj = (HObject)theNode.getUserObject();
            if (theObj == null || !theObj.equals(obj)) continue;
            return theNode;
        }
        return null;
    }

    public List getCurrentFiles() {
        return this.fileList;
    }

    public HObject getCurrentObject() {
        return this.selectedObject;
    }

    public FileFormat getSelectedFile() {
        return this.selectedFile;
    }

    public List getSelectedObjects() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null || paths.length <= 0) {
            return null;
        }
        Vector<HObject> objs = new Vector<HObject>(paths.length);
        HObject theObject = null;
        DefaultMutableTreeNode currentNode = null;
        DefaultMutableTreeNode parentNode = null;
        for (int i = 0; i < paths.length; ++i) {
            currentNode = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
            theObject = (HObject)currentNode.getUserObject();
            if (theObject == null) continue;
            objs.add(theObject);
            parentNode = (DefaultMutableTreeNode)currentNode.getParent();
            HObject parentObject = (HObject)parentNode.getUserObject();
            objs.remove(parentObject);
        }
        return objs;
    }

    public FileFormat openFile(String filename) throws Exception {
        MutableTreeNode fileRoot = null;
        File tmpFile = new File(filename);
        if (!tmpFile.exists()) {
            throw new UnsupportedOperationException("File does not exist.");
        }
        FileFormat f = FileFormat.getFileFormat((String)"HDF5");
        H5File h5File = (H5File)f.createFile(filename, 11);
        h5File.open();
        fileRoot = (MutableTreeNode)h5File.getRootNode();
        if (fileRoot != null) {
            this.insertNode(fileRoot, this.root);
            int currentRowCount = this.getRowCount();
            if (currentRowCount > 0) {
                this.expandRow(this.getRowCount() - 1);
            }
            this.fileList.add(h5File);
        }
        return h5File;
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        return menu;
    }

    private void insertNode(TreeNode node, TreeNode pnode) {
        if (node == null || pnode == null) {
            return;
        }
        this.treeModel.insertNodeInto((DefaultMutableTreeNode)node, (DefaultMutableTreeNode)pnode, pnode.getChildCount());
    }

    private boolean isFileOpen(String filename) {
        boolean isOpen = false;
        FileFormat theFile2 = null;
        for (FileFormat theFile2 : this.fileList) {
            if (!theFile2.getFilePath().equals(filename)) continue;
            isOpen = true;
            break;
        }
        return isOpen;
    }

    private void removeNode(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
        if (parentNode != null) {
            this.treeModel.removeNodeFromParent(node);
            Group pgroup = (Group)parentNode.getUserObject();
            pgroup.removeFromMemberList((HObject)node.getUserObject());
            if (node.equals(this.selectedNode)) {
                this.selectedNode = null;
                this.selectedFile = null;
            }
        }
    }

    private void removeSelectedObjects() {
        int op;
        FileFormat theFile = this.getSelectedFile();
        if (theFile.isThisType(FileFormat.getFileFormat((String)"HDF4"))) {
            JOptionPane.showMessageDialog(this, "Unsupported operation: cannot delete HDF4 object.", "HDFView", 0);
            return;
        }
        TreePath[] currentSelections = this.getSelectionPaths();
        if (this.moveFlag) {
            currentSelections = this.currentSelectionsForMove;
        }
        if (currentSelections == null || currentSelections.length <= 0) {
            return;
        }
        if (!this.moveFlag && (op = JOptionPane.showConfirmDialog(this, "Do you want to remove all the selected object(s) ?", "Remove object", 0)) == 1) {
            return;
        }
        String frameName = "";
        HObject theObj = null;
        for (int i = 0; i < currentSelections.length; ++i) {
            Group g;
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)currentSelections[i].getLastPathComponent();
            theObj = (HObject)currentNode.getUserObject();
            if (theObj instanceof Group && (g = (Group)theObj).isRoot()) {
                JOptionPane.showMessageDialog(this, "Unsupported operation: cannot delete the file root.", "HDFView", 0);
                return;
            }
            try {
                theFile.delete(theObj);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex, "HDFView", 0);
                continue;
            }
            if (theObj.equals(this.selectedObject)) {
                this.selectedObject = null;
            }
            this.removeNode(currentNode);
        }
    }

    private void renameObject() {
        if (this.selectedObject == null) {
            return;
        }
        if (this.selectedObject instanceof Group && ((Group)this.selectedObject).isRoot()) {
            JOptionPane.showMessageDialog(this, "Cannot rename the root.", "HDFView", 0);
            return;
        }
        boolean isH4 = this.selectedObject.getFileFormat().isThisType(FileFormat.getFileFormat((String)"HDF4"));
        if (isH4) {
            JOptionPane.showMessageDialog(this, "Cannot rename HDF4 object.", "HDFView", 0);
            return;
        }
        String oldName = this.selectedObject.getName();
        String newName = JOptionPane.showInputDialog(this, "Rename \"" + oldName + "\" to:", "Rename...", 1);
        if (newName == null) {
            return;
        }
        if ((newName = newName.trim()) == null || newName.length() == 0 || newName.equals(oldName)) {
            return;
        }
        try {
            this.selectedObject.setName(newName);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "HDFView", 0);
        }
    }

    private static final HObject find(String objName, TreePath treePath, JTree tree) {
        HObject retObj = null;
        boolean isFound = false;
        boolean isPrefix = false;
        boolean isSuffix = false;
        boolean isContain = false;
        if (objName == null || objName.length() <= 0 || treePath == null) {
            return null;
        }
        if (objName.equals("*")) {
            return null;
        }
        if (objName.startsWith("*")) {
            isSuffix = true;
            objName = objName.substring(1, objName.length());
        }
        if (objName.endsWith("*")) {
            isPrefix = true;
            objName = objName.substring(0, objName.length() - 1);
        }
        if (isPrefix && isSuffix) {
            isContain = true;
            isSuffix = false;
            isPrefix = false;
        }
        if (objName == null || objName.length() <= 0) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (node == null) {
            return null;
        }
        HObject obj = null;
        String theName = null;
        DefaultMutableTreeNode theNode = null;
        Enumeration<TreeNode> local_enum = node.breadthFirstEnumeration();
        while (local_enum.hasMoreElements()) {
            theNode = (DefaultMutableTreeNode)local_enum.nextElement();
            obj = (HObject)theNode.getUserObject();
            if (obj == null || (theName = obj.getName()) == null || !(isFound = isPrefix ? theName.startsWith(objName) : (isSuffix ? theName.endsWith(objName) : (isContain ? theName.contains(objName) : theName.equals(objName))))) continue;
            retObj = obj;
            break;
        }
        if (retObj != null) {
            TreePath dstPath = H5TreeView.getTreePath(treePath, theNode, 0);
            tree.setSelectionPath(dstPath);
            tree.scrollPathToVisible(dstPath);
        }
        return retObj;
    }

    private static TreePath getTreePath(TreePath parent, TreeNode node, int depth) {
        if (node == null || parent == null || depth < 0) {
            return null;
        }
        TreeNode theNode = (TreeNode)parent.getLastPathComponent();
        if (node == theNode) {
            return parent;
        }
        if (theNode.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = theNode.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                TreePath result = H5TreeView.getTreePath(path, node, depth + 1);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }
}

