/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.gui;

import java.io.IOException;
import java.util.Collection;
import java.util.TreeSet;
import javax.swing.text.JTextComponent;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.broadinstitute.genee.gui.DelimListDataIntelliHints;
import org.broadinstitute.genee.heatmap.AbstractQuickFilterPanel;

public class LuceneAutocomplete
extends DelimListDataIntelliHints {
    private AbstractQuickFilterPanel qs;
    private IndexReader reader;

    public LuceneAutocomplete(IndexReader reader, JTextComponent textComponent, AbstractQuickFilterPanel qs) {
        super(textComponent);
        this.qs = qs;
        this.reader = reader;
    }

    public String getField() {
        String field;
        String string = field = this.qs != null ? this.qs.getDefaultFilterColumnName() : null;
        if ("All".equals(field)) {
            field = null;
        }
        return field;
    }

    @Override
    public Collection<String> getMatches(String text) {
        String field = this.getField();
        TreeSet<String> matches = new TreeSet<String>();
        try {
            TermEnum tmp = this.reader.terms(new Term(field != null ? field : "", text));
            String baseSearchText = text.toLowerCase();
            int colonIndex = baseSearchText.indexOf(58);
            if (colonIndex != -1) {
                baseSearchText = baseSearchText.substring(colonIndex);
            }
            while (tmp.next() && matches.size() < 11) {
                String s = tmp.term().text();
                if (!s.startsWith(baseSearchText)) continue;
                matches.add(s);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return matches;
    }
}

