/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.query;

import java.util.Arrays;
import org.broadinstitute.genee.math.stat.function.Max;
import org.broadinstitute.genee.math.stat.function.Min;

public class CMapQuery {
    private float[] scores;
    private float[] downScores;
    private float[] upScores;

    public void execute(int[] upTagIndices, int[] downTagIndices, short[][] ranks) {
        short[] upTagsRanks = new short[upTagIndices.length];
        short[] downTagsRanks = new short[downTagIndices.length];
        int numInstances = ranks.length;
        float ntags = ranks[0].length;
        this.upScores = new float[numInstances];
        this.downScores = new float[numInstances];
        this.scores = new float[numInstances];
        int numUpTags = upTagsRanks.length;
        int numDownTags = downTagsRanks.length;
        for (int instanceIndex = 0; instanceIndex < numInstances; ++instanceIndex) {
            int i;
            short[] instanceArray = ranks[instanceIndex];
            for (i = 0; i < numUpTags; ++i) {
                upTagsRanks[i] = instanceArray[upTagIndices[i]];
            }
            Arrays.sort(upTagsRanks);
            for (i = 0; i < numDownTags; ++i) {
                downTagsRanks[i] = instanceArray[downTagIndices[i]];
            }
            Arrays.sort(downTagsRanks);
            this.compute(instanceIndex, upTagsRanks, downTagsRanks, ntags);
        }
        this.normalizeScores();
    }

    private void compute(int instance, short[] upRanks, short[] downRanks, float numberOfProbes) {
        float upScore = CMapQuery.computeKS(upRanks, numberOfProbes);
        float downScore = CMapQuery.computeKS(downRanks, numberOfProbes);
        float diff = 0.0f;
        if ((double)upScore > 0.0 && (double)downScore < 0.0 || (double)upScore < 0.0 && (double)downScore > 0.0) {
            diff = upScore - downScore;
        }
        this.upScores[instance] = upScore;
        this.downScores[instance] = downScore;
        this.scores[instance] = diff;
    }

    private void normalizeScores() {
        float maxDiff = Max.evaluate(this.scores);
        int length = this.scores.length;
        for (int i = 0; i < length; ++i) {
            if (!(this.scores[i] > 0.0f)) continue;
            this.scores[i] = this.scores[i] / maxDiff;
        }
        float minDiff = -Min.evaluate(this.scores);
        int length2 = this.scores.length;
        for (int i = 0; i < length2; ++i) {
            if (!(this.scores[i] < 0.0f)) continue;
            this.scores[i] = this.scores[i] / minDiff;
        }
    }

    public static float computeKS(short[] ranks, float numberOfProbeSets) {
        int rankedListSize = ranks.length;
        float max = 0.0f;
        float min = 0.0f;
        float currMax = 0.0f;
        float currMin = 0.0f;
        for (int i = 0; i < rankedListSize; ++i) {
            currMax = (float)(i + 1) / (float)rankedListSize - (float)ranks[i] / numberOfProbeSets;
            currMin = (float)ranks[i] / numberOfProbeSets - (float)i / (float)rankedListSize;
            if (currMax > max) {
                max = currMax;
            }
            if (!(currMin > min)) continue;
            min = currMin;
        }
        float score = min > max ? -min : max;
        return score;
    }

    public float[] getScores() {
        return this.scores;
    }

    public float[] getDownScores() {
        return this.downScores;
    }

    public float[] getUpScores() {
        return this.upScores;
    }
}

