/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.query;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.broadinstitute.genee.cmap.query.UserCMapQueryResult;
import org.broadinstitute.genee.gui.ListSelectionActionEnabler;
import org.broadinstitute.genee.gui.MousePopupListener;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.table.FilterableTableModel;
import org.broadinstitute.genee.table.TableUtil;

public class CMapQueryHistoryComponent {
    private JTable table;
    private HistoryTableModel historyTableModel = new HistoryTableModel();
    private FilterableTableModel filterableTableModel = new FilterableTableModel(this.historyTableModel);
    private JPanel p;
    private AbstractAction deleteAction;
    private AbstractAction viewAction;
    private JPopupMenu popup;

    public CMapQueryHistoryComponent() {
        this.table = new JTable(this.filterableTableModel);
        this.table.setGridColor(UIUtil.LIGHT_BLUE);
        TableUtil.setSortable(this.table, this.filterableTableModel);
        this.p = new JPanel(new BorderLayout());
        this.p.add(UIUtil.createNoBorderScrollPane(this.table));
        this.deleteAction = new AbstractAction("Delete"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selection;
                for (int row : selection = CMapQueryHistoryComponent.this.table.getSelectedRows()) {
                    CMapQueryHistoryComponent.this.historyTableModel.list.remove(row);
                }
                CMapQueryHistoryComponent.this.filterableTableModel.filter();
            }
        };
        this.viewAction = new AbstractAction("View"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selection;
                for (int row : selection = CMapQueryHistoryComponent.this.table.getSelectedRows()) {
                    UserCMapQueryResult r = (UserCMapQueryResult)CMapQueryHistoryComponent.this.historyTableModel.list.get(row);
                }
            }
        };
        this.popup = new JPopupMenu();
        this.table.addMouseListener(new MousePopupListener(this.popup));
        new ListSelectionActionEnabler(this.table.getSelectionModel(), this.deleteAction, this.viewAction);
        JPanel topPanel = new JPanel();
        topPanel.add(new JButton(this.deleteAction));
        topPanel.add(new JButton(this.viewAction));
        this.p.add((Component)topPanel, "North");
    }

    public Component getComponent() {
        return this.p;
    }

    public void add(UserCMapQueryResult result) {
        this.historyTableModel.add(result);
        this.filterableTableModel.filter();
    }

    private static class HistoryTableModel
    extends AbstractTableModel {
        private List<UserCMapQueryResult> list = new ArrayList<UserCMapQueryResult>();
        private static final String[] COLUMN_NAMES = new String[]{"Name", "Date"};
        private static final Class<?>[] COLUMN_CLASSES = new Class[]{String.class, Date.class};

        private HistoryTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        public void add(UserCMapQueryResult result) {
            this.list.add(result);
        }

        @Override
        public Class<?> getColumnClass(int j) {
            return COLUMN_CLASSES[j];
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public String getColumnName(int j) {
            return COLUMN_NAMES[j];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            UserCMapQueryResult r = this.list.get(rowIndex);
            if (columnIndex == 0) {
                return r.getQueryName();
            }
            if (columnIndex == 1) {
                return r.getQuerySubmittedDate();
            }
            return null;
        }
    }
}

