/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.rankedlist;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockableHolderPanel;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.swing.JideLabel;
import com.jidesoft.swing.JideSplitPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.cmap.rankedlist.ColorByLegend;
import org.broadinstitute.genee.cmap.rankedlist.HighlightTrack;
import org.broadinstitute.genee.cmap.rankedlist.HighlightTrackEvent;
import org.broadinstitute.genee.cmap.rankedlist.HighlightTrackListener;
import org.broadinstitute.genee.cmap.rankedlist.RankedListComponent;
import org.broadinstitute.genee.cmap.rankedlist.RankedListDropComponent;
import org.broadinstitute.genee.cmap.rankedlist.RankedListMetadataDragComponent;
import org.broadinstitute.genee.cmap.rankedlist.RankedListOptionsPanel;
import org.broadinstitute.genee.cmap.rankedlist.RankedListTable;
import org.broadinstitute.genee.cmap.rankedlist.RankedListTableModel;
import org.broadinstitute.genee.cmap.rankedlist.SizeByLegend;
import org.broadinstitute.genee.filter.AbstractFloatFilter;
import org.broadinstitute.genee.filter.RankedListFilterableAttribute;
import org.broadinstitute.genee.gui.CartesianProductHeader;
import org.broadinstitute.genee.gui.Drawable;
import org.broadinstitute.genee.gui.DrawableSpacer;
import org.broadinstitute.genee.gui.DrawableWrapper;
import org.broadinstitute.genee.gui.JideSplitPaneSynchronizer;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.grid.AttributesDragAndDropComponent;
import org.broadinstitute.genee.gui.scroll.RankedListVerticalScrollBarUIHelper;
import org.broadinstitute.genee.heatmap.menu.HorizontalDrawableArray;
import org.broadinstitute.genee.heatmap.menu.VerticalDrawableArray;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.matrix.rankedlist.AverageRankedList;
import org.broadinstitute.genee.matrix.rankedlist.DatasetRankedList;
import org.broadinstitute.genee.matrix.rankedlist.RankedList;
import org.broadinstitute.genee.matrix.rankedlist.RankedListCollection;
import org.broadinstitute.genee.matrix.rankedlist.SlicedRankedList;
import org.broadinstitute.genee.table.TableDrawer;

public class RankedListController
implements Drawable {
    private RankedListTable rankedListTable;
    private RankedListTableModel rankedListTableModel;
    private JideSplitPane horizontalSplitter;
    private boolean showHighlightedInstancesOnly = false;
    private RankedListComponent selectedRankedListComponent;
    private JLabel selectedLabel;
    private RankedListOptionsPanel optionsPanel;
    private ChangeListener modelChangeListener;
    private RankedListVerticalScrollBarUIHelper rankedListVerticalScrollBarUIHelper;
    private JScrollPane rankedListOptionsScrollPane;
    private GENEEWindow optionsDialog;
    private DockableHolderPanel dockableHolderPanel;
    private RankedListDropComponent rankedListDropComponent;
    private DockingManager dockingManager;
    private boolean includeTableInSavedImage = true;
    private String labelBy;
    private JPanel rankedListsPanel;
    private JPanel columnHeaderPanel;
    private JPanel rowHeaderPanel;
    private RankedListComponent[][] rankedListComponents = new RankedListComponent[0][0];
    private RankedListCollection rankedListCollection;
    private JideSplitPane rightVerticalSplitPane;
    private JideSplitPane rankedListHorizontalSplitter;
    private CartesianProductHeader[] rowProductHeaders;
    private CartesianProductHeader[] columnProductHeaders;
    private int gridColumns = Integer.MAX_VALUE;
    private boolean showRowNames;
    private boolean showColumnNames;
    private boolean wrapRankedLists = false;
    private int drawReferenceMode = 0;
    private AbstractFloatFilter maskFilter;
    private int maskAlpha = 60;
    private boolean showAverageRankedList = false;
    private List<String> labelByChoices;

    public RankedListController(RankedListCollection rankedListCollection, RankedList prototypeRankedList, List<String> labelByChoices, String labelBy) {
        this.rankedListCollection = rankedListCollection;
        this.labelBy = labelBy;
        this.labelByChoices = labelByChoices;
        List<RankedListMetadataDragComponent.RankedListAttribute> rankedListAttributes = RankedListMetadataDragComponent.createAttributes(prototypeRankedList);
        ArrayList<RankedListFilterableAttribute> filterableAttributes = new ArrayList<RankedListFilterableAttribute>();
        filterableAttributes.addAll(rankedListAttributes);
        filterableAttributes.add(new RankedListMetadataDragComponent.AdvancedQueryAttribute("Advanced", prototypeRankedList));
        this.modelChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RankedListController.this.setRankedLists();
            }
        };
        RankedListFilterableAttribute[] attributes = filterableAttributes.toArray(new RankedListFilterableAttribute[0]);
        this.rankedListDropComponent = new RankedListDropComponent(prototypeRankedList, attributes, rankedListCollection.getInstanceColorModel());
        this.rankedListTableModel = new RankedListTableModel();
        UIUtil.setElements(this.rankedListDropComponent.getLabelRankedListsByComboBox(), labelByChoices);
        this.rankedListDropComponent.getLabelRankedListsByComboBox().setSelectedItem(labelBy);
        this.rankedListDropComponent.getLabelRankedListsByComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RankedListController.this.labelBy = (String)RankedListController.this.rankedListDropComponent.getLabelRankedListsByComboBox().getSelectedItem();
                RankedListCollection rankedListCollection = RankedListController.this.getRankedListCollection();
                int size = rankedListCollection.size();
                for (int i = 0; i < size; ++i) {
                    RankedList rl = rankedListCollection.getRankedList(i);
                    if (!(rl instanceof DatasetRankedList)) continue;
                    ((DatasetRankedList)rl).setLabelBy(RankedListController.this.labelBy);
                }
                RankedListController.this.setRankedLists();
            }
        });
        this.rankedListTable = new RankedListTable(this.rankedListDropComponent.getHighlightTrack(), this.rankedListTableModel);
        this.horizontalSplitter = new JideSplitPane(1);
        this.rankedListVerticalScrollBarUIHelper = new RankedListVerticalScrollBarUIHelper(this.rankedListTable, this.rankedListDropComponent.getHighlightTrack(), prototypeRankedList);
        JScrollPane tableScrollPane = new JScrollPane(this.rankedListTable);
        tableScrollPane.getVerticalScrollBar().setUI(RankedListVerticalScrollBarUIHelper.createScrollBarUI(this.rankedListVerticalScrollBarUIHelper));
        tableScrollPane.setMinimumSize(new Dimension());
        this.rankedListsPanel = new JPanel();
        this.dockableHolderPanel = new DockableHolderPanel();
        this.dockingManager = this.dockableHolderPanel.getDockingManager();
        AttributesDragAndDropComponent.configureDockingManager(this.dockingManager);
        JComponent dragComponent = new RankedListMetadataDragComponent(prototypeRankedList, attributes).getComponent();
        JComponent[] legends = new JComponent[]{new ColorByLegend(this.rankedListDropComponent.getHighlightTrack()), new SizeByLegend(this.rankedListDropComponent.getHighlightTrack())};
        DockableFrame[] legendFrames = new DockableFrame[legends.length];
        for (int i = 0; i < legends.length; ++i) {
            JComponent legend = legends[i];
            DockableFrame frame = AttributesDragAndDropComponent.createDockableFrame(4, i + 1, i == 0 ? "Color" : "Size", null);
            JScrollPane sp = AttributesDragAndDropComponent.createScrollPane(legend, frame);
            sp.setBackground(UIManager.getColor("Panel.background"));
            frame.getContentPane().add(sp);
            this.dockingManager.addFrame(frame);
            legendFrames[i] = frame;
        }
        this.rankedListDropComponent.getComponent().setMinimumSize(new Dimension());
        JPanel tableAndLabelPanel = new JPanel(new BorderLayout());
        tableAndLabelPanel.setMinimumSize(new Dimension());
        this.selectedLabel = UIUtil.createBoldLabel(" ");
        tableAndLabelPanel.add((Component)this.selectedLabel, "North");
        tableAndLabelPanel.add(tableScrollPane);
        this.rankedListDropComponent.getHighlightTrack().addHighlightTrackListener(new HighlightTrackListener(){

            @Override
            public void trackChanged(HighlightTrackEvent e) {
                RankedListController.this.setSelectedRankedListComponent(RankedListController.this.selectedRankedListComponent, true);
                RankedListController.this.rankedListTable.revalidate();
                RankedListController.this.rankedListTable.repaint();
                RankedListController.this.setRankedLists();
            }
        });
        this.optionsPanel = new RankedListOptionsPanel(this);
        this.rankedListOptionsScrollPane = UIUtil.createNoBorderScrollPane(this.optionsPanel);
        this.dockingManager.addFrame(AttributesDragAndDropComponent.createDockableFrame(8, 0, "Annotations", UIUtil.createNoBorderScrollPane(dragComponent)));
        this.dockingManager.addFrame(AttributesDragAndDropComponent.createDockableFrame(4, 0, "View", UIUtil.createNoBorderScrollPane(this.rankedListDropComponent.getComponent())));
        DockableFrame f = AttributesDragAndDropComponent.createDockableFrame(2, 0, "Selected Ranked List Table", tableAndLabelPanel);
        f.setDockedHeight(200);
        this.dockingManager.addFrame(f);
        this.dockingManager.loadLayoutData();
        for (int i = 0; i < legendFrames.length; ++i) {
            legendFrames[i].getDockingManager().hideFrame(legendFrames[i].getKey());
        }
        this.horizontalSplitter.addPane((Component)this.dockableHolderPanel);
        this.columnHeaderPanel = new JPanel();
        this.rowHeaderPanel = new JPanel();
        rankedListCollection.addChangeListener(this.modelChangeListener);
        this.rightVerticalSplitPane = new JideSplitPane(0);
        JScrollPane rankedListScrollPane = UIUtil.createNoBorderScrollPane(this.rankedListsPanel);
        JScrollPane columnHeaderScrollPane = UIUtil.createNoBorderScrollPane(this.columnHeaderPanel);
        columnHeaderScrollPane.getHorizontalScrollBar().setModel(rankedListScrollPane.getHorizontalScrollBar().getModel());
        columnHeaderScrollPane.setHorizontalScrollBarPolicy(31);
        columnHeaderScrollPane.setVerticalScrollBarPolicy(21);
        this.rightVerticalSplitPane.addPane((Component)columnHeaderScrollPane);
        this.rightVerticalSplitPane.addPane((Component)rankedListScrollPane);
        JideSplitPane leftVerticalSplitPane = new JideSplitPane(0);
        JScrollPane rowHeaderScrollPane = UIUtil.createNoBorderScrollPane(this.rowHeaderPanel);
        rowHeaderScrollPane.setHorizontalScrollBarPolicy(31);
        rowHeaderScrollPane.setVerticalScrollBarPolicy(21);
        rowHeaderScrollPane.getVerticalScrollBar().setModel(rankedListScrollPane.getVerticalScrollBar().getModel());
        leftVerticalSplitPane.addPane((Component)new JPanel());
        leftVerticalSplitPane.addPane((Component)rowHeaderScrollPane);
        this.rankedListHorizontalSplitter = new JideSplitPane(1);
        this.rankedListHorizontalSplitter.addPane((Component)leftVerticalSplitPane);
        this.rankedListHorizontalSplitter.addPane((Component)this.rightVerticalSplitPane);
        this.horizontalSplitter.addPane((Component)this.rankedListHorizontalSplitter);
        this.setRankedLists();
        this.optionsPanel.setPropertiesFromSavedSettings(null);
        new JideSplitPaneSynchronizer(leftVerticalSplitPane, this.rightVerticalSplitPane);
    }

    public String getLabelBy() {
        return this.labelBy;
    }

    public void setLabelBy(String labelBy) {
        this.labelBy = labelBy;
    }

    public void dispose() {
        this.dockingManager.removeAllFrames();
        this.dockingManager.dispose();
    }

    @Override
    public void draw(Graphics g, Rectangle clip) {
        this.getDrawable().draw(g, clip);
    }

    public Component getComponent() {
        return this.horizontalSplitter;
    }

    @Override
    public Dimension getDrawableSize() {
        return this.getDrawable().getDrawableSize();
    }

    public int getGridColumns() {
        return this.gridColumns;
    }

    public AbstractFloatFilter getMaskFilter() {
        return this.maskFilter;
    }

    public ChangeListener getModelChangeListener() {
        return this.modelChangeListener;
    }

    public RankedListCollection getRankedListCollection() {
        return this.rankedListCollection;
    }

    public RankedListComponent[][] getRankedListComponents() {
        return this.rankedListComponents;
    }

    public RankedListDropComponent getRankedListDropComponent() {
        return this.rankedListDropComponent;
    }

    public RankedListComponent getSelectedRankedListComponent() {
        return this.selectedRankedListComponent;
    }

    public boolean isIncludeTableInSavedImage() {
        return this.includeTableInSavedImage;
    }

    public boolean isShowHighlightedInstancesOnly() {
        return this.showHighlightedInstancesOnly;
    }

    public boolean isSyncSelection() {
        return this.optionsPanel.isSyncSelection();
    }

    public boolean isWrapRankedLists() {
        return this.wrapRankedLists;
    }

    public void setBarHeight(int value) {
        RankedListComponent[][] arr$ = this.rankedListComponents;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            RankedListComponent[] array;
            for (RankedListComponent c : array = arr$[i$]) {
                if (c == null) continue;
                c.setBarHeight(value);
            }
        }
        this.revalidateAndRepaintAll();
    }

    public void setBarWidth(int value) {
        RankedListComponent[][] arr$ = this.rankedListComponents;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            RankedListComponent[] array;
            for (RankedListComponent c : array = arr$[i$]) {
                if (c == null) continue;
                c.setBarWidth(value);
            }
        }
        this.revalidateAndRepaintAll();
    }

    public void setDrawGradient(boolean b) {
        RankedListComponent[][] arr$ = this.rankedListComponents;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            RankedListComponent[] array;
            for (RankedListComponent c : array = arr$[i$]) {
                if (c == null) continue;
                c.setDrawGradient(b);
            }
        }
    }

    public void setDrawRanks(boolean b) {
        RankedListComponent[][] arr$ = this.rankedListComponents;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            RankedListComponent[] array;
            for (RankedListComponent c : array = arr$[i$]) {
                if (c == null) continue;
                c.setDrawRanks(b);
            }
        }
        this.revalidateAndRepaintAll();
    }

    public void setDrawReferenceMode(int mode) {
        this.drawReferenceMode = mode;
        RankedListComponent[][] arr$ = this.rankedListComponents;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            RankedListComponent[] array;
            for (RankedListComponent c : array = arr$[i$]) {
                if (c == null) continue;
                c.setDrawReferenceMode(this.drawReferenceMode);
            }
        }
        this.revalidateAndRepaintAll();
    }

    public void setGridColumns(boolean wrapRankedLists, int columns, boolean doLayout) {
        if (columns < 1) {
            columns = 1;
        }
        this.wrapRankedLists = wrapRankedLists;
        this.gridColumns = columns;
        if (doLayout) {
            this.setRankedLists();
        }
    }

    public void setIncludeTableInSavedImage(boolean includeTableInSavedImage) {
        this.includeTableInSavedImage = includeTableInSavedImage;
    }

    public void setLineThickness(float value) {
        RankedListComponent[][] arr$ = this.rankedListComponents;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            RankedListComponent[] array;
            for (RankedListComponent c : array = arr$[i$]) {
                if (c == null) continue;
                c.setLineThickness(value);
            }
        }
        this.revalidateAndRepaintAll();
    }

    public void setMaskAlpha(int maskAlpha) {
        this.maskAlpha = maskAlpha;
        RankedListComponent[][] arr$ = this.rankedListComponents;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            RankedListComponent[] array;
            for (RankedListComponent c : array = arr$[i$]) {
                if (c == null) continue;
                c.setMaskAlpha(maskAlpha);
            }
        }
        this.revalidateAndRepaintAll();
    }

    public void setMaskFilter(AbstractFloatFilter maskFilter) {
        this.maskFilter = maskFilter;
        RankedListComponent[][] arr$ = this.rankedListComponents;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            RankedListComponent[] array;
            for (RankedListComponent c : array = arr$[i$]) {
                if (c == null) continue;
                c.setMaskFilter(maskFilter);
            }
        }
        this.revalidateAndRepaintAll();
    }

    public void setNegativeColor(Color color) {
        RankedListComponent[][] arr$ = this.rankedListComponents;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            RankedListComponent[] array;
            for (RankedListComponent c : array = arr$[i$]) {
                if (c == null) continue;
                c.setNegativeColor(color);
            }
        }
    }

    public void setNullColor(Color color) {
        RankedListComponent[][] arr$ = this.rankedListComponents;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            RankedListComponent[] array;
            for (RankedListComponent c : array = arr$[i$]) {
                if (c == null) continue;
                c.setNullColor(color);
            }
        }
    }

    public void setPositiveColor(Color color) {
        RankedListComponent[][] arr$ = this.rankedListComponents;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            RankedListComponent[] array;
            for (RankedListComponent c : array = arr$[i$]) {
                if (c == null) continue;
                c.setPositiveColor(color);
            }
        }
    }

    public void setShowHighlightedInstancesOnly(boolean showHighlightedInstancesOnly) {
        this.showHighlightedInstancesOnly = showHighlightedInstancesOnly;
    }

    public void showOptionsDialog() {
        if (this.optionsDialog == null) {
            this.optionsDialog = Application.createDialog(this.getComponent(), "Ranked List Options");
            this.optionsDialog.getContentPane().add(this.rankedListOptionsScrollPane);
            this.optionsDialog.pack();
        }
        this.optionsDialog.setVisible(true);
    }

    void revalidateAndRepaintAll() {
        this.rowHeaderPanel.revalidate();
        this.rowHeaderPanel.repaint();
        this.columnHeaderPanel.revalidate();
        this.columnHeaderPanel.repaint();
        this.rankedListsPanel.revalidate();
        this.rankedListsPanel.repaint();
        this.rankedListHorizontalSplitter.setDividerLocations(new int[]{Math.min(100, this.rowHeaderPanel.getPreferredSize().width)});
        this.rightVerticalSplitPane.setDividerLocations(new int[]{Math.min(100, this.columnHeaderPanel.getPreferredSize().height)});
    }

    void setSelectedRankedListComponent(RankedListComponent rankedListComponent, boolean force) {
        if (force || rankedListComponent != this.selectedRankedListComponent) {
            if (rankedListComponent != null) {
                this.selectedRankedListComponent = rankedListComponent;
                Border selectionBorder = BorderFactory.createLineBorder(UIUtil.SELECTION_COLOR, 2);
                Border border = this.getBorder(rankedListComponent);
                if (border != null) {
                    selectionBorder = BorderFactory.createCompoundBorder(selectionBorder, border);
                }
                this.selectedLabel.setText(rankedListComponent.getRankedList().getName());
            }
            if (this.showHighlightedInstancesOnly && this.rankedListDropComponent.getHighlightTrack().getAllInstanceIds().size() > 0) {
                this.rankedListTableModel.setRankedList(new SlicedRankedList(rankedListComponent.getRankedList(), this.rankedListDropComponent.getHighlightTrack().getAllInstanceIds()), rankedListComponent.getRankedList());
                this.rankedListVerticalScrollBarUIHelper.setRankedList(new SlicedRankedList(this.rankedListTableModel.getFullRankedList(), this.rankedListDropComponent.getHighlightTrack().getAllInstanceIds()));
            } else {
                this.rankedListTableModel.setRankedList(rankedListComponent.getRankedList(), rankedListComponent.getRankedList());
                this.rankedListVerticalScrollBarUIHelper.setRankedList(rankedListComponent.getRankedList());
            }
        }
    }

    private RankedList[][] get2dArray() {
        if (!this.wrapRankedLists || this.gridColumns > this.rankedListCollection.size()) {
            RankedList[][] array = this.rankedListCollection.size() == 0 ? new RankedList[0][0] : new RankedList[1][this.rankedListCollection.size() + (this.showAverageRankedList ? 1 : 0)];
            ArrayList<RankedList> averageList = new ArrayList<RankedList>();
            int size = this.rankedListCollection.size();
            for (int j = 0; j < size; ++j) {
                RankedList rl;
                array[0][j] = rl = this.rankedListCollection.getRankedList(j);
                if (!this.showAverageRankedList) continue;
                averageList.add(rl);
            }
            if (this.showAverageRankedList) {
                array[0][this.rankedListCollection.size()] = new AverageRankedList(averageList.toArray(new RankedList[0]));
            }
            return array;
        }
        int gridRows = (int)Math.ceil((double)this.rankedListCollection.size() / (double)this.gridColumns);
        RankedList[][] array = new RankedList[gridRows][this.gridColumns];
        int rowIndex = 0;
        int columnIndex = 0;
        int size = this.rankedListCollection.size();
        for (int listIndex = 0; listIndex < size; ++listIndex) {
            array[rowIndex][columnIndex] = this.rankedListCollection.getRankedList(listIndex);
            if (++columnIndex % this.gridColumns != 0) continue;
            columnIndex = 0;
            ++rowIndex;
        }
        int rowsToRemove = 0;
        for (int i = array.length - 1; i >= 0 && array[i][0] == null; --i) {
            ++rowsToRemove;
        }
        if (rowsToRemove > 0) {
            RankedList[][] copy = new RankedList[array.length - rowsToRemove][];
            int length = copy.length;
            for (int i = 0; i < length; ++i) {
                copy[i] = array[i];
            }
            array = copy;
        }
        return array;
    }

    private Border getBorder(RankedListComponent rankedListComponent) {
        return !this.showRowNames && !this.showColumnNames ? new TitledBorder(BorderFactory.createEmptyBorder(), rankedListComponent.getRankedList().getName()) : null;
    }

    /*
     * WARNING - void declaration
     */
    private Drawable getDrawable() {
        ArrayList<Drawable> rows = new ArrayList<Drawable>();
        rows.add(new DrawableWrapper(this.columnHeaderPanel));
        for (int i = 0; i < this.rankedListComponents.length; ++i) {
            Drawable[] array = this.rankedListComponents[i];
            HorizontalDrawableArray horizontalDrawable = new HorizontalDrawableArray(array);
            ArrayList<Drawable> tmp = new ArrayList<Drawable>();
            tmp.add(new DrawableWrapper(this.rowHeaderPanel.getComponent(i)));
            tmp.addAll(Arrays.asList(horizontalDrawable.getArray()));
            rows.add(new HorizontalDrawableArray(tmp.toArray(new Drawable[0])));
        }
        if (this.includeTableInSavedImage) {
            ArrayList<Drawable> tables = new ArrayList<Drawable>();
            if (this.rankedListDropComponent.getHighlightTrack().getAllInstanceIds().size() > 0) {
                void var6_11;
                ArrayList<4> tableDrawers = new ArrayList<4>();
                RankedListComponent[][] arr$ = this.rankedListComponents;
                int len$ = arr$.length;
                boolean bl = false;
                while (var6_11 < len$) {
                    RankedListComponent[] array;
                    for (RankedListComponent c : array = arr$[var6_11]) {
                        if (c == null) continue;
                        RankedListTableModel tableModel = new RankedListTableModel();
                        tableModel.setRankedList(new SlicedRankedList(c.getRankedList(), this.rankedListDropComponent.getHighlightTrack().getAllInstanceIds()), c.getRankedList());
                        JTable table = new JTable(tableModel);
                        table.setGridColor(UIUtil.LIGHT_BLUE);
                        TableDrawer tableDrawer = new TableDrawer(table){

                            @Override
                            public void draw(Graphics g, Rectangle clip) {
                                g.translate(0, 25);
                                super.draw(g, clip);
                                g.translate(0, -25);
                            }

                            @Override
                            public Dimension getDrawableSize() {
                                Dimension d = super.getDrawableSize();
                                d.height += 2;
                                return d;
                            }

                            @Override
                            protected float getPosition(int row) {
                                return this.table.getCellRect((int)row, (int)0, (boolean)true).y;
                            }

                            @Override
                            protected float getRowSize() {
                                return this.table.getRowHeight();
                            }

                            @Override
                            protected int getRowEnd(Rectangle clip) {
                                return this.table.rowAtPoint(new Point(0, clip.y + clip.height));
                            }

                            @Override
                            protected int getRowStart(Rectangle clip) {
                                return this.table.rowAtPoint(new Point(0, clip.y));
                            }
                        };
                        tableDrawer.init();
                        tableDrawers.add(tableDrawer);
                        String name = c.getRankedList().getName();
                        name = IOUtil.truncate(name, 60);
                        JLabel label = new JLabel(name);
                        label.setToolTipText(name);
                        tables.add(new DrawableWrapper(label));
                        tables.add(tableDrawer);
                        tables.add(new DrawableSpacer(0, 30));
                    }
                    ++var6_11;
                }
                int[] columnWidths = ((TableDrawer)tableDrawers.get(0)).getColumnWidths();
                for (TableDrawer tableDrawer : tableDrawers) {
                    int[] w = tableDrawer.getColumnWidths();
                    for (int i = 0; i < columnWidths.length; ++i) {
                        columnWidths[i] = Math.max(w[i], columnWidths[i]);
                    }
                }
                for (TableDrawer tableDrawer : tableDrawers) {
                    tableDrawer.setColumnWidths(columnWidths);
                }
                for (int i = 0; i < tables.size(); ++i) {
                    rows.add((Drawable)tables.get(i));
                }
            }
        }
        return new VerticalDrawableArray(rows.toArray(new Drawable[0]));
    }

    private void moveList(RankedListComponent[] rankedListComponents, int elementIndex, int newIndex) {
        if (elementIndex != newIndex) {
            if (newIndex < 0) {
                throw new IllegalArgumentException("new index out of range");
            }
            newIndex = Math.min(newIndex, this.rankedListsPanel.getComponentCount() - 1);
            newIndex = Math.max(newIndex, 0);
            RankedListComponent element = rankedListComponents[elementIndex];
            this.rankedListsPanel.remove(elementIndex);
            this.rankedListsPanel.add((Component)element, newIndex);
            this.rankedListsPanel.invalidate();
            this.rankedListsPanel.validate();
            this.rankedListsPanel.repaint();
        }
    }

    private void setRankedLists() {
        int ncols;
        RankedListComponent priorPrototypeRankedListComponent = this.rankedListComponents.length > 0 ? this.rankedListComponents[0][0] : null;
        RankedList[][] rankedLists = this.get2dArray();
        MouseAdapter activeRankedListMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                RankedListComponent source = (RankedListComponent)e.getSource();
                Set<Object> ids = source.getHighligtedInstances(e);
                if (ids.size() > 0) {
                    Object id = ids.iterator().next();
                    int index = RankedListController.this.rankedListTableModel.getVisibleRankedList().getIndex(id);
                    Rectangle rect = RankedListController.this.rankedListTable.getCellRect(index, 0, true);
                    RankedListController.this.rankedListTable.scrollRectToVisible(rect);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                RankedListComponent source;
                Set<Object> ids = (source = (RankedListComponent)e.getSource()).getHighligtedInstances(e);
                source.setCursor(ids.size() > 0 ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor());
                this.highlight(ids);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!this.showPopup(e)) {
                    RankedListComponent source = (RankedListComponent)e.getSource();
                    RankedListController.this.setSelectedRankedListComponent(source, false);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }

            private void highlight(Set<Object> ids) {
                if (ids.size() > 0) {
                    RankedListController.this.rankedListDropComponent.getHighlightTrack().addHighlightedIds(ids, true);
                    RankedListController.this.revalidateAndRepaintAll();
                } else if (!RankedListController.this.rankedListDropComponent.getHighlightTrack().isHighlightedIdsEmpty()) {
                    RankedListController.this.rankedListDropComponent.getHighlightTrack().addHighlightedIds(ids, true);
                    RankedListController.this.revalidateAndRepaintAll();
                }
            }

            private boolean showPopup(final MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JPopupMenu popupMenu = new JPopupMenu();
                    popupMenu.add(new AbstractAction("Set as reference"){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            RankedListComponent source = (RankedListComponent)e.getSource();
                            RankedList rankedList = source.getRankedList();
                            RankedListController.this.rankedListDropComponent.getHighlightTrack().setReferenceRankedList(rankedList);
                        }
                    });
                    popupMenu.addSeparator();
                    popupMenu.add(new AbstractAction("Clear reference"){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            RankedListController.this.rankedListDropComponent.getHighlightTrack().setReferenceRankedList(null);
                        }
                    });
                    JCheckBoxMenuItem useAngle = new JCheckBoxMenuItem("Use angle", RankedListController.this.drawReferenceMode == 0);
                    JCheckBoxMenuItem usePoints = new JCheckBoxMenuItem("Use points", RankedListController.this.drawReferenceMode == 1);
                    JCheckBoxMenuItem useLineLength = new JCheckBoxMenuItem("Use line length", RankedListController.this.drawReferenceMode == 2);
                    useAngle.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            RankedListController.this.setDrawReferenceMode(0);
                        }
                    });
                    usePoints.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            RankedListController.this.setDrawReferenceMode(1);
                        }
                    });
                    useLineLength.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            RankedListController.this.setDrawReferenceMode(2);
                        }
                    });
                    popupMenu.addSeparator();
                    popupMenu.add(useAngle);
                    popupMenu.add(usePoints);
                    popupMenu.add(useLineLength);
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    return true;
                }
                return false;
            }
        };
        MouseAdapter lineMouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
            }
        };
        this.rankedListsPanel.removeAll();
        this.rankedListsPanel.setLayout((LayoutManager)new FormLayout(UIUtil.createStringForFormLayout("2px", "p:none", rankedLists.length == 0 ? 0 : rankedLists[0].length), UIUtil.createStringForFormLayout("2px", "p:none", rankedLists.length)));
        this.rankedListComponents = rankedLists.length == 0 ? new RankedListComponent[0][0] : new RankedListComponent[rankedLists.length][rankedLists[0].length];
        RankedList selectedRankedList = this.selectedRankedListComponent == null ? null : this.selectedRankedListComponent.getRankedList();
        CellConstraints cc = new CellConstraints();
        RankedListComponent selectedRankedListComponent = null;
        this.showRowNames = rankedLists.length > 1 && rankedLists[0].length == 1;
        this.showColumnNames = rankedLists.length == 1;
        int i = 0;
        int y = 1;
        int nrows = rankedLists.length;
        while (i < nrows) {
            int j = 0;
            int x = 1;
            int ncols2 = rankedLists[0].length;
            while (j < ncols2) {
                if (rankedLists[i][j] != null) {
                    RankedListComponent rankedListComponent = new RankedListComponent(rankedLists[i][j], this.rankedListDropComponent.getHighlightTrack());
                    if (rankedLists[i][j].equals(selectedRankedList)) {
                        selectedRankedListComponent = rankedListComponent;
                    }
                    this.rankedListComponents[i][j] = rankedListComponent;
                    rankedListComponent.addMouseListener(activeRankedListMouseListener);
                    rankedListComponent.addMouseMotionListener(activeRankedListMouseListener);
                    rankedListComponent.addMouseListener(lineMouseListener);
                    this.rankedListsPanel.add((Component)rankedListComponent, cc.xy(x, y));
                }
                ++j;
                x += 2;
            }
            ++i;
            y += 2;
        }
        this.rowHeaderPanel.removeAll();
        this.rowHeaderPanel.setLayout((LayoutManager)new FormLayout("p:none, p:none", UIUtil.createStringForFormLayout("2px", "p:none", rankedLists.length)));
        this.rowProductHeaders = new CartesianProductHeader[rankedLists.length];
        i = 0;
        y = 1;
        nrows = rankedLists.length;
        while (i < nrows) {
            CartesianProductHeader rowProductHeader;
            final int _i = i;
            this.rowProductHeaders[i] = rowProductHeader = new CartesianProductHeader(this.rankedListDropComponent.getHighlightTrack(), false){

                @Override
                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    d.height = ((RankedListController)RankedListController.this).rankedListComponents[_i][0].getPreferredSize().height;
                    return d;
                }
            };
            if (this.showRowNames) {
                JideLabel label = new JideLabel(rankedLists[_i][0].getName());
                label.setToolTipText(label.getText());
                label.setOrientation(1);
                label.setClockwise(false);
                Dimension size = label.getPreferredSize();
                size.height = this.rankedListComponents[_i][0].getPreferredSize().height;
                label.setPreferredSize(size);
                label.setHorizontalAlignment(0);
                this.rowHeaderPanel.add((Component)label, cc.xy(1, y));
            }
            this.rowHeaderPanel.add((Component)rowProductHeader, cc.xy(2, y));
            rowProductHeader.setLeftBorder(1);
            rowProductHeader.setRightBorder(1);
            rowProductHeader.setMinorSpacing(2);
            rowProductHeader.setGridSize(this.rankedListComponents[i][0].getBarHeight());
            rowProductHeader.layoutLabels();
            ++i;
            y += 2;
        }
        this.columnProductHeaders = new CartesianProductHeader[rankedLists.length == 0 ? 0 : rankedLists[0].length];
        this.columnHeaderPanel.removeAll();
        this.columnHeaderPanel.setLayout((LayoutManager)new FormLayout(UIUtil.createStringForFormLayout("2px", "p:none", rankedLists.length == 0 ? 0 : rankedLists[0].length), "p:none, p:none"));
        int j = 0;
        int x = 1;
        int n = ncols = rankedLists.length == 0 ? 0 : rankedLists[0].length;
        while (j < ncols) {
            final int _j = j;
            CartesianProductHeader columnProductHeader = new CartesianProductHeader(this.rankedListDropComponent.getHighlightTrack(), true){

                @Override
                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    d.width = ((RankedListController)RankedListController.this).rankedListComponents[0][_j].getPreferredSize().width;
                    return d;
                }
            };
            columnProductHeader.setRotated(true);
            HighlightTrack highlightTrack = this.rankedListDropComponent.getHighlightTrack();
            int maxLineWidth = (int)(highlightTrack.getSizeBy() != null ? highlightTrack.getMaxSize() : highlightTrack.getDefaultLineWidth());
            columnProductHeader.setLeftBorder(1);
            columnProductHeader.setRightBorder(1);
            columnProductHeader.setMinorSpacing(2);
            columnProductHeader.setGridSize(this.rankedListComponents[0][j].getBarWidth() + maxLineWidth);
            columnProductHeader.layoutLabels();
            if (this.showColumnNames) {
                JideLabel label = new JideLabel(rankedLists[0][j].getName());
                label.setToolTipText(label.getText());
                Dimension size = label.getPreferredSize();
                size.width = this.rankedListComponents[0][_j].getPreferredSize().width;
                label.setPreferredSize(size);
                label.setHorizontalAlignment(0);
                this.columnHeaderPanel.add((Component)label, cc.xy(x, 1));
            }
            this.columnHeaderPanel.add((Component)columnProductHeader, cc.xy(x, 2));
            this.columnProductHeaders[j] = columnProductHeader;
            ++j;
            x += 2;
        }
        if (priorPrototypeRankedListComponent != null) {
            Color nullColor = priorPrototypeRankedListComponent.getNullColor();
            Color posColor = priorPrototypeRankedListComponent.getPositiveColor();
            Color negColor = priorPrototypeRankedListComponent.getNegativeColor();
            int barWidthValue = priorPrototypeRankedListComponent.getBarWidth();
            int barHeightValue = priorPrototypeRankedListComponent.getBarHeight();
            boolean drawGradient = priorPrototypeRankedListComponent.isDrawGradient();
            boolean drawRanks = priorPrototypeRankedListComponent.isDrawRanks();
            float lineThicknessValue = priorPrototypeRankedListComponent.getLineThickness();
            int drawReferenceMode = priorPrototypeRankedListComponent.getDrawReferenceMode();
            RankedListComponent[][] arr$ = this.rankedListComponents;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                RankedListComponent[] array;
                for (RankedListComponent rl : array = arr$[i$]) {
                    if (rl == null) continue;
                    rl.setNullColor(nullColor);
                    rl.setPositiveColor(posColor);
                    rl.setNegativeColor(negColor);
                    rl.setMaskFilter(this.maskFilter);
                    rl.setMaskAlpha(this.maskAlpha);
                    rl.setBarWidth(barWidthValue);
                    rl.setBarHeight(barHeightValue);
                    rl.setLineThickness(lineThicknessValue);
                    rl.setDrawGradient(drawGradient);
                    rl.setDrawRanks(drawRanks);
                    rl.setDrawReferenceMode(drawReferenceMode);
                }
            }
        }
        this.revalidateAndRepaintAll();
        this.setSelectedRankedListComponent((RankedListComponent)(selectedRankedListComponent != null ? selectedRankedListComponent : (this.rankedListComponents.length == 0 ? null : this.rankedListComponents[0][0])), false);
    }
}

