/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.rankedlist;

import com.google.common.io.Files;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.category.VectorColorModel;
import org.broadinstitute.genee.cmap.rankedlist.HighlightTrack;
import org.broadinstitute.genee.cmap.rankedlist.IdSupplier;
import org.broadinstitute.genee.cmap.rankedlist.RankedListDropListPanel;
import org.broadinstitute.genee.cmap.rankedlist.RankedListFilterCollectionEvent;
import org.broadinstitute.genee.cmap.rankedlist.RankedListFilterCollectionListener;
import org.broadinstitute.genee.cmap.rankedlist.RankedListFilterData;
import org.broadinstitute.genee.cmap.rankedlist.RankedListFilterDropPanel;
import org.broadinstitute.genee.cmap.rankedlist.RankedListMetadataDragComponent;
import org.broadinstitute.genee.cmap.rankedlist.SavedRankedListSettings;
import org.broadinstitute.genee.filter.RankedListFilterableAttribute;
import org.broadinstitute.genee.gui.Combination;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.MovieControlPanel;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.matrix.VectorUtil;
import org.broadinstitute.genee.matrix.rankedlist.RankedList;

public class RankedListDropComponent {
    private static final String ANIMATE_DRAG_DROP_NAME = "Animate";
    private static final String COLUMNS_DRAG_DROP_NAME = "Columns";
    private static final String ROWS_DRAG_DROP_NAME = "Rows";
    private static final String SIZE_DRAG_DROP_NAME = "Size";
    private static final String COLOR_DRAG_DROP_NAME = "Color";
    private RankedListFilterDropPanel filterPanel;
    private HighlightTrack highlightTrack;
    private IdSupplier[] animationFrameIdSupplier;
    private List<AnimationFrame> animationFrames;
    private JComboBox animateOverComboBox;
    private ActionListener animationComboBoxActionListener;
    private MovieControlPanel moviePanel;
    private RankedListDropListPanel columnsDropPanel;
    private RankedListDropListPanel rowsDropPanel;
    private RankedListDropListPanel colorDropPanel;
    private RankedListDropListPanel sizeDropPanel;
    private RankedListDropListPanel animateDropPanel;
    private RankedListFilterableAttribute[] attributes;
    private JComboBox savedSettingsComboBox;
    private JPanel savedSettingsPanel;
    private JPanel c;
    private JComboBox labelRankedListsByComboBox;

    RankedListDropComponent(RankedList rankedList, RankedListFilterableAttribute[] attributes, VectorColorModel colorModel) {
        this.attributes = attributes;
        this.filterPanel = new RankedListFilterDropPanel(rankedList);
        this.highlightTrack = new HighlightTrack(this.filterPanel.getRankedListFilterCollection(), colorModel);
        this.filterPanel.getRankedListFilterCollection().addRankedListFilterListener(new RankedListFilterCollectionListener(){

            @Override
            public void filterChanged(RankedListFilterCollectionEvent e) {
                RankedListDropComponent.this.createAnimationFrames();
            }
        });
        JLabel instancesLabel = new JLabel("Instances:");
        JLabel columnsLabel = new JLabel("Columns:");
        JLabel rowsLabel = new JLabel("Rows:");
        JLabel colorLabel = new JLabel("Color:");
        JLabel sizeLabel = new JLabel("Size:");
        JLabel animateLabel = new JLabel("Movie:");
        this.moviePanel = new MovieControlPanel(){

            @Override
            public void begin() {
            }

            @Override
            public void end() {
            }

            @Override
            public void timingEvent(float fraction) {
            }

            @Override
            protected void goToFrame(int frameIndex) {
                RankedListDropComponent.this.highlightTrack.setAnimationFrameInstanceIds(((AnimationFrame)RankedListDropComponent.this.animationFrames.get(frameIndex)).ids);
                RankedListDropComponent.this.animateOverComboBox.removeActionListener(RankedListDropComponent.this.animationComboBoxActionListener);
                RankedListDropComponent.this.animateOverComboBox.setSelectedIndex(frameIndex);
                RankedListDropComponent.this.animateOverComboBox.addActionListener(RankedListDropComponent.this.animationComboBoxActionListener);
            }
        };
        this.animateOverComboBox = this.moviePanel.getAvailableFramesComboBox();
        this.animateOverComboBox.setEnabled(false);
        this.animationComboBoxActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedIndex = RankedListDropComponent.this.animateOverComboBox.getSelectedIndex();
                if (selectedIndex != -1) {
                    RankedListDropComponent.this.moviePanel.stop();
                    RankedListDropComponent.this.moviePanel.setFrame(selectedIndex);
                }
            }
        };
        FormBuilder formBuilder = new FormBuilder();
        formBuilder.nextRow();
        formBuilder.addFirstColumn(instancesLabel);
        formBuilder.add(this.filterPanel.getComponent());
        formBuilder.nextRowNoSpace();
        formBuilder.add(this.filterPanel.getFilterLabel());
        formBuilder.nextRow();
        formBuilder.addFirstColumn(columnsLabel);
        this.columnsDropPanel = new RankedListDropListPanel(null, true, COLUMNS_DRAG_DROP_NAME){

            @Override
            public void notifyChanged(String sourceOwnerName, String destOwnerName) {
                RankedListDropComponent.this.dragDropChanged(sourceOwnerName, destOwnerName);
            }
        };
        formBuilder.add(this.columnsDropPanel.getComponent());
        formBuilder.nextSmallRow();
        formBuilder.addFirstColumn(rowsLabel);
        this.rowsDropPanel = new RankedListDropListPanel(null, true, ROWS_DRAG_DROP_NAME){

            @Override
            public void notifyChanged(String sourceOwnerName, String destOwnerName) {
                RankedListDropComponent.this.dragDropChanged(sourceOwnerName, destOwnerName);
            }
        };
        formBuilder.add(this.rowsDropPanel.getComponent());
        formBuilder.nextRow();
        formBuilder.addFirstColumn(colorLabel);
        this.colorDropPanel = new RankedListDropListPanel(null, false, COLOR_DRAG_DROP_NAME){

            @Override
            public void notifyChanged(String sourceOwnerName, String destOwnerName) {
                RankedListDropComponent.this.dragDropChanged(sourceOwnerName, destOwnerName);
            }
        };
        formBuilder.add(this.colorDropPanel.getComponent());
        formBuilder.nextSmallRow();
        formBuilder.addFirstColumn(sizeLabel);
        this.sizeDropPanel = new RankedListDropListPanel(null, false, SIZE_DRAG_DROP_NAME){

            @Override
            public void notifyChanged(String sourceOwnerName, String destOwnerName) {
                RankedListDropComponent.this.dragDropChanged(sourceOwnerName, destOwnerName);
            }
        };
        formBuilder.add(this.sizeDropPanel.getComponent());
        formBuilder.nextRow();
        formBuilder.addFirstColumn(animateLabel);
        this.animateDropPanel = new RankedListDropListPanel(null, true, ANIMATE_DRAG_DROP_NAME){

            @Override
            public void notifyChanged(String sourceOwnerName, String destOwnerName) {
                RankedListDropComponent.this.dragDropChanged(sourceOwnerName, destOwnerName);
            }
        };
        formBuilder.add(this.animateDropPanel.getComponent());
        formBuilder.nextSmallRow();
        this.moviePanel.setVisible(false);
        formBuilder.add(this.moviePanel);
        formBuilder.nextSmallRow();
        formBuilder.addLabel("List Name:");
        this.labelRankedListsByComboBox = UIUtil.createComboBox();
        formBuilder.add(this.labelRankedListsByComboBox);
        JButton saveSettingsButton = new JButton("Save Settings\u2026");
        saveSettingsButton.setToolTipText("Save current settings");
        saveSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = UIUtil.showInputDialog(RankedListDropComponent.this.getComponent(), "Saved setting name", "");
                if (name != null && name.length() > 0) {
                    String xml = new SavedRankedListSettings(name, RankedListDropComponent.this.filterPanel, RankedListDropComponent.this.highlightTrack).toXML();
                    File savedRankedListSettingsDir = RankedListDropComponent.getSavedSettingsDir();
                    try {
                        Files.write((CharSequence)xml, (File)new File(savedRankedListSettingsDir, name + ".xml"), (Charset)Charset.defaultCharset());
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    RankedListDropComponent.this.updateSavedSettings();
                }
            }
        });
        JButton loadButton = new JButton("Load");
        loadButton.setToolTipText("Load settings");
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File savedRankedListSettingsDir = RankedListDropComponent.getSavedSettingsDir();
                File file = new File(savedRankedListSettingsDir, RankedListDropComponent.this.savedSettingsComboBox.getSelectedItem() + ".xml");
                if (file.exists()) {
                    try {
                        String xml = Files.toString((File)file, (Charset)Charset.defaultCharset());
                        SavedRankedListSettings setting = SavedRankedListSettings.fromXML(xml);
                        setting.load(RankedListDropComponent.this.rowsDropPanel, RankedListDropComponent.this.columnsDropPanel, RankedListDropComponent.this.sizeDropPanel, RankedListDropComponent.this.colorDropPanel, RankedListDropComponent.this.filterPanel, RankedListDropComponent.this.attributes);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        JButton removeSettings = new JButton("Remove");
        removeSettings.setToolTipText("Remove setting");
        removeSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File savedRankedListSettingsDir = RankedListDropComponent.getSavedSettingsDir();
                new File(savedRankedListSettingsDir, RankedListDropComponent.this.savedSettingsComboBox.getSelectedItem() + ".xml").delete();
                RankedListDropComponent.this.updateSavedSettings();
            }
        });
        formBuilder.nextRow();
        formBuilder.addSpanned(UIUtil.buildLeftRightAlignedBar(new JButton[]{saveSettingsButton}, new JButton[0]));
        this.savedSettingsComboBox = UIUtil.createComboBox();
        formBuilder.nextSmallRow();
        this.savedSettingsPanel = UIUtil.buildLeftRightAlignedBar(new JComponent[]{this.savedSettingsComboBox, removeSettings, loadButton}, new JButton[0]);
        this.updateSavedSettings();
        formBuilder.addSpanned(this.savedSettingsPanel);
        formBuilder.getPanel().setMinimumSize(new Dimension());
        this.c = formBuilder.getPanel();
    }

    public RankedListFilterableAttribute[] getAttributes() {
        return this.attributes;
    }

    public JComponent getComponent() {
        return this.c;
    }

    public HighlightTrack getHighlightTrack() {
        return this.highlightTrack;
    }

    public RankedListFilterDropPanel getInstancesPanel() {
        return this.filterPanel;
    }

    public JComboBox getLabelRankedListsByComboBox() {
        return this.labelRankedListsByComboBox;
    }

    protected void dragDropChanged(String sourceOwnerName, String destOwnerName) {
        List<Object> attributes;
        boolean updateAnimationFrames = false;
        if (COLUMNS_DRAG_DROP_NAME.equals(destOwnerName) || COLUMNS_DRAG_DROP_NAME.equals(sourceOwnerName)) {
            List<Object> columnAttributes = this.columnsDropPanel.getDroppedData();
            if (ROWS_DRAG_DROP_NAME.equals(destOwnerName) || ROWS_DRAG_DROP_NAME.equals(sourceOwnerName)) {
                List<Object> rowAttributes = this.rowsDropPanel.getDroppedData();
                this.highlightTrack.setGroupBy(rowAttributes.size() == 0 ? null : RankedListDropComponent.createIdSupplierArray(rowAttributes), columnAttributes.size() == 0 ? null : RankedListDropComponent.createIdSupplierArray(columnAttributes), false);
            } else {
                this.highlightTrack.setGroupColumnsBy(columnAttributes.size() == 0 ? null : RankedListDropComponent.createIdSupplierArray(columnAttributes), false);
            }
            updateAnimationFrames = true;
        } else if (ROWS_DRAG_DROP_NAME.equals(destOwnerName) || ROWS_DRAG_DROP_NAME.equals(sourceOwnerName)) {
            List<Object> rowAttributes = this.rowsDropPanel.getDroppedData();
            this.highlightTrack.setGroupRowsBy(rowAttributes.size() == 0 ? null : RankedListDropComponent.createIdSupplierArray(rowAttributes), false);
            updateAnimationFrames = true;
        }
        if (SIZE_DRAG_DROP_NAME.equals(destOwnerName) || SIZE_DRAG_DROP_NAME.equals(sourceOwnerName)) {
            attributes = this.sizeDropPanel.getDroppedData();
            this.setSizeBy(attributes);
            updateAnimationFrames = true;
        }
        if (COLOR_DRAG_DROP_NAME.equals(destOwnerName) || COLOR_DRAG_DROP_NAME.equals(sourceOwnerName)) {
            attributes = this.colorDropPanel.getDroppedData();
            this.setColorBy(attributes);
            updateAnimationFrames = true;
        }
        if (ANIMATE_DRAG_DROP_NAME.equals(destOwnerName) || ANIMATE_DRAG_DROP_NAME.equals(sourceOwnerName)) {
            attributes = this.animateDropPanel.getDroppedData();
            this.setAnimateOver(attributes);
            updateAnimationFrames = false;
        }
        if (updateAnimationFrames) {
            this.createAnimationFrames();
        }
        this.highlightTrack.notifyListeners();
    }

    protected void setColorByContinuous(boolean b) {
        this.highlightTrack.getColorBy().setProperty("Continuous Key", b);
    }

    protected void updateSavedSettings() {
        String[] names = RankedListDropComponent.getSavedSettings();
        Object selection = this.savedSettingsComboBox.getSelectedItem();
        this.savedSettingsComboBox.removeAllItems();
        for (String savedName : names) {
            this.savedSettingsComboBox.addItem(savedName);
        }
        this.savedSettingsComboBox.setSelectedItem(selection);
        this.savedSettingsPanel.setVisible(this.savedSettingsComboBox.getItemCount() > 0);
    }

    private void createAnimationFrames() {
        this.animateOverComboBox.removeActionListener(this.animationComboBoxActionListener);
        this.animateOverComboBox.removeAllItems();
        this.animateOverComboBox.setEnabled(this.animationFrameIdSupplier != null);
        this.moviePanel.setEnabled(this.animationFrameIdSupplier != null);
        this.moviePanel.setVisible(this.animationFrameIdSupplier != null);
        this.highlightTrack.setAnimationFrameInstanceIds(null);
        if (this.animationFrameIdSupplier == null) {
            this.animationFrames = null;
        } else {
            List<Combination> product = VectorUtil.getCombinations(this.animationFrameIdSupplier);
            if (product.size() > 0) {
                String[] names = new String[product.size()];
                List[] groups = new List[product.size()];
                int index = 0;
                HashMap<Collection<Object>, Integer> groupToIndex = new HashMap<Collection<Object>, Integer>();
                for (Combination item : product) {
                    groups[index] = item.getValues();
                    groupToIndex.put(item.getValues(), index);
                    ++index;
                }
                int size = groups.length;
                for (int i = 0; i < size; ++i) {
                    StringBuilder text = new StringBuilder();
                    List group = groups[i];
                    for (Object value : group) {
                        if (text.length() > 0) {
                            text.append(", ");
                        }
                        text.append(Formatter.toString(value));
                    }
                    names[i] = text.toString();
                }
                Collection<Object> ids = this.highlightTrack.getAllInstanceIds();
                ArrayList<Object> valuesList = new ArrayList<Object>();
                this.animationFrames = new ArrayList<AnimationFrame>();
                for (String name : names) {
                    this.animationFrames.add(new AnimationFrame(name));
                }
                for (Object id : ids) {
                    valuesList.clear();
                    for (IdSupplier animate : this.animationFrameIdSupplier) {
                        Object value = animate.get(id);
                        valuesList.add(value);
                    }
                    int frameIndex = (Integer)groupToIndex.get(valuesList);
                    this.animationFrames.get(frameIndex).add(id);
                }
                for (int i = 0; i < this.animationFrames.size(); ++i) {
                    if (this.animationFrames.get(i).ids.size() != 0) continue;
                    this.animationFrames.remove(i);
                    --i;
                }
                for (AnimationFrame frame : this.animationFrames) {
                    this.animateOverComboBox.addItem(frame.name);
                }
                this.animateOverComboBox.setSelectedIndex(-1);
                this.animateOverComboBox.addActionListener(this.animationComboBoxActionListener);
                this.moviePanel.setNumberOfFrame(this.animationFrames.size());
            }
        }
    }

    private void setAnimateOver(List<Object> attributes) {
        if (attributes.size() == 0) {
            this.animationFrameIdSupplier = null;
        } else {
            this.animationFrameIdSupplier = new IdSupplier[attributes.size()];
            int size = attributes.size();
            for (int i = 0; i < size; ++i) {
                this.animationFrameIdSupplier[i] = RankedListDropComponent.getIdSupplier(attributes.get(i));
            }
        }
        this.createAnimationFrames();
    }

    private void setColorBy(List<Object> attributes) {
        this.highlightTrack.setColorBy(attributes.size() == 0 ? null : RankedListDropComponent.getIdSupplier(attributes.get(0)), false);
    }

    private void setSizeBy(List<Object> attributes) {
        if (attributes.size() == 0) {
            this.highlightTrack.setSizeBy(null, false);
        } else {
            this.highlightTrack.setSizeBy(RankedListDropComponent.getIdSupplier(attributes.get(0)), false);
        }
    }

    public static RankedListFilterableAttribute getFilterAttributeByName(RankedListFilterableAttribute[] attributes, String name) {
        for (RankedListFilterableAttribute attr : attributes) {
            if (!attr.getFilterValuesSupplier().getName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    private static IdSupplier[] createIdSupplierArray(List<Object> attributes) {
        IdSupplier[] array = new IdSupplier[attributes.size()];
        int size = attributes.size();
        for (int i = 0; i < size; ++i) {
            array[i] = RankedListDropComponent.getIdSupplier(attributes.get(i));
        }
        return array;
    }

    private static IdSupplier getIdSupplier(Object obj) {
        if (obj instanceof RankedListMetadataDragComponent.RankedListAttribute) {
            return ((RankedListMetadataDragComponent.RankedListAttribute)obj).getFilterValuesSupplier();
        }
        return ((RankedListFilterData)obj).getIdSupplier();
    }

    private static String[] getSavedSettings() {
        File savedRankedListSettingsDir = RankedListDropComponent.getSavedSettingsDir();
        File[] xmlFiles = savedRankedListSettingsDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".xml");
            }
        });
        if (xmlFiles == null) {
            return new String[0];
        }
        String[] names = new String[xmlFiles.length];
        int nfiles = xmlFiles.length;
        for (int i = 0; i < nfiles; ++i) {
            names[i] = IOUtil.getBaseFileName(xmlFiles[i].getName());
        }
        return names;
    }

    private static File getSavedSettingsDir() {
        File rootDir = Application.getGENEEDir();
        File savedRankedListSettingsDir = new File(rootDir, "Ranked List Settings");
        if (!savedRankedListSettingsDir.isDirectory() && !savedRankedListSettingsDir.mkdirs()) {
            System.err.println("Unable to create directory " + savedRankedListSettingsDir);
        }
        return savedRankedListSettingsDir;
    }

    private static class AnimationFrame {
        private Set<Object> ids;
        private String name;

        public AnimationFrame(String name) {
            this.name = name;
            this.ids = new HashSet<Object>();
        }

        public void add(Object id) {
            this.ids.add(id);
        }
    }
}

