/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.scripts;

import gnu.trove.list.array.TIntArrayList;
import java.awt.Color;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.genee.cmap.L1000Util;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.io.matrix.geneset.GeneSetIO;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ImageUtil;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;
import uk.co.flamingpenguin.jewel.cli.Cli;
import uk.co.flamingpenguin.jewel.cli.CliFactory;
import uk.co.flamingpenguin.jewel.cli.CommandLineInterface;
import uk.co.flamingpenguin.jewel.cli.Option;

public class BrewHeatMap {
    private static String outputFileFormat = "png";

    public BrewHeatMap(BrewHeatMapArgs argsp) throws IOException {
        File outputDir;
        UIUtil.verifyJideLicense();
        File brewDir = new File(argsp.getBrewDir());
        if (!brewDir.exists()) {
            System.err.println(brewDir.getName() + " not found.");
            System.exit(1);
        }
        File file = outputDir = argsp.isOutputDir() ? new File(argsp.getOutputDir()) : brewDir;
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        outputDir = outputDir.getAbsoluteFile();
        BrewHeatMap.createHeatMaps(outputDir, brewDir);
    }

    public static void main(String[] args) throws IOException {
        try {
            Cli cli = CliFactory.createCli(BrewHeatMapArgs.class);
            if (args.length == 0) {
                System.out.println(cli.getHelpMessage());
                System.exit(0);
            }
            BrewHeatMapArgs argsp = (BrewHeatMapArgs)cli.parseArguments(args);
            new BrewHeatMap(argsp);
        }
        catch (ArgumentValidationException e) {
            System.err.println(e.getMessage());
        }
    }

    private static HeatMapPanel configure(HeatMapPanel heatMapPanel) {
        heatMapPanel.setDrawGrid(false);
        heatMapPanel.getColorSchemeLegend().setVisible(false);
        heatMapPanel.setRowSize(6.0f);
        heatMapPanel.setColumnSize(6.0f);
        return heatMapPanel;
    }

    private static void createHeatMapInSpaceOf(Vector ids, L1000Util.DataFile dataFile, File plateDir, File outputDir) throws IOException {
        File gct = L1000Util.getGctFile(dataFile, plateDir, true);
        Dataset dataset = ProjectIO.readProject(gct.getCanonicalPath()).getOriginalDataset();
        Map idToIndex = VectorUtil.createValueToIndexMap(dataset.getColumnMetadata().get(0));
        int[] indices = new int[ids.size()];
        int ncols = ids.size();
        for (int j = 0; j < ncols; ++j) {
            indices[j] = idToIndex.get(ids.getValue(j));
        }
        dataset = DatasetUtil.sliceView(dataset, null, indices);
        ImageUtil.saveImage(BrewHeatMap.configure(new HeatMapPanel(new DefaultProject(dataset))), outputFileFormat, new File(outputDir, IOUtil.getBaseFileName(gct.getName())), true);
    }

    private static void createHeatMaps(File outputDir, File brewDir) throws IOException {
        File compZScore = L1000Util.getGctFile(L1000Util.DataFile.COMPZ_MODZ_SCORE, brewDir, false);
        Dataset compzDataset = ProjectIO.readProject(compZScore.getCanonicalPath()).getOriginalDataset();
        compzDataset = DatasetUtil.sliceView(compzDataset, IOUtil.seqInt(978), null);
        HeatMapPanel heatMapPanel = BrewHeatMap.configure(new HeatMapPanel(new DefaultProject(compzDataset)));
        heatMapPanel.getColorScheme().setGlobalMax(10.0f);
        heatMapPanel.getColorScheme().setGlobalMin(-10.0f);
        heatMapPanel.getColorScheme().setColors(new Color[]{Color.BLUE, Color.WHITE, Color.WHITE, Color.RED}, new float[]{0.0f, 0.4f, 0.6f, 1.0f});
        ImageUtil.saveImage(heatMapPanel, outputFileFormat, new File(outputDir, IOUtil.getBaseFileName(compZScore.getName())), true);
        File[] grpFile = brewDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".grp");
            }
        });
        Set<String> plateNames = GeneSetIO.readGeneSetMatrix(grpFile[0]).get(0).getMembers();
        for (String plate : plateNames) {
            File plateDir = new File(L1000Util.PLATE_DIR, plate);
            File norm = L1000Util.getGctFile(L1000Util.DataFile.NORM, plateDir, true);
            Dataset normDataset = ProjectIO.readProject(norm.getCanonicalPath()).getOriginalDataset();
            Vector pertType = normDataset.getColumnMetadata().get("pert_type");
            TIntArrayList normIndices = new TIntArrayList();
            int ncols = pertType.size();
            for (int j = 0; j < ncols; ++j) {
                String type = (String)pertType.getValue(j);
                if (!(type = type.toLowerCase()).startsWith("trt")) continue;
                normIndices.add(j);
            }
            normDataset = DatasetUtil.sliceView(normDataset, null, normIndices.toArray());
            Vector ids = normDataset.getColumnMetadata().get(0);
            ImageUtil.saveImage(BrewHeatMap.configure(new HeatMapPanel(new DefaultProject(normDataset))), outputFileFormat, new File(outputDir, IOUtil.getBaseFileName(norm.getName())), true);
            BrewHeatMap.createHeatMapInSpaceOf(ids, L1000Util.DataFile.QNORM, plateDir, outputDir);
            BrewHeatMap.createHeatMapInSpaceOf(ids, L1000Util.DataFile.GEX, plateDir, outputDir);
        }
    }

    @CommandLineInterface(application="brew-heatmap")
    public static interface BrewHeatMapArgs {
        @Option(shortName={"d"}, longName={"dir"}, description="The brew directory")
        public String getBrewDir();

        @Option(shortName={"o"}, longName={"output"}, description="The output directory (default is brew directory)")
        public String getOutputDir();

        public boolean isOutputDir();
    }
}

