/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.scripts;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Map;
import org.broadinstitute.genee.gui.NullProgressNotifier;
import org.broadinstitute.genee.io.excel.Array2DContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.util.IOUtil;

public class CombineMapFiles {
    private static final String[] FIELDS = new String[]{"sample_name", "pert_name", "pert_desc", "cell_name", "pert_time", "pert_time_unit"};

    public static void main(String[] args) throws Exception {
        int nfields = FIELDS.length;
        File[] mapFiles = IOUtil.listFiles(new File("/xchip/cogs/pipeline/plates"), new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".map") && !pathname.getName().contains("old");
            }
        }, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.getName().contains("old");
            }
        }, new NullProgressNotifier(), true);
        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter("perturbagens.map")));
        for (int i = 0; i < nfields; ++i) {
            if (i > 0) {
                pw.print("\t");
            }
            pw.print(FIELDS[i]);
        }
        pw.println();
        for (File file : mapFiles) {
            int i;
            System.out.println(file);
            String[][] data = ((Array2DContentHandler)new ExcelReader(file.getCanonicalPath(), new Array2DContentHandler()).getContentHandler()).getData();
            String[] header = data[0];
            Map<String, Integer> fieldToIndex = IOUtil.buildIndexMap(Arrays.asList(header));
            int[] indices = new int[FIELDS.length];
            for (i = 0; i < nfields; ++i) {
                Integer index = fieldToIndex.get(FIELDS[i]);
                indices[i] = index == null ? -1 : index;
            }
            int length = data.length;
            for (i = 1; i < length; ++i) {
                String[] array = data[i];
                if (array[0].trim().equals("") || indices[0] == -1) continue;
                for (int j = 0; j < nfields; ++j) {
                    int index;
                    if (j > 0) {
                        pw.print("\t");
                    }
                    String s = (index = indices[j]) == -1 ? "" : array[index];
                    pw.print(s);
                }
                pw.println();
            }
        }
        pw.close();
    }
}

