/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.scripts;

import java.io.File;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.cls.ClsReader;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.DefaultClassVector;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;
import uk.co.flamingpenguin.jewel.cli.Cli;
import uk.co.flamingpenguin.jewel.cli.CliFactory;
import uk.co.flamingpenguin.jewel.cli.CommandLineInterface;
import uk.co.flamingpenguin.jewel.cli.Option;

public class ConvertDataset {
    public static void main(String[] args) throws Exception {
        try {
            Cli cli = CliFactory.createCli(DataConversionArgs.class);
            if (args.length == 0) {
                System.out.println(cli.getHelpMessage());
                System.exit(0);
            }
            DataConversionArgs argsp = (DataConversionArgs)cli.parseArguments(args);
            String inputFile = argsp.getInputFile();
            Project p = ProjectIO.readProject(inputFile);
            if (argsp.isClsFile()) {
                File cls = argsp.getClsFile();
                DefaultClassVector classVector = new ClsReader().read(cls.getCanonicalPath());
                Vector v = MetadataUtil.addColumnVector(p.getOriginalDataset().getColumnMetadata(), classVector.getDescription(), String.class);
                int length = classVector.size();
                for (int j = 0; j < length; ++j) {
                    v.setValue(j, classVector.getClassName(classVector.getAssignment(j)));
                }
            }
            File outputfile = argsp.isOutputFile() ? argsp.getOutputFile() : new File(new File(argsp.getInputFile()).getParentFile(), IOUtil.getBaseFileName(inputFile));
            String format = argsp.getOutputFileFormat();
            if (argsp.isTranspose()) {
                p.setDataset(DatasetUtil.transposeView(p.getOriginalDataset()));
            }
            ProjectIO.writeProject(p, format, outputfile.getCanonicalPath(), true);
        }
        catch (ArgumentValidationException e) {
            System.err.println(e.getMessage());
        }
    }

    @CommandLineInterface(application="convert-dataset")
    public static interface DataConversionArgs {
        @Option(longName={"input"}, shortName={"i"}, description="the input file")
        public String getInputFile();

        @Option(longName={"format"}, shortName={"f"}, description="the output file format. One of gct, gct#1.2, gctx, res", defaultValue={"gct"})
        public String getOutputFileFormat();

        @Option(longName={"output"}, shortName={"o"}, description="the output file")
        public File getOutputFile();

        @Option(longName={"cls"}, description="cls file")
        public File getClsFile();

        public boolean isClsFile();

        @Option(longName={"transpose"}, description="transpose the dataset")
        public boolean isTranspose();

        public boolean isOutputFile();
    }
}

