/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.scripts;

import gnu.trove.list.array.TIntArrayList;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.excel.Array2DContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.matrix.res.ResReader;
import org.broadinstitute.genee.io.util.DelimWriter;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.io.util.TabDelimWriter;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;
import org.broadinstitute.genee.stats.Sorting;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;
import uk.co.flamingpenguin.jewel.cli.Cli;
import uk.co.flamingpenguin.jewel.cli.CliFactory;
import uk.co.flamingpenguin.jewel.cli.CommandLineInterface;
import uk.co.flamingpenguin.jewel.cli.Option;

public class KnockUp {
    static final String[] ADDITIONAL_COLUMNS = new String[]{"zscore", "rank", "# > 2", "# < -2"};
    static final String[] COLUMN_ANNOTATIONS = new String[]{"pert_id", "pert_desc", "pert_type", "det_plate", "cell_id", "qc_f_logp", "qc_iqr", "qc_slope", "collab_id", "pert_time"};
    static final String[] ROW_ANNOTATIONS = new String[]{"id", "pr_analyte_num", "pr_is_lmark", "pr_gene_symbol"};
    private PCR pcr = new PCR();
    private static final String ROW_GENE_FIELD = "pr_gene_symbol";
    private static final String COLUMN_GENE_FIELD = "pert_desc";
    private static final String PERT_ID_FIELD = "pert_id";
    private static final String CELL_ID = "cell_id";
    private static final String AFFY_PROBE_ID = "id";
    public static final String[] CELL_LINES = new String[]{"A375", "A549", "HA1E", "HCC515", "HEPG2", "HT29", "MCF7", "PC3", "VCAP"};
    private ATARiS ataris = new ATARiS();
    private BaselineExpression expressed;
    private Achilles achilles = new Achilles();

    public KnockUp(KnockUpArgs argsp) throws Exception {
        this.expressed = new BaselineExpression();
        Dataset zScoreDataset = ProjectIO.readProject(argsp.getGctFile()).getOriginalDataset();
        Map inputGeneToRowIndex = VectorUtil.createValueToIndicesMap(zScoreDataset.getRowMetadata().get(ROW_GENE_FIELD));
        Vector inputColumnGeneVector = zScoreDataset.getColumnMetadata().get(COLUMN_GENE_FIELD);
        Vector inputColumnCloneVector = zScoreDataset.getColumnMetadata().get(PERT_ID_FIELD);
        float[] datasetValues = new float[zScoreDataset.getRowCount()];
        Vector[] columnVectors = new Vector[COLUMN_ANNOTATIONS.length];
        int nannotations = columnVectors.length;
        for (int i = 0; i < nannotations; ++i) {
            columnVectors[i] = zScoreDataset.getColumnMetadata().get(COLUMN_ANNOTATIONS[i]);
            if (columnVectors[i] != null) continue;
            System.out.println(COLUMN_ANNOTATIONS[i] + " not found.");
        }
        Vector[] rowVectors = new Vector[ROW_ANNOTATIONS.length];
        int nannotations2 = rowVectors.length;
        for (int i = 0; i < nannotations2; ++i) {
            rowVectors[i] = zScoreDataset.getRowMetadata().get(ROW_ANNOTATIONS[i]);
            if (rowVectors[i] != null) continue;
            System.out.println(ROW_ANNOTATIONS[i] + " not found.");
        }
        Vector cellVector = zScoreDataset.getColumnMetadata().get(CELL_ID);
        Vector affyIdVector = zScoreDataset.getRowMetadata().get(AFFY_PROBE_ID);
        Vector analyteVector = zScoreDataset.getRowMetadata().get("pr_analyte_id");
        Map analyteToRowIndices = VectorUtil.createValueToIndicesMap(analyteVector);
        Iterator it = analyteToRowIndices.keySet().iterator();
        while (it.hasNext()) {
            String analyte = (String)it.next();
            TIntArrayList pairs = analyteToRowIndices.get(analyte);
            if (pairs.size() == 2) continue;
            it.remove();
        }
        TabDelimWriter writer = new TabDelimWriter();
        writer.init(new File(IOUtil.getBaseFileName(argsp.getGctFile()) + "-knockup.tsv"));
        boolean isKd = argsp.getGctFile().toUpperCase().startsWith("KD");
        KnockUp.printHeader(writer, isKd);
        int ncols = zScoreDataset.getColumnCount();
        for (int j = 0; j < ncols; ++j) {
            int i;
            String sampleName = (String)zScoreDataset.getColumnMetadata().get(0).getValue(j);
            sampleName = sampleName.toLowerCase();
            String gene = (String)inputColumnGeneVector.getValue(j);
            TIntArrayList geneRowIndices = inputGeneToRowIndex.get(gene);
            int countMoreThanTwo = 0;
            int countLessThanTwo = 0;
            int nrows = datasetValues.length;
            for (int i2 = 0; i2 < nrows; ++i2) {
                float zscore = zScoreDataset.getValue(i2, j);
                if (zscore >= 2.0f) {
                    ++countMoreThanTwo;
                } else if (zscore <= -2.0f) {
                    ++countLessThanTwo;
                }
                datasetValues[i2] = zscore;
            }
            int[] index = Sorting.index(datasetValues, isKd);
            int[] ranks = Sorting.rank(index);
            int geneIndex = -1;
            if (geneRowIndices != null) {
                int bestRank = Integer.MAX_VALUE;
                int bestIndex = -1;
                int size = geneRowIndices.size();
                for (int i3 = 0; i3 < size; ++i3) {
                    int rowIndex = geneRowIndices.getQuick(i3);
                    int rank = ranks[rowIndex];
                    if (rank >= bestRank) continue;
                    bestIndex = rowIndex;
                    bestRank = rank;
                }
                geneIndex = bestIndex;
            }
            int rank = geneRowIndices == null ? -1 : ranks[geneIndex];
            int nannotations3 = columnVectors.length;
            for (i = 0; i < nannotations3; ++i) {
                if (i > 0) {
                    writer.nextColumn();
                }
                if (columnVectors[i] == null) continue;
                writer.print(Formatter.toString(columnVectors[i].getValue(j)));
            }
            if (geneIndex != -1) {
                nannotations3 = rowVectors.length;
                for (i = 0; i < nannotations3; ++i) {
                    writer.nextColumn();
                    if (rowVectors[i] == null) continue;
                    writer.print(Formatter.toString(rowVectors[i].getValue(geneIndex)));
                }
            } else {
                nannotations3 = rowVectors.length;
                for (i = 0; i < nannotations3; ++i) {
                    writer.nextColumn();
                }
            }
            writer.nextColumn();
            if (geneIndex != -1) {
                writer.print(Formatter.format(zScoreDataset.getValue(geneIndex, j)));
            }
            writer.nextColumn();
            if (rank != -1) {
                writer.print(rank);
            }
            writer.nextColumn();
            writer.print(countMoreThanTwo);
            writer.nextColumn();
            writer.print(countLessThanTwo);
            String cellLine = (String)cellVector.getValue(j);
            if (isKd) {
                String cloneId = (String)inputColumnCloneVector.getValue(j);
                this.pcr.add(cloneId, cellLine, writer);
                this.achilles.add(cloneId, cellLine, writer);
            }
            String probeId = geneIndex != -1 ? (String)affyIdVector.getValue(geneIndex) : null;
            this.expressed.add(probeId, cellLine, writer);
            if (isKd) {
                String cloneId = (String)inputColumnCloneVector.getValue(j);
                this.ataris.add(cloneId, writer);
            }
            writer.nextRow();
        }
        writer.close();
    }

    public static void main(String[] args) throws Exception {
        try {
            Cli cli = CliFactory.createCli(KnockUpArgs.class);
            if (args.length == 0) {
                System.out.println(cli.getHelpMessage());
                System.exit(0);
            }
            KnockUpArgs argsp = (KnockUpArgs)cli.parseArguments(args);
            new KnockUp(argsp);
        }
        catch (ArgumentValidationException e) {
            System.err.println(e.getMessage());
        }
    }

    public static void printHeader(DelimWriter pw, boolean isKD) {
        int i;
        int length = COLUMN_ANNOTATIONS.length;
        for (i = 0; i < length; ++i) {
            if (i > 0) {
                pw.nextColumn();
            }
            pw.print(COLUMN_ANNOTATIONS[i]);
        }
        length = ROW_ANNOTATIONS.length;
        for (i = 0; i < length; ++i) {
            pw.nextColumn();
            pw.print(ROW_ANNOTATIONS[i]);
        }
        length = ADDITIONAL_COLUMNS.length;
        for (i = 0; i < length; ++i) {
            pw.nextColumn();
            pw.print(ADDITIONAL_COLUMNS[i]);
        }
        if (isKD) {
            length = PCR.FIELDS.length;
            for (i = 0; i < length; ++i) {
                pw.nextColumn();
                pw.print(PCR.FIELDS[i]);
            }
            length = Achilles.FIELDS.length;
            for (i = 0; i < length; ++i) {
                pw.nextColumn();
                pw.print(Achilles.FIELDS[i]);
            }
        }
        length = BaselineExpression.FIELDS.length;
        for (i = 0; i < length; ++i) {
            pw.nextColumn();
            pw.print(BaselineExpression.FIELDS[i]);
        }
        if (isKD) {
            length = ATARiS.FIELDS.length;
            for (i = 0; i < length; ++i) {
                pw.nextColumn();
                pw.print(ATARiS.FIELDS[i]);
            }
        }
        pw.nextRow();
    }

    private static class PCR {
        private static final String TAXON = "TAXON";
        private static final String CLONEID = "CLONEID";
        private static final String HIGHCONF = "HIGHCONF";
        private static final String CELL_LINE = "CELLLINENAME";
        private static final String[] FIELDS = new String[]{"CELLLINENAME", "HIGHCONF", "PERCENT EXPRESSION", "DDCT", "QPCR_CELL_LINE_MATCH"};
        private static final String FILE = "/xchip/cogs/data/vdb/knockup/trc_kdreport_20120207_BROAD.txt";
        private Map<String, TIntArrayList> idToIndices = new HashMap<String, TIntArrayList>();
        private int[] fieldIndices;
        private String[][] array2d = ((Array2DContentHandler)new ExcelReader("/xchip/cogs/data/vdb/knockup/trc_kdreport_20120207_BROAD.txt", new Array2DContentHandler()).getContentHandler()).getData();
        private int cellLineIndex;

        public PCR() throws IOException {
            int i;
            List<String> header = Arrays.asList(this.array2d[0]);
            int cloneIndex = header.indexOf(CLONEID);
            int taxonIndex = header.indexOf(TAXON);
            int highConfIndex = header.indexOf(HIGHCONF);
            this.cellLineIndex = header.indexOf(CELL_LINE);
            this.fieldIndices = new int[FIELDS.length - 1];
            int length = this.fieldIndices.length;
            for (i = 0; i < length; ++i) {
                this.fieldIndices[i] = header.indexOf(FIELDS[i]);
            }
            length = this.array2d.length;
            for (i = 1; i < length; ++i) {
                String[] array = this.array2d[i];
                if (!array[taxonIndex].trim().equals("human") || !array[highConfIndex].trim().equals("1.00")) continue;
                String clone = array[cloneIndex].trim();
                TIntArrayList indices = this.idToIndices.get(clone);
                if (indices == null) {
                    indices = new TIntArrayList();
                    this.idToIndices.put(clone, indices);
                }
                indices.add(i);
            }
        }

        public void add(String id, String cellLine, DelimWriter pw) {
            TIntArrayList rowIndices = this.idToIndices.get(id);
            boolean cellLineMatch = false;
            if (rowIndices != null && rowIndices.size() > 1) {
                int nrows = rowIndices.size();
                for (int i = 0; i < nrows; ++i) {
                    int rowIndex = rowIndices.getQuick(i);
                    String[] array = this.array2d[rowIndex];
                    if (!array[this.cellLineIndex].equals(cellLine)) continue;
                    rowIndices = new TIntArrayList(new int[]{rowIndex});
                    cellLineMatch = true;
                    break;
                }
            }
            int length = this.fieldIndices.length;
            for (int j = 0; j < length; ++j) {
                pw.nextColumn();
                if (rowIndices == null) continue;
                int nrows = rowIndices.size();
                for (int i = 0; i < nrows; ++i) {
                    int rowIndex = rowIndices.getQuick(i);
                    String[] array = this.array2d[rowIndex];
                    if (i > 0) {
                        pw.print(" ");
                    }
                    pw.print(array[this.fieldIndices[j]]);
                }
            }
            pw.nextColumn();
            if (rowIndices != null) {
                pw.print(cellLineMatch ? "Y" : "N");
            }
        }
    }

    private static class BaselineExpression {
        private static final String[] FIELDS = new String[]{"CCLE_VALUE", "CCLE_AP"};
        private static final String FILE = "/xchip/cogs/data/vdb/knockup/baseline_gex.res";
        private Map<String, Integer> probeIdToIndex;
        private Map<String, Integer> cellLineToIndex;
        private Dataset dataset;

        private BaselineExpression() throws IOException {
            ResReader reader = new ResReader();
            reader.setKeepCalls(true);
            this.dataset = reader.read(FILE).getOriginalDataset();
            this.probeIdToIndex = VectorUtil.createValueToIndexMap(this.dataset.getRowMetadata().get(0));
            this.cellLineToIndex = VectorUtil.createValueToIndexMap(this.dataset.getColumnMetadata().get(0));
        }

        public void add(String probeId, String cellLine, DelimWriter pw) {
            pw.nextColumn();
            Integer probeIndex = this.probeIdToIndex.get(probeId);
            Integer cellLineIndex = this.cellLineToIndex.get(cellLine);
            if (probeIndex != null && cellLineIndex != null) {
                pw.print(Formatter.format(this.dataset.getValue(probeIndex, cellLineIndex)));
            }
            pw.nextColumn();
            if (probeIndex != null && cellLineIndex != null) {
                pw.print(this.dataset.getObjectValue(probeIndex, cellLineIndex, 1));
            }
        }
    }

    private static class ATARiSInfo {
        private String cscore;
        private String qval;

        public ATARiSInfo(String cscore, String qval) {
            this.cscore = cscore;
            this.qval = qval;
        }
    }

    private static class ATARiS {
        private String[][] array2d;
        private static final String FILE = "/xchip/cogs/data/vdb/knockup/ach.v110303.hp.table.txt";
        private Map<String, ATARiSInfo> idToInfo = new HashMap<String, ATARiSInfo>();
        private static final String[] FIELDS = new String[]{"ATARiS cscore", "ATARiS q_value"};

        public ATARiS() throws IOException {
            this.array2d = ((Array2DContentHandler)new ExcelReader(FILE, new Array2DContentHandler()).getContentHandler()).getData();
            List<String> header = Arrays.asList(this.array2d[0]);
            int shRNAIndex = header.indexOf("shRNA");
            int cscoreIndex = header.indexOf("cscore");
            int qvalIndex = header.indexOf("qval");
            int length = this.array2d.length;
            for (int i = 1; i < length; ++i) {
                String[] array = this.array2d[i];
                String clone = array[shRNAIndex].trim();
                clone = clone.substring(0, clone.length() - "m_st".length());
                this.idToInfo.put(clone, new ATARiSInfo(array[cscoreIndex], array[qvalIndex]));
            }
        }

        public void add(String id, DelimWriter pw) {
            pw.nextColumn();
            ATARiSInfo info = this.idToInfo.get(id);
            if (info != null) {
                pw.print(info.cscore);
            }
            pw.nextColumn();
            if (info != null) {
                pw.print(info.qval);
            }
        }
    }

    private static class Achilles {
        private static final String FILE = "/xchip/cogs/data/vdb/knockup/achilles2.gct";
        private Dataset dataset = ProjectIO.readProject("/xchip/cogs/data/vdb/knockup/achilles2.gct").getOriginalDataset();
        private Map<String, Integer> trcIdToIndex;
        private Map<String, Integer> cellLineToIndex = VectorUtil.createValueToIndexMap(this.dataset.getColumnMetadata().get(0));
        private static final String[] FIELDS = new String[]{"Achilles"};

        public Achilles() throws IOException {
            this.trcIdToIndex = new HashMap<String, Integer>();
            Vector ids = this.dataset.getRowMetadata().get(0);
            int nrows = this.dataset.getRowCount();
            for (int i = 0; i < nrows; ++i) {
                String clone = (String)ids.getValue(i);
                clone = clone.substring(0, clone.length() - "m_st".length());
                this.trcIdToIndex.put(clone, i);
            }
        }

        public void add(String hairpin, String cell, DelimWriter pw) {
            pw.nextColumn();
            Integer rowIndex = this.trcIdToIndex.get(hairpin);
            Integer columnIndex = this.cellLineToIndex.get(cell);
            if (rowIndex != null && columnIndex != null) {
                pw.print(Formatter.format(this.dataset.getValue(rowIndex, columnIndex)));
            }
        }

        public static void createSubset() throws IOException {
            String file = "/Users/jgould/Downloads/20110303_achilles2_PMAD_adjFC.rnai.gct";
            Dataset dataset = ProjectIO.readProject(file).getOriginalDataset();
            TIntArrayList indices = new TIntArrayList();
            HashSet<String> cellLines = new HashSet<String>(Arrays.asList(CELL_LINES));
            int ncols = dataset.getColumnCount();
            for (int j = 0; j < ncols; ++j) {
                String cellLine = (String)dataset.getColumnMetadata().get(0).getValue(j);
                if (!cellLines.contains(cellLine = cellLine.substring(0, cellLine.indexOf(95)))) continue;
                indices.add(j);
            }
            dataset = DatasetUtil.sliceView(dataset, null, indices.toArray());
            ProjectIO.writeProject((Project)new DefaultProject(dataset), "gct", "achilles2", true);
        }
    }

    @CommandLineInterface(application="knockup")
    public static interface KnockUpArgs {
        @Option(longName={"gct"}, description="GCT file to run report on")
        public String getGctFile();
    }
}

