/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.scripts;

import java.io.File;
import org.broadinstitute.genee.cmap.scripts.ScriptUtil;
import org.broadinstitute.genee.io.luminex.LuminexCsvWriter;
import org.broadinstitute.genee.io.util.IOUtil;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;
import uk.co.flamingpenguin.jewel.cli.Cli;
import uk.co.flamingpenguin.jewel.cli.CliFactory;
import uk.co.flamingpenguin.jewel.cli.CommandLineInterface;
import uk.co.flamingpenguin.jewel.cli.Option;

public class LXB2JCSV {
    public static void main(String[] args) throws Exception {
        try {
            Lxb2CsvArgs argsp;
            File outputFile;
            Cli cli = CliFactory.createCli(Lxb2CsvArgs.class);
            if (args.length == 0) {
                System.out.println(cli.getHelpMessage());
                System.exit(0);
            }
            File file = outputFile = (argsp = (Lxb2CsvArgs)cli.parseArguments(args)).isOutputFile() ? argsp.getOutputFile() : new File(ScriptUtil.getOutputDir(argsp), IOUtil.getBaseFileName(argsp.getDirectory()) + ".jcsv");
            if (!outputFile.getName().endsWith(".jcsv")) {
                outputFile = new File(outputFile.getParentFile(), outputFile.getName() + ".jcsv");
            }
            if (!argsp.isNoReport()) {
                ScriptUtil.createReport(outputFile, argsp);
            }
            LuminexCsvWriter.write(outputFile.getCanonicalPath(), new File(argsp.getDirectory()), null);
        }
        catch (ArgumentValidationException e) {
            System.err.println(e.getMessage());
        }
    }

    @CommandLineInterface(application="lxb2jcsv")
    public static interface Lxb2CsvArgs {
        @Option(longName={"input"}, shortName={"i"}, description="Directory containing LXB files")
        public String getDirectory();

        @Option(longName={"output"}, shortName={"o"}, description="JCSV output file")
        public File getOutputFile();

        public boolean isOutputFile();

        @Option(longName={"no-report"}, description="Don't create report")
        public boolean isNoReport();

        @Option(helpRequest=true, description="display help", shortName={"h"}, longName={"help"})
        public boolean getHelp();
    }
}

