/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.scripts;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.menu.file.StringTableModel;
import org.broadinstitute.genee.io.excel.Array2DContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.excel.ExcelReaderContentHandler;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.Vector;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;
import uk.co.flamingpenguin.jewel.cli.Cli;
import uk.co.flamingpenguin.jewel.cli.CliFactory;
import uk.co.flamingpenguin.jewel.cli.CommandLineInterface;
import uk.co.flamingpenguin.jewel.cli.Option;

public class Rma2Gct {
    public static void main(String[] args) throws Exception {
        try {
            String outputDirectory;
            Cli cli = CliFactory.createCli(Rma2GctArgs.class);
            if (args.length == 0) {
                System.out.println(cli.getHelpMessage());
                System.exit(0);
            }
            Rma2GctArgs argsp = (Rma2GctArgs)cli.parseArguments(args);
            String[][] tagFileData = ((Array2DContentHandler)new ExcelReader(argsp.getTag(), 1, (ExcelReaderContentHandler)new Array2DContentHandler()).getContentHandler()).getData();
            Array2DContentHandler handler = new Array2DContentHandler();
            FileInputStream fis = new FileInputStream(argsp.getRma());
            ExcelReader.parseAsText(fis, '\t', 0, handler);
            fis.close();
            Dataset dataset = ProjectIO.readProject(new StringTableModel(handler.getData()), 1, 1, "").getOriginalDataset();
            HashMap<String, Integer> sampleIdToIndex = new HashMap<String, Integer>();
            Vector sampleIds = dataset.getColumnMetadata().get(0);
            for (int i = 0; i < sampleIds.size(); ++i) {
                String id = IOUtil.getBaseFileName((String)sampleIds.getValue(i));
                sampleIds.setValue(i, id);
                sampleIdToIndex.put(id, i);
            }
            String[] header = tagFileData[0];
            Vector[] vectors = new Vector[header.length - 1];
            for (int j = 1; j < header.length; ++j) {
                vectors[j - 1] = dataset.getColumnMetadata().add(header[j], String.class);
            }
            int size = tagFileData.length;
            for (int i = 1; i < size; ++i) {
                String tagId = tagFileData[i][0];
                Integer datasetColumnIndex = (Integer)sampleIdToIndex.get(tagId);
                if (datasetColumnIndex == null) continue;
                for (int j = 1; j < header.length; ++j) {
                    vectors[j - 1].setValue(datasetColumnIndex, tagFileData[i][j]);
                }
            }
            String string = outputDirectory = argsp.isOutputDirectory() ? argsp.getOutputDirectory() : null;
            if (outputDirectory == null) {
                outputDirectory = System.getProperty("user.dir");
            }
            File outputFile = new File(outputDirectory, IOUtil.getBaseFileName(argsp.getRma()) + "_rnorm.gct");
            ProjectIO.writeProject((Project)new DefaultProject(dataset), "gct", outputFile.getCanonicalPath(), true);
        }
        catch (ArgumentValidationException e) {
            System.err.println(e.getMessage());
        }
    }

    @CommandLineInterface(application="rma2gct")
    public static interface Rma2GctArgs {
        @Option(longName={"output"}, shortName={"o"}, description="the output directory")
        public String getOutputDirectory();

        @Option(longName={"rma"}, shortName={"r"}, description="the RMA output file")
        public String getRma();

        @Option(longName={"tag"}, shortName={"t"}, description="the GSE tag file")
        public String getTag();

        public boolean isOutputDirectory();
    }
}

