/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.scripts;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.broadinstitute.genee.category.DefaultVectorColorModel;
import org.broadinstitute.genee.cmap.rankedlist.HighlightTrack;
import org.broadinstitute.genee.cmap.rankedlist.RankedListComponent;
import org.broadinstitute.genee.cmap.rankedlist.RankedListFilterCollection;
import org.broadinstitute.genee.io.util.ImageUtil;
import org.broadinstitute.genee.matrix.ColumnMajorArray1DDataset;
import org.broadinstitute.genee.matrix.rankedlist.DatasetRankedList;

public class SavedRankedListExample {
    public static void main(String[] args) throws IOException {
        float[] scores = new float[1000];
        for (int i = 0; i < scores.length; ++i) {
            scores[i] = (float)(Math.random() * 100.0);
            if (!(Math.random() > 0.5)) continue;
            scores[i] = -scores[i];
        }
        ColumnMajorArray1DDataset dataset = new ColumnMajorArray1DDataset("", scores.length, 1, scores);
        DatasetRankedList rankedList = new DatasetRankedList(dataset, 0, null);
        RankedListFilterCollection coll = new RankedListFilterCollection();
        RankedListComponent component = new RankedListComponent(rankedList, new HighlightTrack(coll, new DefaultVectorColorModel()));
        component.setDrawRanks(true);
        coll.setInstanceIds(new HashSet<Object>(Arrays.asList(10, 90)));
        ImageUtil.saveImage(component, "png", new File("test.png"), false);
    }
}

