/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmdline;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.broadinstitute.genee.cmdline.MafConcat;
import org.broadinstitute.genee.io.excel.Array2DContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.util.IOUtil;

public class MafToSampleInfo
implements MafConcat {
    private Set<String> genes;
    private Map<String, Map<String, String>> sampleToGeneToValue = new HashMap<String, Map<String, String>>();

    public MafToSampleInfo() {
        this.genes = new TreeSet<String>();
    }

    @Override
    public void add(String mafFile) throws IOException {
        String[][] data = ((Array2DContentHandler)new ExcelReader(mafFile, new Array2DContentHandler()).getContentHandler()).getData();
        List<String> header = Arrays.asList(data[0]);
        int geneSymbolColumn = header.indexOf("Hugo_Symbol");
        if (geneSymbolColumn == -1) {
            throw new IOException("Hugo_Symbol not found");
        }
        int sampleIdColumn = header.indexOf("Tumor_Sample_Barcode");
        if (sampleIdColumn == -1) {
            System.out.println("Using Array_ID");
            sampleIdColumn = header.indexOf("Array_ID");
        }
        if (sampleIdColumn == -1) {
            throw new IOException("Array_ID not found");
        }
        String sampleId = IOUtil.getBaseFileName(IOUtil.getBaseFileName(mafFile));
        int variantClassificationColumn = header.indexOf("Variant_Classification");
        int dnaChangeColumn = header.indexOf("Genome_Change");
        int proteinChangeColumn = header.indexOf("Protein_Change");
        int amino_acid_change_WUColumn = header.indexOf("amino_acid_change_WU");
        int length = data.length;
        for (int i = 1; i < length; ++i) {
            String amino_acid_change_WU;
            String[] row = data[i];
            Map<String, String> geneToValue = this.sampleToGeneToValue.get(sampleId);
            if (geneToValue == null) {
                geneToValue = new HashMap<String, String>();
                this.sampleToGeneToValue.put(sampleId, geneToValue);
            }
            String gene = row[geneSymbolColumn];
            this.genes.add(gene);
            String proteinChange = proteinChangeColumn == -1 ? "" : row[proteinChangeColumn];
            String dnaChange = dnaChangeColumn == -1 ? "" : row[dnaChangeColumn];
            String variantClassification = variantClassificationColumn == -1 ? "" : row[variantClassificationColumn];
            String string = amino_acid_change_WU = amino_acid_change_WUColumn == -1 ? "" : row[amino_acid_change_WUColumn];
            String geneValue = !proteinChange.equals("") ? proteinChange : (!amino_acid_change_WU.equals("") ? amino_acid_change_WU : (!dnaChange.equals("") ? dnaChange : variantClassification));
            geneToValue.put(gene, geneValue);
        }
    }

    @Override
    public void save(String file) throws IOException {
        PrintWriter pw = new PrintWriter(file + ".maf.txt");
        pw.print("Id");
        for (String gene : this.genes) {
            pw.print("\t");
            pw.print(gene);
        }
        pw.println();
        for (String sample : this.sampleToGeneToValue.keySet()) {
            pw.print(sample);
            Map<String, String> geneToValue = this.sampleToGeneToValue.get(sample);
            for (String gene : this.genes) {
                pw.print("\t");
                String geneValue = geneToValue.get(gene);
                pw.print(geneValue == null ? "" : geneValue);
            }
            pw.println();
        }
        pw.close();
    }
}

