/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmdline;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.broadinstitute.genee.cmdline.BasicCmdLineArgs;
import org.broadinstitute.genee.cmdline.CmdLineUtil;
import org.broadinstitute.genee.cmdline.HeatMapImage;
import org.broadinstitute.genee.gui.actions.ToolRunner;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.FloatRange;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.gctx.GctxReader;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.math.FloatListStatUtils;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetRowView;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;
import uk.co.flamingpenguin.jewel.cli.Cli;
import uk.co.flamingpenguin.jewel.cli.CliFactory;
import uk.co.flamingpenguin.jewel.cli.CommandLineInterface;
import uk.co.flamingpenguin.jewel.cli.Option;

public class MarkerSelectionTool {
    public static void main(String[] args) throws Exception {
        try {
            Cli cli = CliFactory.createCli(MarkerSelectionToolArgs.class);
            if (args.length == 0) {
                System.out.println(cli.getHelpMessage());
                System.exit(0);
            }
            MarkerSelectionToolArgs argsp = (MarkerSelectionToolArgs)cli.parseArguments(args);
            List<String> aIds = CmdLineUtil.getIds(argsp.getClassA());
            List<String> bIds = CmdLineUtil.getIds(argsp.getClassB());
            ArrayList<String> allIds = new ArrayList<String>();
            allIds.addAll(aIds);
            allIds.addAll(bIds);
            Dataset inputDataset = GctxReader.read(argsp.getInputDataset(), null, allIds, true);
            HashSet<String> inputNames = new HashSet<String>(MetadataUtil.getNames(inputDataset.getRowMetadata()));
            ToolRunner runner = new ToolRunner("Marker Selection", new DefaultProject(inputDataset));
            runner.setParameterValue("Comparison(s)", CmdLineUtil.toComparisonString(aIds, bIds));
            runner.setParameterValue("Permutations", argsp.getPermutations());
            runner.setParameterValue("Markers", argsp.getNumberOfMarkers());
            Project p = runner.execute()[0];
            Vector comparisonVector = p.getOriginalDataset().getColumnMetadata().get("");
            comparisonVector.setProperty("Color Visible", true);
            final String aName = argsp.getClassAName();
            String bName = argsp.getClassBName();
            int size = comparisonVector.size();
            for (int j = 0; j < size; ++j) {
                if ("A".equals(comparisonVector.getValue(j))) {
                    comparisonVector.setValue(j, aName);
                    continue;
                }
                comparisonVector.setValue(j, bName);
            }
            comparisonVector.setComparator(new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    Integer s1 = o1.equals(aName) ? 0 : 1;
                    Integer s2 = o2.equals(aName) ? 0 : 1;
                    return s1.compareTo(s2);
                }
            });
            if (argsp.isBasic()) {
                Dataset dataset = p.getSortedFilteredDataset();
                List<String> names = MetadataUtil.getNames(dataset.getRowMetadata());
                for (String name : names) {
                    if (inputNames.contains(name)) continue;
                    dataset.getRowMetadata().remove(dataset.getRowMetadata().getColumnIndex(name));
                }
            }
            if (argsp.isShowRange()) {
                Dataset dataset = p.getSortedFilteredDataset();
                Vector range = dataset.getRowMetadata().add("range", FloatRange.class);
                Vector minVector = MetadataUtil.addRowVector(dataset.getRowMetadata(), "min", Float.class, true);
                Vector maxVector = MetadataUtil.addRowVector(dataset.getRowMetadata(), "max", Float.class, true);
                range.setProperty("Chart Style", 8);
                DatasetRowView rowView = new DatasetRowView(dataset);
                int nrows = dataset.getRowCount();
                for (int i = 0; i < nrows; ++i) {
                    rowView.setIndex(i);
                    float min = FloatListStatUtils.min(rowView);
                    minVector.setValue(i, Float.valueOf(min));
                    float max = FloatListStatUtils.max(rowView);
                    maxVector.setValue(i, Float.valueOf(max));
                    range.setValue(i, new FloatRange(min, max));
                }
            }
            if (argsp.isOutputGctx()) {
                ProjectIO.writeProject(p, "gctx", argsp.getOutputGctx(), false);
            }
            HeatMapImage.createImage(p, argsp);
        }
        catch (ArgumentValidationException e) {
            System.err.println(e.getMessage());
        }
    }

    @CommandLineInterface(application="marker-selection")
    public static interface MarkerSelectionToolArgs
    extends BasicCmdLineArgs,
    HeatMapImage.HeatMapImageArgs {
        @Option(shortName={"a"}, description="list of class A ids or one grp file of ids")
        public List<String> getClassA();

        @Option(longName={"show-row-range"}, description="Draw the row range")
        public boolean isShowRange();

        @Option(longName={"a-name"}, description="class a name", defaultValue={"A"})
        public String getClassAName();

        @Option(longName={"permutations"}, description="Number of permutations", defaultValue={"1000"})
        public int getPermutations();

        @Option(shortName={"b"}, description="list of class B ids or one grp file of ids")
        public List<String> getClassB();

        @Option(longName={"b-name"}, description="class b name", defaultValue={"B"})
        public String getClassBName();

        @Option(longName={"markers"}, description="the number of markers to show in the heat map", defaultValue={"100"})
        public int getNumberOfMarkers();

        @Option(longName={"output-gctx"}, description="the output gctx file")
        public String getOutputGctx();

        @Option(longName={"simple-heat-map"}, description="don't output marker selection statistics in heat map, such as s2n, p-value, FDR, etc.")
        public boolean isBasic();

        public boolean isOutputGctx();
    }
}

