/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.compound;

import gnu.trove.list.array.TFloatArrayList;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.broadinstitute.genee.io.util.ToStringUtil;
import org.broadinstitute.genee.stats.Sorting;

public class CombinationIndex {
    public static MedianEffectResult computeMedianEffect(List<? extends Drug> individualDrugs, Drug combinedDrug) {
        ArrayList<? extends Drug> list = new ArrayList<Drug>();
        list.addAll(individualDrugs);
        list.add(combinedDrug);
        ArrayList<MedianEffect> medianEffects = new ArrayList<MedianEffect>();
        int ndrugs = list.size();
        for (int drugIndex = 0; drugIndex < ndrugs; ++drugIndex) {
            Drug drug = (Drug)list.get(drugIndex);
            float[] dose = drug.getDose();
            float[] fractionEffected = drug.getFractionEffected();
            SimpleRegression regression = new SimpleRegression();
            for (int j = 0; j < dose.length; ++j) {
                float fa = fractionEffected[j];
                float x = CombinationIndex.log10(dose[j]);
                float y = CombinationIndex.log10(fa / (1.0f - fa));
                if (Float.isInfinite(y)) continue;
                regression.addData((double)x, (double)y);
            }
            float xIntercept = (float)(-regression.getIntercept() / regression.getSlope());
            float Dm = (float)Math.pow(10.0, xIntercept);
            float m = (float)regression.getSlope();
            if (Float.isNaN(xIntercept)) {
                xIntercept = 0.0f;
                Dm = 0.0f;
                m = 1.0f;
            }
            MedianEffect medianEffect = new MedianEffect(drug, Dm, m, (float)regression.getR(), (float)regression.getIntercept());
            medianEffects.add(medianEffect);
        }
        MedianEffectResult r = new MedianEffectResult();
        r.comboEffect = (MedianEffect)medianEffects.remove(medianEffects.size() - 1);
        r.individualEffects = medianEffects;
        return r;
    }

    public static float getCI(float fa, List<MedianEffect> individualDrugs, MedianEffect comboDrug, boolean mutuallyExclusive) {
        float[] DxArray = new float[individualDrugs.size()];
        int ndrugs = individualDrugs.size();
        for (int drugIndex = 0; drugIndex < ndrugs; ++drugIndex) {
            float Dx;
            MedianEffect medianEffect = individualDrugs.get(drugIndex);
            DxArray[drugIndex] = Dx = CombinationIndex.getDx(fa, medianEffect.getDm(), medianEffect.getM());
        }
        float DxCombo = CombinationIndex.getDx(fa, comboDrug.getDm(), comboDrug.getM());
        float CI = CombinationIndex.normalizeCombinationIndex(DxArray, DxCombo, comboDrug.getDrug().getRatio(), mutuallyExclusive);
        return CI;
    }

    public static float getCI(float fa, float[] Dm, float[] m, float comboDm, float comboM, float[] ratio, boolean mutuallyExclusive) {
        float[] DxArray = new float[Dm.length];
        int ndrugs = DxArray.length;
        for (int drugIndex = 0; drugIndex < ndrugs; ++drugIndex) {
            float Dx;
            DxArray[drugIndex] = Dx = CombinationIndex.getDx(fa, Dm[drugIndex], m[drugIndex]);
        }
        float DxCombo = CombinationIndex.getDx(fa, comboDm, comboM);
        float CI = CombinationIndex.normalizeCombinationIndex(DxArray, DxCombo, ratio, mutuallyExclusive);
        return CI;
    }

    public static float getDx(float fa, float Dm, float m) {
        float Dx = (float)((double)Dm * Math.pow(fa / (1.0f - fa), 1.0f / m));
        return Dx;
    }

    private static float[] getIndividualDoses(float[] ratio, float drugADose) {
        float[] d = new float[ratio.length];
        float base = ratio[0];
        for (int i = 0; i < d.length; ++i) {
            d[i] = ratio[i] / base * drugADose;
        }
        return d;
    }

    public static float normalizeCombinationIndex(float[] individualDoses, float combinedD, float[] ratio, boolean mutuallyExclusive) {
        int i;
        float[] D = new float[individualDoses.length];
        float total = 0.0f;
        int length = ratio.length;
        for (i = 0; i < length; ++i) {
            total += ratio[i];
        }
        length = individualDoses.length;
        for (i = 0; i < length; ++i) {
            D[i] = combinedD * (ratio[i] / total);
        }
        float CI = 0.0f;
        int length2 = individualDoses.length;
        for (int i2 = 0; i2 < length2; ++i2) {
            CI += D[i2] / individualDoses[i2];
        }
        if (!mutuallyExclusive) {
            float numerator = 1.0f;
            float denom = 1.0f;
            int length3 = D.length;
            for (int i3 = 0; i3 < length3; ++i3) {
                numerator *= D[i3];
                denom *= individualDoses[i3];
            }
            CI += numerator / denom;
        }
        return CI;
    }

    private static float log10(float d) {
        return (float)(d == 0.0f ? -1.0 : Math.log10(d));
    }

    public static class TmpDrug {
        private TFloatArrayList doseList = new TFloatArrayList();
        private String drugName;
        private TFloatArrayList fractionList = new TFloatArrayList();

        public void add(float dose, float fractionAffected) {
            this.doseList.add(dose);
            this.fractionList.add(fractionAffected);
        }

        public Drug createDrug() {
            DefaultDrug drug = new DefaultDrug();
            float[] tmpDoseArray = this.doseList.toArray();
            int[] indices = Sorting.index(tmpDoseArray, true);
            float[] dose = new float[indices.length];
            float[] fraction = new float[indices.length];
            int length = indices.length;
            for (int i = 0; i < length; ++i) {
                fraction[i] = this.fractionList.getQuick(indices[i]);
            }
            boolean isCombination = this.isCombination();
            if (isCombination) {
                drug.setRatio(this.getRatio());
                System.out.println("ratio " + ToStringUtil.toString(this.getRatio(), ", "));
            }
            int length2 = indices.length;
            for (int i = 0; i < length2; ++i) {
                if (isCombination) {
                    dose[i] = tmpDoseArray[indices[i]];
                    dose[i] = dose[i] * (this.getRatio()[1] / this.getRatio()[0]);
                    continue;
                }
                dose[i] = tmpDoseArray[indices[i]];
            }
            drug.setDose(dose);
            drug.setDrugName(this.drugName);
            drug.setFractionEffected(fraction);
            return drug;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TmpDrug) {
                TmpDrug t = (TmpDrug)obj;
                return t.drugName.equals(this.drugName);
            }
            return false;
        }

        public float[] getRatio() {
            int comma = this.drugName.lastIndexOf(44);
            String ratio = this.drugName.substring(comma + 1).trim();
            String[] tokens = ratio.split(":");
            TFloatArrayList list = new TFloatArrayList(tokens.length);
            for (String token : tokens) {
                if (token == null || (token = token.trim()).equals("")) continue;
                list.add((float)Integer.parseInt(token));
            }
            return list.toArray();
        }

        public int hashCode() {
            return this.drugName.hashCode();
        }

        public boolean isCombination() {
            return this.drugName.indexOf(47) != -1;
        }

        public void setDrugName(String drug) {
            this.drugName = drug;
        }
    }

    public static class MedianEffectResult {
        MedianEffect comboEffect;
        List<MedianEffect> individualEffects;

        public String toString() {
            return this.comboEffect + "\n" + this.individualEffects;
        }
    }

    public static class MedianEffect {
        private float Dm;
        private Drug drug;
        private float m;
        private float r;
        private float yInt;

        public MedianEffect(Drug drug, float Dm, float m, float r, float yInt) {
            this.Dm = Dm;
            this.m = m;
            this.r = r;
            this.yInt = yInt;
            this.drug = drug;
        }

        public float getDm() {
            return this.Dm;
        }

        public Drug getDrug() {
            return this.drug;
        }

        public float getM() {
            return this.m;
        }

        public float getB() {
            return this.yInt;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.drug.getDrugName());
            buf.append(", Dm: ");
            buf.append(this.Dm);
            buf.append(", m: ");
            buf.append(this.m);
            buf.append(", r: ");
            buf.append(this.r);
            buf.append(", b: ");
            buf.append(this.yInt);
            return buf.toString();
        }

        public float getR() {
            return this.r;
        }

        public void setR(float r) {
            this.r = r;
        }

        public float getyInt() {
            return this.yInt;
        }

        public void setyInt(float yInt) {
            this.yInt = yInt;
        }

        public void setDm(float dm) {
            this.Dm = dm;
        }

        public void setDrug(Drug drug) {
            this.drug = drug;
        }

        public void setM(float m) {
            this.m = m;
        }
    }

    public static interface Drug {
        public float[] getDose();

        public String getDrugName();

        public float[] getFractionEffected();

        public float[] getRatio();

        public boolean isCombined();
    }

    public static class DefaultDrug
    implements Drug {
        private float[] dose;
        private String drugName;
        private float[] fractionEffected;
        private float[] ratio;

        public DefaultDrug() {
        }

        public DefaultDrug(String drugName) {
            this.drugName = drugName;
        }

        @Override
        public float[] getDose() {
            return this.dose;
        }

        @Override
        public String getDrugName() {
            return this.drugName;
        }

        @Override
        public float[] getFractionEffected() {
            return this.fractionEffected;
        }

        @Override
        public float[] getRatio() {
            return this.ratio;
        }

        @Override
        public boolean isCombined() {
            return this.ratio != null;
        }

        public void setDose(float[] dose) {
            this.dose = dose;
        }

        public void setDrugName(String drugName) {
            this.drugName = drugName;
        }

        public void setFractionEffected(float[] fractionEffected) {
            this.fractionEffected = fractionEffected;
        }

        public void setRatio(float[] ratio) {
            this.ratio = ratio;
        }
    }
}

