/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.compound;

import chemaxon.descriptors.BCUT;
import chemaxon.descriptors.BCUTParameters;
import chemaxon.descriptors.CFParameters;
import chemaxon.descriptors.ChemicalFingerprint;
import chemaxon.descriptors.ECFP;
import chemaxon.descriptors.ECFPParameters;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.descriptors.PFParameters;
import chemaxon.descriptors.PharmacophoreFingerprint;
import chemaxon.descriptors.ShapeDescriptor;
import chemaxon.descriptors.ShapeParameters;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.license.LicenseManager;
import chemaxon.license.LicenseProcessingException;
import chemaxon.reaction.Standardizer;
import chemaxon.struc.Molecule;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.genee.application.UserUtil;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.molecule.AbstractMoleculeDistanceFunction;
import org.broadinstitute.genee.matrix.Dataset;

public class MoleculeUtil {
    private static Standardizer standardizer;
    private static Class<?> MOL_CLASS;

    public static float getBCUTDistance(Molecule m1, Molecule m2) {
        if (m1 == null) {
            throw new NullPointerException("m1 can not be null.");
        }
        if (m2 == null) {
            throw new NullPointerException("m2 can not be null.");
        }
        BCUT cfp1 = new BCUT(new BCUTParameters());
        BCUT cfp2 = new BCUT(new BCUTParameters());
        try {
            cfp1.generate(m1);
            cfp2.generate(m2);
            return cfp1.getDissimilarity((MolecularDescriptor)cfp2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1.0f;
        }
    }

    public static float getExtendedConnectivityFingerprintDistanceTanimoto(Molecule m1, Molecule m2) {
        if (m1 == null) {
            throw new NullPointerException("m1 can not be null.");
        }
        if (m2 == null) {
            throw new NullPointerException("m2 can not be null.");
        }
        ECFP cfp1 = new ECFP(new ECFPParameters());
        ECFP cfp2 = new ECFP(new ECFPParameters());
        try {
            cfp1.generate(m1);
            cfp2.generate(m2);
            return cfp1.getTanimoto(cfp2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1.0f;
        }
    }

    public static float getExtendedTanimoto(Molecule m1, Molecule m2) {
        if (m1 == null) {
            throw new NullPointerException("m1 can not be null.");
        }
        if (m2 == null) {
            throw new NullPointerException("m2 can not be null.");
        }
        ECFP cfp1 = new ECFP(new ECFPParameters());
        ECFP cfp2 = new ECFP(new ECFPParameters());
        try {
            cfp1.generate(m1);
            cfp2.generate(m2);
            return cfp1.getTanimoto(cfp2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1.0f;
        }
    }

    public static Class<?> getMoleculeClass() {
        return MOL_CLASS;
    }

    public static String getName(Molecule m) {
        String name = m.getName();
        if (name == null || name.equals("")) {
            name = (String)m.getPropertyObject("name");
        }
        if (name == null || name.equals("")) {
            name = (String)m.getPropertyObject("chemical_name");
        }
        if (name == null) {
            name = m.getFormula();
        }
        return name;
    }

    public static float getPharmacophoreFingerprintTanimoto(Molecule m1, Molecule m2) {
        if (m1 == null) {
            throw new NullPointerException("m1 can not be null.");
        }
        if (m2 == null) {
            throw new NullPointerException("m2 can not be null.");
        }
        PharmacophoreFingerprint cfp1 = new PharmacophoreFingerprint(new PFParameters());
        PharmacophoreFingerprint cfp2 = new PharmacophoreFingerprint(new PFParameters());
        try {
            cfp1.generate(m1);
            cfp2.generate(m2);
            return cfp1.getTanimoto(cfp2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1.0f;
        }
    }

    public static float getShapeDistance(Molecule m1, Molecule m2) {
        if (m1 == null) {
            throw new NullPointerException("m1 can not be null.");
        }
        if (m2 == null) {
            throw new NullPointerException("m2 can not be null.");
        }
        ShapeDescriptor cfp1 = new ShapeDescriptor(new ShapeParameters());
        ShapeDescriptor cfp2 = new ShapeDescriptor(new ShapeParameters());
        try {
            cfp1.generate(m1);
            cfp2.generate(m2);
            return cfp1.getDissimilarity((MolecularDescriptor)cfp2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1.0f;
        }
    }

    public static InputStream getStandardizerXml() throws IOException {
        return MoleculeUtil.class.getResource("/org/broadinstitute/genee/resources/cbip-standardizer.xml").openStream();
    }

    public static void fillDistanceMatrix(Dataset dataset, Dataset dest, AbstractMoleculeDistanceFunction function) throws Exception {
        String moleculeColumnName = function.getMoleculeColumnName();
        int rows = dataset.getRowCount();
        for (int i = 0; i < rows; ++i) {
            Molecule m1 = (Molecule)dataset.getRowMetadata().getValue(i, moleculeColumnName);
            if (m1 == null) {
                System.out.println("Skipping row " + i);
                continue;
            }
            for (int j = i; j < rows; ++j) {
                Molecule m2 = (Molecule)dataset.getRowMetadata().getValue(j, moleculeColumnName);
                if (m2 == null) continue;
                float dist = function.evaluate(dataset, null, i, j);
                dest.setValue(i, j, dist);
                dest.setValue(j, i, dist);
            }
        }
    }

    public static float[][] getTanimoto(List<Molecule> molecules) throws Exception {
        int i;
        int n = molecules.size();
        float[][] matrix = new float[n][];
        for (i = 1; i < n; ++i) {
            matrix[i] = new float[i];
        }
        for (i = 1; i < n; ++i) {
            Molecule m1 = molecules.get(i);
            ChemicalFingerprint cfp1 = new ChemicalFingerprint(new CFParameters());
            cfp1.generate(m1);
            for (int j = 0; j < i; ++j) {
                Molecule m2 = molecules.get(j);
                ChemicalFingerprint cfp2 = new ChemicalFingerprint(new CFParameters());
                cfp2.generate(m2);
                matrix[i][j] = cfp1.getTanimoto(cfp2);
            }
        }
        return matrix;
    }

    public static float getTanimoto(Molecule m1, Molecule m2) {
        if (m1 == null) {
            throw new NullPointerException("m1 can not be null.");
        }
        if (m2 == null) {
            throw new NullPointerException("m2 can not be null.");
        }
        ChemicalFingerprint cfp1 = new ChemicalFingerprint(new CFParameters());
        ChemicalFingerprint cfp2 = new ChemicalFingerprint(new CFParameters());
        try {
            cfp1.generate(m1);
            cfp2.generate(m2);
            return cfp1.getTanimoto(cfp2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1.0f;
        }
    }

    public static float[] getTanimoto(String smile, String[] smiles) throws Exception {
        ChemicalFingerprint cfp1 = new ChemicalFingerprint(new CFParameters());
        Molecule m1 = MoleculeUtil.read(smile);
        cfp1.generate(m1);
        float[] dist = new float[smiles.length];
        int rows = smiles.length;
        for (int i = 0; i < rows; ++i) {
            ChemicalFingerprint cfp2 = new ChemicalFingerprint(new CFParameters());
            Molecule m2 = MoleculeUtil.read(smiles[i]);
            cfp2.generate(m2);
            dist[i] = cfp1.getTanimoto(cfp2);
        }
        return dist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (UserUtil.isBroadUser()) {
            try {
                LicenseManager.setLicenseFile((String)"/org/broadinstitute/genee/resources/license.cxl");
            }
            catch (LicenseProcessingException e) {
                System.out.println("Unable to validate JChem license.");
            }
            try {
                MOL_CLASS = Class.forName("chemaxon.struc.Molecule");
            }
            catch (ClassNotFoundException e) {
                System.out.println("Molecule class not found.");
            }
        }
        InputStream is = null;
        try {
            is = MoleculeUtil.getStandardizerXml();
            standardizer = new Standardizer(is);
        }
        catch (Exception e) {
            System.out.println("Unable to create Standardizer");
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Molecule> read(File file) throws MolFormatException, IOException {
        try (MolImporter importer = null;){
            importer = new MolImporter(file, null);
            Molecule m = null;
            ArrayList<Molecule> molecules = new ArrayList<Molecule>();
            while ((m = importer.read()) != null) {
                MoleculeUtil.standardize(m);
                molecules.add(m);
            }
            ArrayList<Molecule> arrayList = molecules;
            return arrayList;
        }
    }

    public static Molecule read(String s) {
        try {
            if (s == null || s.equals("")) {
                return null;
            }
            Molecule m = MolImporter.importMol((String)s);
            MoleculeUtil.standardize(m);
            return m;
        }
        catch (MolFormatException e) {
            return null;
        }
    }

    public static void standardize(Molecule m) {
        try {
            standardizer.standardize(m);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            m.dearomatize();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String toSmile(Molecule m) {
        if (m == null) {
            return "";
        }
        try {
            return MolExporter.exportToFormat((Molecule)m, (String)"smiles:a-H");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    static {
        MoleculeUtil.init();
    }
}

