/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.compound.painter;

import com.google.common.collect.Sets;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import gnu.trove.list.array.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.broadinstitute.genee.compound.painter.ImageElement;
import org.broadinstitute.genee.compound.painter.ImageElementPainter;
import org.broadinstitute.genee.compound.painter.ImageTypePanel;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.ThreeListsComponent;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.parameters.FileInputParameter;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.SortKeys;
import org.broadinstitute.genee.heatmap.SortOrder;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.VectorUtil;

class ImageLayoutChooser
extends JPanel {
    private Map<JCheckBox, ImageTypePanel> imageTypeCheckBoxToImageTypePanel;
    private ThreeListsComponent labeledThreeListsPanel;
    private Map<String, List<AbstractButton>> metadataNameToCheckBoxes = new HashMap<String, List<AbstractButton>>();
    private FileInputParameter fileInputPanel;
    private JTextField maxImagesToShow;

    ImageLayoutChooser(HeatMapPanel heatMapPanel, final DefaultProject project, List<ImageTypePanel> imageTypePanels) {
        String[] heatMapColumnsTest;
        if (heatMapPanel == null) {
            throw new NullPointerException("heatMapPanel is null");
        }
        heatMapPanel.setElementPainter(new ImageElementPainter());
        TreeMap metadataNameToValues = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        for (ImageTypePanel imageTypePanel : imageTypePanels) {
            for (String metadataName : imageTypePanel.getMetadataNameToValueToFiles().keySet()) {
                TreeSet<Comparable> values = (TreeSet<Comparable>)metadataNameToValues.get(metadataName);
                if (values == null) {
                    values = new TreeSet<Comparable>();
                    metadataNameToValues.put(metadataName, values);
                }
                Map<Comparable, List<File>> valueToFiles = imageTypePanel.getMetadataNameToValueToFiles().get(metadataName);
                for (Comparable value : valueToFiles.keySet()) {
                    values.add(value);
                }
            }
        }
        int formRows = 0;
        for (String name : metadataNameToValues.keySet()) {
            Set values = (Set)metadataNameToValues.get(name);
            formRows = Math.max(values.size(), formRows);
        }
        formRows = Math.max(formRows, imageTypePanels.size());
        JPanel checkBoxPanel = new JPanel((LayoutManager)new FormLayout(UIUtil.createColumnStringForFormLayout(metadataNameToValues.size() + 1), UIUtil.createRowStringForFormLayout(formRows + 2)));
        int columnIndex = 1;
        for (String metadataName : metadataNameToValues.keySet()) {
            Set values = (Set)metadataNameToValues.get(metadataName);
            this.metadataNameToCheckBoxes.put(metadataName, ImageLayoutChooser.createButtons(checkBoxPanel, columnIndex, metadataName, values, true));
            columnIndex += 2;
        }
        if (imageTypePanels.size() > 1) {
            this.imageTypeCheckBoxToImageTypePanel = ImageLayoutChooser.createImageTypeCheckBoxes(checkBoxPanel, columnIndex, imageTypePanels);
        } else {
            this.imageTypeCheckBoxToImageTypePanel = new HashMap<JCheckBox, ImageTypePanel>();
            JCheckBox cb = new JCheckBox("", true);
            this.imageTypeCheckBoxToImageTypePanel.put(cb, imageTypePanels.get(0));
        }
        this.setLayout(new BorderLayout());
        this.add(UIUtil.createNoBorderScrollPane(checkBoxPanel));
        this.labeledThreeListsPanel = new ThreeListsComponent("Heat map rows", "", "Heat map columns", false);
        this.labeledThreeListsPanel.setLeftListName("heat map rows");
        this.labeledThreeListsPanel.setRightListName("heat map columns");
        this.labeledThreeListsPanel.setItems(new ArrayList<String>(), new ArrayList<String>(this.metadataNameToCheckBoxes.keySet()), new ArrayList<String>());
        if (this.metadataNameToCheckBoxes.containsKey("Drug")) {
            this.labeledThreeListsPanel.move(1, 0, new Object[]{"Drug"});
        }
        for (String key : heatMapColumnsTest = new String[]{"Fibro", "Fibros", "Fibroblast", "Fibroblasts", "fibro", "fibros", "fibroblast", "fibroblasts"}) {
            if (!this.metadataNameToCheckBoxes.containsKey(key)) continue;
            this.labeledThreeListsPanel.move(1, 2, new Object[]{key});
            break;
        }
        JButton viewButton = new JButton("Show Heat Map");
        viewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final List<String> selectedRowMetadataItems = ImageLayoutChooser.this.labeledThreeListsPanel.getLeftItems();
                if (selectedRowMetadataItems.size() == 0) {
                    UIUtil.showErrorDialog(ImageLayoutChooser.this, "Please select items to place on heat map rows");
                    return;
                }
                final List<String> selectedColumnMetadataItems = ImageLayoutChooser.this.labeledThreeListsPanel.getRightItems();
                if (selectedColumnMetadataItems.size() == 0) {
                    UIUtil.showErrorDialog(ImageLayoutChooser.this, "Please select items to place on heat map columns");
                    return;
                }
                final Map heatMapRowMetadataNamesToValues = ImageLayoutChooser.this.getMetadataNameToValuesMap(selectedRowMetadataItems, true);
                final Map heatMapColumnMetadataNamesToValues = ImageLayoutChooser.this.getMetadataNameToValuesMap(selectedColumnMetadataItems, true);
                List<String> unselectedMetadataItems = ImageLayoutChooser.this.labeledThreeListsPanel.getCenterItems();
                final Map metadataNamesToValuesFilter = ImageLayoutChooser.this.getMetadataNameToValuesMap(unselectedMetadataItems, true);
                final ArrayList selectedImageTypes = new ArrayList();
                for (JCheckBox cb : ImageLayoutChooser.this.imageTypeCheckBoxToImageTypePanel.keySet()) {
                    if (!cb.isSelected()) continue;
                    selectedImageTypes.add(ImageLayoutChooser.this.imageTypeCheckBoxToImageTypePanel.get(cb));
                }
                String fileInputString = ImageLayoutChooser.this.fileInputPanel.getText().trim();
                final File inputFile = fileInputString.equals("") ? null : new File(fileInputString);
                new BackgroundTask<Dataset>("Creating heat map"){

                    @Override
                    protected Dataset doInBackground() throws Exception {
                        Project p;
                        int i;
                        int n;
                        Set heatMapRowNames = ImageLayoutChooser.getProduct(heatMapRowMetadataNamesToValues);
                        Set heatMapColumnNames = ImageLayoutChooser.getProduct(heatMapColumnMetadataNamesToValues);
                        int maxImages = Integer.parseInt(ImageLayoutChooser.this.maxImagesToShow.getText().trim());
                        ArrayList<Set[]> rowFilesForEachType = new ArrayList<Set[]>();
                        ArrayList<Set[]> columnFilesForEachType = new ArrayList<Set[]>();
                        for (ImageTypePanel imageTypePanel : selectedImageTypes) {
                            HashSet<File> files = new HashSet<File>(Arrays.asList(imageTypePanel.getImageFiles()));
                            ImageLayoutChooser.filter(files, metadataNamesToValuesFilter, imageTypePanel);
                            rowFilesForEachType.add(ImageLayoutChooser.getFiles(heatMapRowNames, selectedRowMetadataItems, files, imageTypePanel));
                            columnFilesForEachType.add(ImageLayoutChooser.getFiles(heatMapColumnNames, selectedColumnMetadataItems, files, imageTypePanel));
                        }
                        RowMajorArray2DDataset dataset = new RowMajorArray2DDataset("Heat map", heatMapRowNames.size(), heatMapColumnNames.size());
                        for (String name : selectedRowMetadataItems) {
                            MetadataUtil.addRowVector(dataset.getRowMetadata(), name, String.class);
                        }
                        for (String name : selectedColumnMetadataItems) {
                            MetadataUtil.addRowVector(dataset.getColumnMetadata(), name, String.class);
                        }
                        int seriesIndex = dataset.addSeries("Image", ImageElement.class);
                        int index = 0;
                        for (List names : heatMapRowNames) {
                            n = names.size();
                            for (i = 0; i < n; ++i) {
                                dataset.getRowMetadata().setValue(index, (String)selectedRowMetadataItems.get(i), names.get(i));
                            }
                            ++index;
                        }
                        index = 0;
                        for (List names : heatMapColumnNames) {
                            n = names.size();
                            for (i = 0; i < n; ++i) {
                                dataset.getColumnMetadata().setValue(index, (String)selectedColumnMetadataItems.get(i), names.get(i));
                            }
                            ++index;
                        }
                        int rows = dataset.getRowCount();
                        for (int i2 = 0; i2 < rows; ++i2) {
                            int cols = dataset.getColumnCount();
                            for (int j = 0; j < cols; ++j) {
                                dataset.setObjectValue(i2, j, new ImageElement(), seriesIndex);
                            }
                        }
                        Project project = p = inputFile != null ? ProjectIO.readProject(inputFile.getCanonicalPath()) : null;
                        if (p != null) {
                            Dataset dataDataset = p.getOriginalDataset();
                            Map columnNameToIndex = VectorUtil.createValueToIndexMap(dataDataset.getColumnMetadata().get(0));
                            Map rowNameToIndex = VectorUtil.createValueToIndexMap(dataDataset.getRowMetadata().get(0));
                            int rows2 = dataset.getRowCount();
                            for (int i3 = 0; i3 < rows2; ++i3) {
                                Integer rowIndex = rowNameToIndex.get(dataset.getRowMetadata().getValue(i3, 0));
                                if (rowIndex == null) continue;
                                int cols = dataset.getColumnCount();
                                for (int j = 0; j < cols; ++j) {
                                    Integer columnIndex = columnNameToIndex.get(dataset.getColumnMetadata().get(0).getValue(j));
                                    if (columnIndex == null) continue;
                                    float val = dataDataset.getValue(rowIndex, columnIndex);
                                    dataset.setValue(i3, j, val);
                                }
                            }
                        }
                        ImageLayoutChooser.setDatasetFiles(dataset, rowFilesForEachType, columnFilesForEachType, selectedImageTypes, maxImages);
                        TIntArrayList rowsToKeep = new TIntArrayList();
                        int rows3 = dataset.getRowCount();
                        block11: for (int i4 = 0; i4 < rows3; ++i4) {
                            int cols = dataset.getColumnCount();
                            for (int j = 0; j < cols; ++j) {
                                ImageElement e = (ImageElement)dataset.getObjectValue(i4, j, seriesIndex);
                                if (e == null || e.getFiles().size() <= 0) continue;
                                rowsToKeep.add(i4);
                                continue block11;
                            }
                        }
                        TIntArrayList columnsToKeep = new TIntArrayList();
                        int cols = dataset.getColumnCount();
                        block13: for (int j = 0; j < cols; ++j) {
                            int rows4 = dataset.getRowCount();
                            for (int i5 = 0; i5 < rows4; ++i5) {
                                ImageElement e = (ImageElement)dataset.getObjectValue(i5, j, seriesIndex);
                                if (e == null || e.getFiles().size() <= 0) continue;
                                columnsToKeep.add(j);
                                continue block13;
                            }
                        }
                        Dataset d = DatasetUtil.sliceView(dataset, rowsToKeep.toArray(), columnsToKeep.toArray());
                        MetadataUtil.setColumnMetadataVisibility(d.getColumnMetadata());
                        MetadataUtil.setRowMetadataVisibility(d.getRowMetadata());
                        MetadataUtil.maybeConvertMetadataClass(d, true);
                        return d;
                    }

                    @Override
                    protected void succeeded(Dataset dataset) {
                        project.setRowSortOrder(null);
                        project.setColumnSortOrder(null);
                        project.setDataset(dataset);
                        ArrayList<SortKeys.VectorSortKey> columnKeys = new ArrayList<SortKeys.VectorSortKey>();
                        int nc = dataset.getColumnMetadata().getMetadataCount();
                        for (int j = 0; j < nc; ++j) {
                            SortKeys.VectorSortKey key = new SortKeys.VectorSortKey(dataset.getColumnMetadata().getColumnName(j), SortOrder.ASCENDING, false);
                            columnKeys.add(key);
                        }
                        project.setColumnSortOrder(columnKeys);
                        ArrayList<SortKeys.VectorSortKey> rowKeys = new ArrayList<SortKeys.VectorSortKey>();
                        int nc2 = dataset.getRowMetadata().getMetadataCount();
                        for (int j = 0; j < nc2; ++j) {
                            SortKeys.VectorSortKey key = new SortKeys.VectorSortKey(dataset.getRowMetadata().getColumnName(j), SortOrder.ASCENDING, true);
                            rowKeys.add(key);
                        }
                        project.setRowSortOrder(rowKeys);
                    }
                }.execute();
            }
        });
        JPanel southPanel = new JPanel(new BorderLayout());
        this.fileInputPanel = new FileInputParameter("", FileInputParameter.OPEN_FILE);
        FormBuilder formBuilder = new FormBuilder();
        formBuilder.nextRow().nextRow();
        formBuilder.addSpanned(this.labeledThreeListsPanel.getComponent());
        formBuilder.nextRow();
        formBuilder.addLabel("Maximum number of images:");
        this.maxImagesToShow = new JTextField(12);
        this.maxImagesToShow.setText("4");
        formBuilder.add(this.maxImagesToShow);
        southPanel.add((Component)formBuilder.getPanel(), "Center");
        southPanel.add((Component)ButtonBarFactory.buildRightAlignedBar((JButton)viewButton), "South");
        this.add((Component)UIUtil.createNoBorderScrollPane(southPanel), "South");
    }

    private Map<String, List<Comparable>> getMetadataNameToValuesMap(Collection<String> metadataNames, boolean selected) {
        LinkedHashMap<String, List<Comparable>> metadataNamesToValues = new LinkedHashMap<String, List<Comparable>>();
        for (String metadata : metadataNames) {
            ArrayList<Comparable> values = new ArrayList<Comparable>();
            metadataNamesToValues.put(metadata, values);
            List<AbstractButton> checkBoxes = this.metadataNameToCheckBoxes.get(metadata);
            for (AbstractButton cb : checkBoxes) {
                if (cb.isSelected() != selected || !cb.isEnabled()) continue;
                Comparable value = (Comparable)cb.getClientProperty("checkbox.value");
                values.add(value);
            }
        }
        return metadataNamesToValues;
    }

    static List<AbstractButton> createButtons(JPanel checkBoxPanel, int columnIndex, String metadataName, Collection<? extends Comparable> metadataValues, boolean checkBox) {
        final ArrayList<AbstractButton> buttons = new ArrayList<AbstractButton>();
        CellConstraints cc = new CellConstraints();
        int rowIndex = 1;
        checkBoxPanel.add((Component)new JLabel(metadataName), cc.xy(columnIndex, rowIndex));
        rowIndex += 2;
        if (checkBox) {
            final JCheckBox toggleAll = new JCheckBox("(Select All)", true);
            toggleAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean selected = toggleAll.isSelected();
                    for (AbstractButton cb : buttons) {
                        cb.setSelected(selected);
                    }
                }
            });
            checkBoxPanel.add((Component)toggleAll, cc.xy(columnIndex, rowIndex));
        }
        for (Comparable comparable : metadataValues) {
            JToggleButton cb = checkBox ? new JCheckBox(Formatter.toString(comparable), true) : new JRadioButton(Formatter.toString(comparable), true);
            cb.putClientProperty("checkbox.value", comparable);
            checkBoxPanel.add((Component)cb, cc.xy(columnIndex, rowIndex += 2));
            buttons.add(cb);
        }
        if (!checkBox) {
            ButtonGroup bg = new ButtonGroup();
            for (AbstractButton bnt : buttons) {
                bg.add(bnt);
            }
        }
        return buttons;
    }

    static Map<JCheckBox, ImageTypePanel> createImageTypeCheckBoxes(JPanel checkBoxPanel, int columnIndex, Collection<ImageTypePanel> imageTypePanels) {
        final HashMap<JCheckBox, ImageTypePanel> imageTypeCheckBoxToImageTypePanel = new HashMap<JCheckBox, ImageTypePanel>();
        int rowIndex = 1;
        CellConstraints cc = new CellConstraints();
        checkBoxPanel.add((Component)new JLabel("Image Type"), cc.xy(columnIndex, rowIndex));
        final JCheckBox toggleAll = new JCheckBox("(Select All)", false);
        toggleAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = toggleAll.isSelected();
                for (JCheckBox cb : imageTypeCheckBoxToImageTypePanel.keySet()) {
                    cb.setSelected(selected);
                }
            }
        });
        checkBoxPanel.add((Component)toggleAll, cc.xy(columnIndex, rowIndex += 2));
        boolean isFirst = true;
        for (ImageTypePanel imageTypePanel : imageTypePanels) {
            JCheckBox cb = new JCheckBox(imageTypePanel.getImageTypeName(), isFirst);
            checkBoxPanel.add((Component)cb, cc.xy(columnIndex, rowIndex += 2));
            imageTypeCheckBoxToImageTypePanel.put(cb, imageTypePanel);
            isFirst = false;
        }
        return imageTypeCheckBoxToImageTypePanel;
    }

    static int[] getFileCount(Dataset dataset) {
        int fileListSize = -1;
        int seriesIndex = DatasetUtil.getSeriesIndex(dataset, ImageElement.class);
        int rows = dataset.getRowCount();
        block0: for (int i = 0; i < rows; ++i) {
            int cols = dataset.getColumnCount();
            for (int j = 0; j < cols; ++j) {
                fileListSize = ((ImageElement)dataset.getObjectValue(i, j, seriesIndex)).getFiles().size();
                if (fileListSize > 0) break block0;
            }
        }
        if (fileListSize == 0) {
            // empty if block
        }
        int[] count = new int[fileListSize];
        int rows2 = dataset.getRowCount();
        for (int i = 0; i < rows2; ++i) {
            int cols = dataset.getColumnCount();
            for (int j = 0; j < cols; ++j) {
                ImageElement imageElement = (ImageElement)dataset.getObjectValue(i, j, seriesIndex);
                List<Collection<File>> fileList = imageElement.getFiles();
                int size = fileList.size();
                for (int k = 0; k < size; ++k) {
                    count[k] = Math.max(count[k], fileList.get(k).size());
                }
            }
        }
        return count;
    }

    private static void filter(Set<File> set, Map<String, List<Comparable>> neitherMetadataNameToValues, ImageTypePanel imageTypePanel) {
        Iterator<File> it = set.iterator();
        while (it.hasNext()) {
            File f = it.next();
            if (!ImageLayoutChooser.isFileFiltered(f, neitherMetadataNameToValues, imageTypePanel)) continue;
            it.remove();
        }
    }

    private static Set<File>[] getFiles(Set<List<Comparable>> heatMapRowOrColumnsProduct, List<String> selectedRowMetadataItems, Set<File> availableFiles, ImageTypePanel imageTypePanel) {
        Set[] array = new Set[heatMapRowOrColumnsProduct.size()];
        int index = 0;
        Map<String, Map<Comparable, List<File>>> metadataNameToValueToFiles = imageTypePanel.getMetadataNameToValueToFiles();
        for (List<Comparable> rowOrColumnNamesList : heatMapRowOrColumnsProduct) {
            HashSet<File> set;
            array[index] = set = new HashSet<File>(availableFiles);
            int size = rowOrColumnNamesList.size();
            for (int j = 0; j < size; ++j) {
                Comparable metadataValue;
                Map<Comparable, List<File>> valueToFiles = metadataNameToValueToFiles.get(selectedRowMetadataItems.get(j));
                List<File> files = valueToFiles.get(metadataValue = rowOrColumnNamesList.get(j));
                if (files == null) continue;
                set.retainAll(files);
            }
            ++index;
        }
        return array;
    }

    private static Set<List<Comparable>> getProduct(Map<String, List<Comparable>> metadataNameToValuesMap) {
        ArrayList<HashSet<Comparable>> allValueList = new ArrayList<HashSet<Comparable>>();
        for (String metadataName : metadataNameToValuesMap.keySet()) {
            List<Comparable> values = metadataNameToValuesMap.get(metadataName);
            allValueList.add(new HashSet<Comparable>(values));
        }
        Set product = Sets.cartesianProduct(allValueList);
        return product;
    }

    private static boolean isFileFiltered(File f, Map<String, List<Comparable>> metadataNamesToValuesFilter, ImageTypePanel imageTypePanel) {
        for (String metadataName : metadataNamesToValuesFilter.keySet()) {
            Map<Comparable, List<File>> valueToFiles = imageTypePanel.getMetadataNameToValueToFiles().get(metadataName);
            List<Comparable> allowedValues = metadataNamesToValuesFilter.get(metadataName);
            boolean found = false;
            for (Comparable value : allowedValues) {
                List<File> filesForMetadataValue = valueToFiles.get(value);
                if (filesForMetadataValue == null || !filesForMetadataValue.contains(f)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return true;
        }
        return false;
    }

    private static void setDatasetFiles(Dataset dataset, List<Set<File>[]> rowSets, List<Set<File>[]> columnSets, List<ImageTypePanel> imageTypePanels, int maxImages) {
        int seriesIndex = DatasetUtil.getSeriesIndex(dataset, ImageElement.class);
        for (int typeIndex = 0; typeIndex < rowSets.size(); ++typeIndex) {
            ImageTypePanel imageTypePanel = imageTypePanels.get(typeIndex);
            Set<File>[] rowSet = rowSets.get(typeIndex);
            Set<File>[] columnSet = columnSets.get(typeIndex);
            int rows = rowSet.length;
            for (int i = 0; i < rows; ++i) {
                int cols = columnSet.length;
                for (int j = 0; j < cols; ++j) {
                    Object intersection = Sets.intersection(rowSet[i], columnSet[j]);
                    if (intersection.size() > 1) {
                        ArrayList<FileSortingHelper> tmp = new ArrayList<FileSortingHelper>();
                        Iterator i$ = intersection.iterator();
                        while (i$.hasNext()) {
                            File f = (File)i$.next();
                            tmp.add(new FileSortingHelper(f, imageTypePanel));
                        }
                        Collections.sort(tmp);
                        intersection = new ArrayList();
                        for (FileSortingHelper fsh : tmp) {
                            intersection.add(fsh.file);
                        }
                    }
                    ImageElement element = (ImageElement)dataset.getObjectValue(i, j, seriesIndex);
                    if (intersection.size() <= 0) continue;
                    if (intersection.size() > maxImages) {
                        ArrayList<File> tmp = new ArrayList<File>();
                        Iterator i$ = intersection.iterator();
                        while (i$.hasNext()) {
                            File f = (File)i$.next();
                            tmp.add(f);
                            if (tmp.size() != maxImages) continue;
                            break;
                        }
                        intersection = tmp;
                    }
                    element.add((Collection<File>)intersection);
                }
            }
        }
    }

    private static class FileSortingHelper
    implements Comparable<FileSortingHelper> {
        private File file;
        private Comparable plate;
        private Comparable well;

        public FileSortingHelper(File f, ImageTypePanel imageTypePanel) {
            this.file = f;
            this.plate = imageTypePanel.containsGroup("Plate") ? imageTypePanel.getValue(f, "Plate") : "";
            Object object = this.well = imageTypePanel.containsGroup("Well") ? imageTypePanel.getValue(f, "Well") : "";
            if (this.plate == null) {
                this.plate = "";
            }
            if (this.well == null) {
                this.well = "";
            }
        }

        @Override
        public int compareTo(FileSortingHelper obj) {
            int c = this.plate.compareTo(obj.plate);
            if (c == 0) {
                c = this.well.compareTo(obj.well);
            }
            return c;
        }
    }
}

