/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.compound.painter;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.broadinstitute.genee.compound.painter.ImageTypePanel;
import org.broadinstitute.genee.gui.CommandLineProgressMonitor;
import org.broadinstitute.genee.gui.ProgressNotifier;
import org.broadinstitute.genee.io.matrix.dchip.AbstractSampleInfoFile;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.PlateUtil;
import org.broadinstitute.genee.io.util.ToStringUtil;
import org.broadinstitute.genee.matrix.Identifier;

public class RenameImageFiles {
    private static final char SEP = '_';
    private static final Map<String, String> DEFAULT_TYPE_MAP = new HashMap<String, String>();

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Usage: mappingFile imageDirectory destDirectory");
            System.exit(1);
        }
        RenameImageFiles.rename(args[0], new File(args[1]), new File(args[2]), new CommandLineProgressMonitor(), 0);
    }

    public static void rename(String mappingFile, File imageDirectory, File destDirectory, ProgressNotifier progressMonitor, int plateIndexInFileName) throws Exception {
        Pattern p = Pattern.compile("_");
        if (!destDirectory.isDirectory()) {
            destDirectory.mkdirs();
            progressMonitor.setMessage("Created directory " + destDirectory);
        }
        if (!destDirectory.isDirectory()) {
            throw new IOException(destDirectory + " not found.");
        }
        progressMonitor.setPercentComplete(0.0f);
        progressMonitor.setMessage("Parsing mapping file");
        AbstractSampleInfoFile plateAndWellIndexedSampleInfoFile = PlateUtil.createPlateAndWellSampleInfoFile(progressMonitor, mappingFile, null);
        progressMonitor.setMessage("Searching image files");
        progressMonitor.setPercentComplete(1.0f);
        File[] imageFiles = IOUtil.listFiles(imageDirectory, new ImageTypePanel.ImageFileFilter(""), null, progressMonitor, true);
        int numberOfColumnsInExcelMappingFile = plateAndWellIndexedSampleInfoFile.getColumnNames().size();
        progressMonitor.setMessage("Found " + imageFiles.length + " Images");
        int renameCount = 0;
        for (int i = imageFiles.length - 1; i >= 0; --i) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            File file = imageFiles[i];
            String fileName = file.getName();
            String[] tokens = p.split(fileName = IOUtil.getBaseFileName(fileName.replace("p000001t00000001z001", "")));
            String plateInFileName = tokens[plateIndexInFileName];
            int dashIndex = plateInFileName.indexOf(45);
            if (dashIndex != -1) {
                plateInFileName = plateInFileName.substring(0, dashIndex).trim();
            }
            String wellInFileName = tokens[tokens.length - 3];
            int rowIndex = plateAndWellIndexedSampleInfoFile.idToRowIndex(new Identifier<Object>(plateInFileName, wellInFileName = PlateUtil.checkWellFormat(wellInFileName)));
            if (rowIndex == -1) continue;
            StringBuilder newFileNameBuffer = new StringBuilder();
            newFileNameBuffer.append(plateInFileName);
            newFileNameBuffer.append('_');
            newFileNameBuffer.append(wellInFileName);
            for (int j = 0; j < numberOfColumnsInExcelMappingFile; ++j) {
                newFileNameBuffer.append('_');
                String val = plateAndWellIndexedSampleInfoFile.getValue(rowIndex, j);
                if (val.indexOf(95) != -1) {
                    throw new RuntimeException(val + " in column " + plateAndWellIndexedSampleInfoFile.getColumnNames().get(j) + " contains '_' character.");
                }
                newFileNameBuffer.append(val);
            }
            String type = tokens[tokens.length - 1];
            String imageType = DEFAULT_TYPE_MAP.get(type);
            if (imageType == null) continue;
            newFileNameBuffer.append('_');
            newFileNameBuffer.append(imageType);
            newFileNameBuffer.append(".");
            newFileNameBuffer.append(IOUtil.getExtension(file));
            File destDir = new File(destDirectory, plateInFileName);
            if (!destDir.exists() && !destDir.mkdirs()) {
                throw new RuntimeException("Unable to create directory " + destDir);
            }
            String newFileName = newFileNameBuffer.toString();
            File dest = new File(destDir, newFileName);
            if (dest.exists() && dest.length() != 0L) continue;
            try {
                if (!dest.getParentFile().exists()) {
                    dest.getParentFile().mkdirs();
                }
                IOUtil.copyFile(file, dest);
                ++renameCount;
                if (i % 200 != 0) continue;
                progressMonitor.setMessage("Renaming " + file.getName());
                continue;
            }
            catch (IOException x) {
                x.printStackTrace();
                String message = "Unable to rename " + file + " to " + dest + ".";
                Pattern pattern = Pattern.compile(IOUtil.PROHIBITED_WINDOWS_FILE_NAME_PATTERN);
                Matcher m = pattern.matcher(dest.getName());
                if (m.find()) {
                    message = message + " A file name can not contain any of the following characters: " + ToStringUtil.toString(IOUtil.PROHIBITED_WINDOWS_FILE_NAME_CHARS, ", ") + ". The file name contains " + m.group();
                }
                throw new RuntimeException(message);
            }
        }
        progressMonitor.setMessage("Renamed " + renameCount + " files");
    }

    static {
        DEFAULT_TYPE_MAP.put("c0", "GFP");
        DEFAULT_TYPE_MAP.put("c01", "GFP");
        DEFAULT_TYPE_MAP.put("c1", "BF");
        DEFAULT_TYPE_MAP.put("c02", "BF");
        DEFAULT_TYPE_MAP.put("p2z2t2c2", "GFP");
        DEFAULT_TYPE_MAP.put("p2z2t2c3", "BF");
    }
}

