/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.compound.painter;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JTextField;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.compound.painter.RenameImageFiles;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.parameters.FileInputParameter;
import org.broadinstitute.genee.io.util.TrackerUtil;

public class RenameImageFilesAction
extends AbstractAction {
    private FileInputParameter imageDirectoryInputPanel;
    private FileInputParameter mappingFileInputPanel;
    private FileInputParameter outputDirectoryInputPanel;
    private GENEEWindow window;

    public RenameImageFilesAction() {
        super("Rename Images\u2026");
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TrackerUtil.trackPageView((String)this.getValue("Name"));
        if (this.window == null) {
            this.window = Application.createDialog("Rename Images");
            FormBuilder formBuilder = new FormBuilder();
            formBuilder.nextRow();
            this.mappingFileInputPanel = new FileInputParameter("", FileInputParameter.OPEN_FILE);
            this.imageDirectoryInputPanel = new FileInputParameter("", FileInputParameter.OPEN_DIRECTORY);
            this.outputDirectoryInputPanel = new FileInputParameter("", FileInputParameter.OPEN_DIRECTORY);
            formBuilder.addLabel("Mapping file:");
            formBuilder.add(this.mappingFileInputPanel);
            formBuilder.nextRow();
            formBuilder.addLabel("Image input directory:");
            formBuilder.add(this.imageDirectoryInputPanel);
            formBuilder.nextRow();
            formBuilder.addLabel("Renamed images output directory:");
            formBuilder.add(this.outputDirectoryInputPanel);
            formBuilder.nextRow();
            formBuilder.addLabel("Index of plate name in file:");
            final JTextField plateNameIndexField = new JTextField("0", 12);
            formBuilder.add(plateNameIndexField);
            formBuilder.nextRow();
            this.window.getContentPane().add(formBuilder.getPanel());
            this.window.getContentPane().add((Component)UIUtil.buildOKCancelBar(this.window, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final String mappingFile = RenameImageFilesAction.this.mappingFileInputPanel.getText();
                    if (mappingFile.equals("")) {
                        UIUtil.showErrorDialog(RenameImageFilesAction.this.window.getContentPane(), "Please enter a mapping file.");
                        return;
                    }
                    final String imageDir = RenameImageFilesAction.this.imageDirectoryInputPanel.getText();
                    if (imageDir.equals("")) {
                        UIUtil.showErrorDialog(RenameImageFilesAction.this.window.getContentPane(), "Please enter an image input directory.");
                        return;
                    }
                    File[] tmp = RenameImageFilesAction.this.outputDirectoryInputPanel.getFiles();
                    if (tmp.length == 0) {
                        UIUtil.showErrorDialog(RenameImageFilesAction.this.window.getContentPane(), "Please enter an image output directory.");
                        return;
                    }
                    RenameImageFilesAction.this.window.dispose();
                    final File outputDir = tmp[0];
                    final int plateNameIndex = Integer.parseInt(plateNameIndexField.getText().trim());
                    new BackgroundTask<Void>("Renaming files"){

                        @Override
                        protected Void doInBackground() throws Exception {
                            RenameImageFiles.rename(mappingFile, new File(imageDir), outputDir, this, plateNameIndex);
                            return null;
                        }
                    }.execute();
                }
            }), "South");
            this.window.pack();
        }
        this.window.setVisible(true);
    }
}

