/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.compound.painter;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.broadinstitute.genee.compound.painter.AbstractLayoutPanel;
import org.broadinstitute.genee.compound.painter.ImageElement;
import org.broadinstitute.genee.compound.painter.ImageTypePanel;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;

class WellLayoutPanel
extends AbstractLayoutPanel {
    private JTextField numberOfColumnsTextField;
    private JComboBox orderByComboBox;
    private HashSet<String> patternGroupNames = new HashSet();
    private JTextField numberOfRowsTextField;

    public WellLayoutPanel(HeatMapPanel heatMapPanel, DefaultProject project, List<ImageTypePanel> imageTypePanels) {
        super(heatMapPanel, project, imageTypePanels, "Well");
        for (ImageTypePanel imageTypePanel : imageTypePanels) {
            this.patternGroupNames.addAll(imageTypePanel.getPatternGroupNames());
        }
        super.init();
    }

    @Override
    protected JComponent buildUI() {
        FormBuilder p = new FormBuilder();
        p.nextRow();
        p.addLabel("Number of rows:");
        this.numberOfRowsTextField = new JTextField("30", 10);
        p.add(this.numberOfRowsTextField);
        p.nextRow();
        p.addLabel("Number of columns:");
        this.numberOfColumnsTextField = new JTextField("22", 10);
        p.add(this.numberOfColumnsTextField);
        p.nextRow();
        p.addLabel("Order by:");
        this.orderByComboBox = UIUtil.createComboBox();
        for (String s : this.patternGroupNames) {
            this.orderByComboBox.addItem(s);
        }
        p.add(this.orderByComboBox);
        this.orderByComboBox.setSelectedItem("WellNumber");
        return p.getPanel();
    }

    @Override
    protected Dataset createDataset(String selectedWell, List<JCheckBox> selectedImageTypeCheckBoxes) {
        RowMajorArray2DDataset dataset = new RowMajorArray2DDataset("", Integer.parseInt(this.numberOfRowsTextField.getText().trim()), Integer.parseInt(this.numberOfColumnsTextField.getText().trim()));
        String orderBy = (String)this.orderByComboBox.getSelectedItem();
        int seriesIndex = dataset.addSeries("Image", ImageElement.class);
        int rows = dataset.getRowCount();
        for (int i = 0; i < rows; ++i) {
            int cols = dataset.getColumnCount();
            for (int j = 0; j < cols; ++j) {
                dataset.setObjectValue(i, j, new ImageElement(), seriesIndex);
            }
        }
        TreeSet<Comparable> values = new TreeSet<Comparable>();
        for (JCheckBox cb : selectedImageTypeCheckBoxes) {
            List<File> imageFiles;
            ImageTypePanel imageTypePanel = (ImageTypePanel)this.imageTypeCheckBoxToImageTypePanel.get(cb);
            Map<Comparable, List<File>> wellToFiles = imageTypePanel.getMetadataNameToValueToFiles().get(this.metadataField);
            List<File> list = imageFiles = wellToFiles != null ? wellToFiles.get(selectedWell) : null;
            if (imageFiles == null) {
                imageFiles = Arrays.asList(imageTypePanel.getImageFiles());
            }
            for (File f : imageFiles) {
                Comparable value = imageTypePanel.getValue(f, orderBy);
                values.add(value);
            }
        }
        TreeSet<Float> newValues = new TreeSet<Float>();
        boolean nonNaN = false;
        try {
            for (Comparable c : values) {
                if (c == null) continue;
                float f = ParserHelper.parseFloatNaN((String)((Object)c));
                if (!Float.isNaN(f)) {
                    nonNaN = true;
                }
                newValues.add(Float.valueOf(f));
            }
        }
        catch (Throwable t) {
            nonNaN = false;
        }
        if (nonNaN) {
            values = newValues;
        }
        Map valueToIndex = IOUtil.buildIndexMap(values);
        for (JCheckBox cb : selectedImageTypeCheckBoxes) {
            List<File> imageFiles;
            ImageTypePanel imageTypePanel = (ImageTypePanel)this.imageTypeCheckBoxToImageTypePanel.get(cb);
            Map<Comparable, List<File>> valueToFiles = imageTypePanel.getMetadataNameToValueToFiles().get(this.metadataField);
            List<File> list = imageFiles = valueToFiles != null ? valueToFiles.get(selectedWell) : null;
            if (imageFiles == null) {
                imageFiles = Arrays.asList(imageTypePanel.getImageFiles());
            }
            for (File f : imageFiles) {
                Integer index;
                Comparable orderByValue = imageTypePanel.getValue(f, orderBy);
                if (nonNaN) {
                    orderByValue = Float.valueOf(ParserHelper.parseFloatNaN((String)((Object)orderByValue)));
                }
                if ((index = valueToIndex.get(orderByValue)) == null) continue;
                int i = index / dataset.getColumnCount();
                int j = index % dataset.getColumnCount();
                ImageElement element = (ImageElement)dataset.getObjectValue(i, j, seriesIndex);
                element.add(Arrays.asList(f));
            }
        }
        return dataset;
    }
}

