/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.RangeSlider;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class BasicRangeSliderUI
extends BasicSliderUI {
    protected Icon _lowerIcon;
    protected Icon _upperIcon;
    protected Icon _middleIcon;
    protected Icon _lowerIconV;
    protected Icon _upperIconV;
    protected Icon _middleIconV;
    protected static final int MOUSE_HANDLE_NONE = 0;
    protected static final int MOUSE_HANDLE_MIN = 1;
    protected static final int MOUSE_HANDLE_MAX = 2;
    protected static final int MOUSE_HANDLE_MIDDLE = 4;

    public BasicRangeSliderUI(JSlider slider) {
        super(slider);
    }

    public static ComponentUI createUI(JComponent slider) {
        return new BasicRangeSliderUI((JSlider)slider);
    }

    @Override
    protected void installDefaults(JSlider slider) {
        super.installDefaults(slider);
        this.resetAllIcons();
    }

    protected void resetAllIcons() {
        this._lowerIcon = UIDefaultsLookup.getIcon((Object)"RangeSlider.lowerIcon");
        this._upperIcon = UIDefaultsLookup.getIcon((Object)"RangeSlider.upperIcon");
        this._middleIcon = UIDefaultsLookup.getIcon((Object)"RangeSlider.middleIcon");
        this._lowerIconV = UIDefaultsLookup.getIcon((Object)"RangeSlider.lowerVIcon");
        this._upperIconV = UIDefaultsLookup.getIcon((Object)"RangeSlider.upperVIcon");
        this._middleIconV = UIDefaultsLookup.getIcon((Object)"RangeSlider.middleVIcon");
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this._lowerIcon = null;
        this._upperIcon = null;
        this._middleIcon = null;
        this._lowerIconV = null;
        this._upperIconV = null;
        this._middleIconV = null;
    }

    @Override
    protected void calculateTrackRect() {
        super.calculateTrackRect();
        if (this.slider.getOrientation() == 1) {
            this.trackRect.x += 4;
        } else {
            this.trackRect.y += 4;
        }
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new RangeTrackListener();
    }

    private void offset(int delta) {
        this.slider.getModel().setValue(((RangeSlider)this.slider).getLowValue() + delta);
    }

    protected int getMouseHandle(int x, int y) {
        Rectangle rect = this.trackRect;
        if (this.slider.getOrientation() == 1) {
            int minY = this.yPositionForValue(((RangeSlider)this.slider).getLowValue());
            int maxY = this.yPositionForValue(((RangeSlider)this.slider).getHighValue());
            Rectangle minRect = new Rectangle(rect.x + rect.width / 2, minY - this._lowerIconV.getIconHeight() / 2, this._lowerIcon.getIconWidth(), this._lowerIconV.getIconHeight());
            if (minRect.contains(x, y)) {
                return 1;
            }
            Rectangle maxRect = new Rectangle(rect.x, maxY - this._upperIconV.getIconHeight() / 2, this._upperIconV.getIconWidth(), this._upperIconV.getIconHeight());
            if (maxRect.contains(x, y)) {
                return 2;
            }
            Rectangle midRect = new Rectangle(rect.x - this._middleIcon.getIconWidth(), maxY - this._middleIconV.getIconHeight() / 2, this._middleIconV.getIconWidth(), this._middleIconV.getIconHeight());
            if (midRect.contains(x, y)) {
                return 4;
            }
            return 0;
        }
        int minX = this.xPositionForValue(((RangeSlider)this.slider).getLowValue());
        int maxX = this.xPositionForValue(((RangeSlider)this.slider).getHighValue());
        Rectangle minRect = new Rectangle(minX - this._lowerIcon.getIconWidth() / 2, rect.y + rect.height / 2, this._lowerIcon.getIconWidth(), this._lowerIcon.getIconHeight());
        if (minRect.contains(x, y)) {
            return 1;
        }
        Rectangle maxRect = new Rectangle(maxX - this._upperIcon.getIconWidth() / 2, rect.y, this._upperIcon.getIconWidth(), this._upperIcon.getIconHeight());
        if (maxRect.contains(x, y)) {
            return 2;
        }
        Rectangle midRect = new Rectangle(maxX - this._middleIcon.getIconWidth() / 2, rect.y - this._middleIcon.getIconHeight(), this._middleIcon.getIconWidth(), this._middleIcon.getIconHeight());
        if (midRect.contains(x, y)) {
            return 4;
        }
        return 0;
    }

    @Override
    public void paintThumb(Graphics g) {
        Rectangle rect = this.trackRect;
        RangeSlider rangeSlider = (RangeSlider)this.slider;
        if (this.slider.getOrientation() == 1) {
            int minY = this.yPositionForValue(rangeSlider.getLowValue());
            int maxY = this.yPositionForValue(rangeSlider.getHighValue());
            this._lowerIconV.paintIcon(this.slider, g, rect.x + rect.width / 2, minY - this._lowerIconV.getIconHeight() / 2);
            this._upperIconV.paintIcon(this.slider, g, rect.x, maxY - this._upperIconV.getIconHeight() / 2);
            this._middleIconV.paintIcon(this.slider, g, rect.x - this._middleIconV.getIconWidth(), maxY - this._middleIconV.getIconHeight() / 2);
        } else {
            int minX = this.xPositionForValue(rangeSlider.getLowValue());
            int maxX = this.xPositionForValue(rangeSlider.getHighValue());
            this._lowerIcon.paintIcon(this.slider, g, minX - this._lowerIcon.getIconWidth() / 2, rect.y + rect.height / 2);
            this._upperIcon.paintIcon(this.slider, g, maxX - this._upperIcon.getIconWidth() / 2, rect.y);
            this._middleIcon.paintIcon(this.slider, g, maxX - this._middleIcon.getIconWidth() / 2, rect.y - this._middleIcon.getIconHeight());
        }
    }

    @Override
    public void paintTrack(Graphics g) {
        super.paintTrack(g);
        Rectangle rect = this.trackRect;
        if (this.slider.getOrientation() == 0) {
            RangeSlider rangeSlider = (RangeSlider)this.slider;
            int minX = this.xPositionForValue(rangeSlider.getLowValue());
            int maxX = this.xPositionForValue(rangeSlider.getHighValue());
            g.setColor(Color.DARK_GRAY);
            int y = rect.y + rect.height / 2 - 2;
            g.fillRect(minX, y, maxX - minX, 3);
        }
    }

    protected void setMouseRollover(int handle) {
        this.resetAllIcons();
        switch (handle) {
            case 1: {
                Icon icon = UIDefaultsLookup.getIcon((Object)"RangeSlider.lowerRIcon");
                if (icon != null) {
                    this._lowerIcon = icon;
                }
                if ((icon = UIDefaultsLookup.getIcon((Object)"RangeSlider.lowerVRIcon")) == null) break;
                this._lowerIconV = icon;
                break;
            }
            case 2: {
                Icon icon = UIDefaultsLookup.getIcon((Object)"RangeSlider.upperRIcon");
                if (icon != null) {
                    this._upperIcon = icon;
                }
                if ((icon = UIDefaultsLookup.getIcon((Object)"RangeSlider.upperVRIcon")) == null) break;
                this._upperIconV = icon;
                break;
            }
            case 4: {
                Icon icon = UIDefaultsLookup.getIcon((Object)"RangeSlider.middleRIcon");
                if (icon != null) {
                    this._middleIcon = icon;
                }
                if ((icon = UIDefaultsLookup.getIcon((Object)"RangeSlider.middleVRIcon")) == null) break;
                this._middleIconV = icon;
                break;
            }
        }
        this.slider.repaint();
    }

    protected class RangeTrackListener
    extends BasicSliderUI.TrackListener {
        int handle;
        int handleOffset;
        int mouseStartLocation;

        public RangeTrackListener() {
            super(BasicRangeSliderUI.this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!BasicRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.handle = BasicRangeSliderUI.this.getMouseHandle(e.getX(), e.getY());
            this.handleOffset = BasicRangeSliderUI.this.slider.getOrientation() == 1 ? e.getY() - BasicRangeSliderUI.this.yPositionForValue(((RangeSlider)BasicRangeSliderUI.this.slider).getLowValue()) : e.getX() - BasicRangeSliderUI.this.xPositionForValue(((RangeSlider)BasicRangeSliderUI.this.slider).getLowValue());
            this.mouseStartLocation = BasicRangeSliderUI.this.slider.getOrientation() == 1 ? e.getY() : e.getX();
            BasicRangeSliderUI.this.slider.getModel().setValueIsAdjusting(true);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int newValue;
            if (!BasicRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            int newLocation = BasicRangeSliderUI.this.slider.getOrientation() == 1 ? e.getY() : e.getX();
            int n = newValue = BasicRangeSliderUI.this.slider.getOrientation() == 1 ? BasicRangeSliderUI.this.valueForYPosition(newLocation) : BasicRangeSliderUI.this.valueForXPosition(newLocation);
            if (newValue < BasicRangeSliderUI.this.slider.getModel().getMinimum()) {
                newValue = BasicRangeSliderUI.this.slider.getModel().getMinimum();
            }
            if (newValue > BasicRangeSliderUI.this.slider.getModel().getMaximum()) {
                newValue = BasicRangeSliderUI.this.slider.getModel().getMaximum();
            }
            if (this.handle == 3) {
                if (newLocation - this.mouseStartLocation > 2) {
                    this.handle = 2;
                } else if (newLocation - this.mouseStartLocation < -2) {
                    this.handle = 1;
                } else {
                    return;
                }
            }
            RangeSlider rangeSlider = (RangeSlider)BasicRangeSliderUI.this.slider;
            switch (this.handle) {
                case 1: {
                    rangeSlider.setLowValue(Math.min(newValue, rangeSlider.getHighValue()));
                    break;
                }
                case 2: {
                    rangeSlider.setHighValue(Math.max(rangeSlider.getLowValue(), newValue));
                    break;
                }
                case 4: {
                    int delta;
                    int n2 = delta = BasicRangeSliderUI.this.slider.getOrientation() == 1 ? BasicRangeSliderUI.this.valueForYPosition(newLocation - this.handleOffset) - rangeSlider.getLowValue() : BasicRangeSliderUI.this.valueForXPosition(newLocation - this.handleOffset) - rangeSlider.getLowValue();
                    if (delta < 0 && rangeSlider.getLowValue() + delta < rangeSlider.getMinimum()) {
                        delta = rangeSlider.getMinimum() - rangeSlider.getLowValue();
                    }
                    if (delta > 0 && rangeSlider.getHighValue() + delta > rangeSlider.getMaximum()) {
                        delta = rangeSlider.getMaximum() - rangeSlider.getHighValue();
                    }
                    if (delta == 0) break;
                    BasicRangeSliderUI.this.offset(delta);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            BasicRangeSliderUI.this.slider.getModel().setValueIsAdjusting(false);
        }

        private void setCursor(int c) {
            Cursor cursor = Cursor.getPredefinedCursor(c);
            if (BasicRangeSliderUI.this.slider.getCursor() != cursor) {
                BasicRangeSliderUI.this.slider.setCursor(cursor);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!BasicRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            switch (BasicRangeSliderUI.this.getMouseHandle(e.getX(), e.getY())) {
                case 1: {
                    BasicRangeSliderUI.this.setMouseRollover(1);
                    this.setCursor(BasicRangeSliderUI.this.slider.getOrientation() == 1 ? 8 : 10);
                    break;
                }
                case 2: {
                    BasicRangeSliderUI.this.setMouseRollover(2);
                    this.setCursor(BasicRangeSliderUI.this.slider.getOrientation() == 1 ? 9 : 11);
                    break;
                }
                case 4: {
                    BasicRangeSliderUI.this.setMouseRollover(4);
                    this.setCursor(13);
                    break;
                }
                case 0: {
                    BasicRangeSliderUI.this.setMouseRollover(0);
                    this.setCursor(0);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                BasicRangeSliderUI.this.slider.getModel().setValue(BasicRangeSliderUI.this.slider.getModel().getMinimum());
                BasicRangeSliderUI.this.slider.getModel().setExtent(BasicRangeSliderUI.this.slider.getModel().getMaximum() - BasicRangeSliderUI.this.slider.getModel().getMinimum());
                BasicRangeSliderUI.this.slider.repaint();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.setCursor(0);
        }
    }
}

