/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.genee.filter.AbstractFilter;
import org.broadinstitute.genee.filter.Filter;
import org.broadinstitute.genee.heatmap.FilterEvent;
import org.broadinstitute.genee.heatmap.FilterListener;

public class CombinedFilter
extends AbstractFilter {
    private boolean andFilter = false;
    private FilterListener filterListener;
    private List<Filter> filters = new ArrayList<Filter>();

    public CombinedFilter() {
        this(false, null);
    }

    public CombinedFilter(boolean andFilter, Filter ... filters) {
        this.andFilter = andFilter;
        this.filterListener = new FilterListener(){

            @Override
            public void filterChanged(FilterEvent e) {
                CombinedFilter.this.fireFilterChanged();
            }
        };
        if (filters != null) {
            for (Filter f : filters) {
                this.add(f);
            }
        }
    }

    @Override
    public boolean accept(int rowIndex) {
        if (this.andFilter) {
            for (Filter f : this.filters) {
                if (f.isEmpty() || !f.isEnabled() || f.accept(rowIndex)) continue;
                return false;
            }
            return true;
        }
        boolean allEmpty = true;
        for (Filter f : this.filters) {
            if (f.isEmpty() || !f.isEnabled()) continue;
            allEmpty = false;
            if (!f.accept(rowIndex)) continue;
            return true;
        }
        return allEmpty;
    }

    public void add(Filter f) {
        f.addFilterListener(this.filterListener);
        this.filters.add(f);
        this.fireFilterChanged();
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    @Override
    public void init(Object object) {
        for (Filter f : this.filters) {
            if (f.isEmpty() || !f.isEnabled()) continue;
            f.init(object);
        }
    }

    public boolean isAndFilter() {
        return this.andFilter;
    }

    @Override
    public boolean isEmpty() {
        return this.filters.size() == 0;
    }

    public boolean remove(Filter f) {
        boolean removed = false;
        if (f != null) {
            f.removeFilterListener(this.filterListener);
            removed = this.filters.remove(f);
            this.fireFilterChanged();
        }
        return removed;
    }

    public void setAndFilter(boolean andFilter) {
        this.andFilter = andFilter;
        this.fireFilterChanged();
    }
}

