/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import com.jidesoft.pane.CollapsiblePane;
import com.jidesoft.pane.CollapsiblePanes;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.broadinstitute.genee.filter.CombinedFilter;
import org.broadinstitute.genee.filter.Filter;
import org.broadinstitute.genee.filter.FilterComponent;
import org.broadinstitute.genee.filter.Filters;
import org.broadinstitute.genee.filter.ListFilterComponent;
import org.broadinstitute.genee.filter.RangeFilterComponent;
import org.broadinstitute.genee.filter.TopFilterComponent;
import org.broadinstitute.genee.gui.ButtonGroupHelper;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.IconManager;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;

public class FilterPanel {
    private AddFilterControl addFilterPanel;
    private FormBuilder andOrBuilder;
    private CollapsiblePanes collapsiblePanes;
    private CombinedFilter combinedFilter;
    private Project project;

    public FilterPanel(Project project) {
        this.project = project;
        this.collapsiblePanes = new CollapsiblePanes();
        this.collapsiblePanes.setGap(0);
        this.collapsiblePanes.setBackground(UIManager.getColor("Panel.background"));
        this.collapsiblePanes.addExpansion();
        this.andOrBuilder = new FormBuilder();
        ButtonGroupHelper buttonGroupHelper = new ButtonGroupHelper();
        final JRadioButton andButton = buttonGroupHelper.createRadioButton("Require rows to pass all filters");
        JRadioButton orButton = buttonGroupHelper.createRadioButton("Require rows to pass at least one filter", true);
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterPanel.this.combinedFilter.setAndFilter(e.getSource() == andButton);
            }
        };
        andButton.addActionListener(l);
        orButton.addActionListener(l);
        this.andOrBuilder.nextRow();
        this.andOrBuilder.addFirstColumn(orButton);
        this.andOrBuilder.add(andButton);
        this.addFilterPanel = new AddFilterControl();
        Filter filter = project.getRowFilter();
        if (filter instanceof CombinedFilter) {
            this.combinedFilter = (CombinedFilter)filter;
            ArrayList<Filter> filters = new ArrayList<Filter>(this.combinedFilter.getFilters());
            for (Filter f : filters) {
                if (f instanceof Filters.AbstractDatasetMetadataFilter) {
                    Vector vector = project.getOriginalDataset().getRowMetadata().get(((Filters.AbstractDatasetMetadataFilter)f).getMetadataColumnName());
                    if (vector == null) continue;
                    new FilterCollapsiblePane(vector, f);
                    continue;
                }
                System.out.println(f.getClass());
            }
            andButton.setSelected(this.combinedFilter.isAndFilter());
        } else {
            this.combinedFilter = new CombinedFilter();
            project.setRowFilter(this.combinedFilter);
        }
    }

    public void rebuild() {
        this.addFilterPanel.rebuild();
    }

    public Component getCenter() {
        return this.collapsiblePanes;
    }

    public Filter getFilter() {
        return this.combinedFilter;
    }

    public Component getNorth() {
        return this.andOrBuilder.getPanel();
    }

    public Component getSouth() {
        return this.addFilterPanel;
    }

    private class FilterCollapsiblePane
    extends CollapsiblePane {
        private Filter filter;
        private JPanel panel;
        private Vector vector;

        private FilterCollapsiblePane(Vector vector, Filter existingFilter) {
            super(vector.getName());
            this.vector = vector;
            this.panel = new JPanel(new FlowLayout(0));
            this.panel.setOpaque(false);
            JButton deleteButton = new JButton(IconManager.loadIcon("16x16/14763.delete.gif"));
            deleteButton.setToolTipText("Delete");
            final JCheckBox enabledCheckBox = new JCheckBox("Enabled", true);
            ActionListener deleteActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FilterCollapsiblePane.this.filter.setEnabled(false);
                    FilterPanel.this.collapsiblePanes.remove((Component)((Object)FilterCollapsiblePane.this));
                    FilterPanel.this.collapsiblePanes.revalidate();
                    FilterPanel.this.combinedFilter.remove(FilterCollapsiblePane.this.filter);
                }
            };
            enabledCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FilterCollapsiblePane.this.filter.setEnabled(enabledCheckBox.isSelected());
                }
            });
            deleteButton.addActionListener(deleteActionListener);
            this.panel.add(enabledCheckBox);
            this.panel.add(deleteButton);
            this.setTitleComponent(this.panel);
            this.setTitleLabelGap(0);
            this.setSteps(1);
            this.rebuildUI(existingFilter);
            FilterPanel.this.collapsiblePanes.add((Component)((Object)this));
        }

        private void rebuildUI(Filter existingFilter) {
            FilterPanel.this.combinedFilter.remove(this.filter);
            if (IOUtil.isNumber(this.vector.getColumnClass())) {
                final JTabbedPane tabbedPane = new JTabbedPane();
                tabbedPane.addTab("Range", new RangeFilterComponent((Filters.RangeFilter)(existingFilter instanceof Filters.RangeFilter ? existingFilter : new Filters.RangeFilter(this.vector.getName()))));
                Filters.TopFilter topFilter = new Filters.TopFilter();
                topFilter.setMetadataColumnName(this.vector.getName());
                tabbedPane.addTab("Top", new TopFilterComponent((Filters.TopFilter)(existingFilter instanceof Filters.TopFilter ? existingFilter : topFilter)));
                if (existingFilter instanceof Filters.TopFilter) {
                    tabbedPane.setSelectedIndex(1);
                }
                FilterComponent selection = (FilterComponent)((Object)tabbedPane.getSelectedComponent());
                this.filter = selection.getFilter();
                this.setContentPane(tabbedPane);
                tabbedPane.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        FilterComponent selection = (FilterComponent)((Object)tabbedPane.getSelectedComponent());
                        FilterPanel.this.combinedFilter.remove(FilterCollapsiblePane.this.filter);
                        FilterCollapsiblePane.this.filter = selection.getFilter();
                        FilterPanel.this.combinedFilter.add(FilterCollapsiblePane.this.filter);
                    }
                });
            } else {
                ListFilterComponent c = new ListFilterComponent(this.vector, (Filters.SetFilter)(existingFilter instanceof Filters.SetFilter ? existingFilter : new Filters.SetFilter(this.vector.getName())));
                this.filter = c.getFilter();
                if (this.filter == null) {
                    throw new NullPointerException("Filter is null");
                }
                this.setContentPane(c.getComponent());
            }
            FilterPanel.this.combinedFilter.add(this.filter);
            this.revalidate();
        }
    }

    private class AddFilterControl
    extends JPanel {
        private JComboBox fieldChooser = UIUtil.createComboBox();
        private JLabel selectLabel;

        public AddFilterControl() {
            this.fieldChooser.setSelectedIndex(-1);
            this.fieldChooser.setOpaque(false);
            this.selectLabel = new JLabel("Add a filter: ");
            JPanel panel = new JPanel();
            panel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            panel.setLayout(new GridBagLayout());
            panel.add((Component)this.selectLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.fieldChooser, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.fieldChooser.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() != 1) {
                        return;
                    }
                    if (AddFilterControl.this.fieldChooser.getSelectedIndex() > 0) {
                        String field = (String)AddFilterControl.this.fieldChooser.getSelectedItem();
                        AddFilterControl.this.addFilter(field);
                    }
                }
            });
            this.setLayout(new FlowLayout(3));
            this.add(panel);
            this.rebuild();
        }

        public void addFilter(String field) {
            Vector vector = FilterPanel.this.project.getOriginalDataset().getRowMetadata().get(field);
            new FilterCollapsiblePane(vector, null);
        }

        private void rebuild() {
            this.fieldChooser.removeAllItems();
            this.fieldChooser.addItem("");
            for (String name : MetadataUtil.getNames(FilterPanel.this.project.getOriginalDataset().getRowMetadata())) {
                this.fieldChooser.addItem(name);
            }
        }
    }
}

