/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.Set;
import org.broadinstitute.genee.compound.MoleculeUtil;
import org.broadinstitute.genee.filter.AbstractDatasetFilter;
import org.broadinstitute.genee.filter.AbstractFloatFilter;
import org.broadinstitute.genee.filter.GT;
import org.broadinstitute.genee.filter.GTE;
import org.broadinstitute.genee.filter.LT;
import org.broadinstitute.genee.filter.LTE;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.stats.Sorting;

public class Filters {

    public static class TopFilter
    extends AbstractDatasetMetadataFilter {
        private AbstractFloatFilter greaterOrLessThanFilter = new GT();
        private int n = -1;
        private boolean top = true;

        @Override
        public boolean accept(Object value) {
            if (value instanceof Number) {
                float val = ((Number)value).floatValue();
                return Float.isNaN(val) ? false : this.greaterOrLessThanFilter.apply(val);
            }
            return false;
        }

        public int getN() {
            return this.n;
        }

        @Override
        public void init(Object object) {
            super.init(object);
            if (this.n > 0) {
                Dataset dataset = (Dataset)object;
                Vector vector = dataset.getRowMetadata().get(this.metadataColumnName);
                ArrayList<Sorting.FloatIntPair> pairs = new ArrayList<Sorting.FloatIntPair>();
                int rows = dataset.getRowCount();
                for (int i = 0; i < rows; ++i) {
                    float val;
                    Number n = (Number)vector.getValue(i);
                    if (n == null || Float.isNaN(val = n.floatValue()) || Float.isInfinite(val)) continue;
                    pairs.add(new Sorting.FloatIntPair(val, i));
                }
                int n = this.n - 1;
                int[] sortedIndices = Sorting.index(pairs.toArray(new Sorting.FloatIntPair[0]), !this.top);
                if (n >= sortedIndices.length) {
                    n = sortedIndices.length - 1;
                } else if (n < 0) {
                    n = 0;
                }
                float value = ((Number)vector.getValue(sortedIndices[n])).floatValue();
                if (this.top) {
                    this.greaterOrLessThanFilter = new GTE();
                    this.greaterOrLessThanFilter.setValue(value);
                } else {
                    this.greaterOrLessThanFilter = new LTE();
                    this.greaterOrLessThanFilter.setValue(value);
                }
            } else {
                this.greaterOrLessThanFilter.setValue(Float.NaN);
            }
        }

        @Override
        public boolean isEmpty() {
            return this.n <= 0;
        }

        public boolean isTop() {
            return this.top;
        }

        public void setN(int val) {
            this.n = val;
            this.fireFilterChanged();
        }

        public void setTop(boolean top) {
            this.top = top;
            this.fireFilterChanged();
        }

        public String toString() {
            return "Top";
        }
    }

    public static class StructuralFilter
    extends AbstractDatasetMetadataFilter {
        private AbstractFloatFilter floatFilter = new LT();
        private Molecule molecule;

        public StructuralFilter() {
            this.floatFilter.setValue(Float.NaN);
        }

        @Override
        public boolean accept(Object value) {
            if (value instanceof Molecule) {
                Molecule m = (Molecule)value;
                float dist = MoleculeUtil.getTanimoto(this.molecule, m);
                return this.floatFilter.apply(dist);
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.molecule == null || Float.isNaN(this.floatFilter.value);
        }

        public void setFloatFilter(AbstractFloatFilter floatFilter) {
            float oldValue = floatFilter.value;
            this.floatFilter = floatFilter;
            this.floatFilter.setValue(oldValue);
            this.fireFilterChanged();
        }

        public void setSmileString(String text) {
            this.molecule = MoleculeUtil.read(text);
            this.fireFilterChanged();
        }

        public void setValue(float d) {
            this.floatFilter.setValue(d);
            this.fireFilterChanged();
        }

        public String toString() {
            return "Tanimoto";
        }
    }

    public static class SetFilter
    extends AbstractDatasetMetadataFilter {
        private Set set;

        public SetFilter(String name) {
            this.setMetadataColumnName(name);
        }

        @Override
        public boolean accept(Object value) {
            return this.set.contains(value);
        }

        public Set getSet() {
            return this.set;
        }

        @Override
        public boolean isEmpty() {
            return this.set == null;
        }

        public void setSet(Set set) {
            this.set = set;
        }
    }

    public static class RowMetadataNumberFilter
    extends AbstractDatasetMetadataFilter {
        private AbstractFloatFilter floatFilter;

        @Override
        public boolean accept(Object value) {
            if (value instanceof Number) {
                return this.floatFilter.apply(((Number)value).floatValue());
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.floatFilter == null || Float.isNaN(this.floatFilter.value);
        }
    }

    public static class RangeFilter
    extends AbstractDatasetMetadataFilter {
        public AbstractFloatFilter f1;
        public AbstractFloatFilter f2;

        public RangeFilter(String name) {
            this.setMetadataColumnName(name);
            this.f1 = new GTE();
            this.f2 = new LTE();
        }

        @Override
        public boolean accept(Object obj) {
            if (obj instanceof Number) {
                float value = ((Number)obj).floatValue();
                return !(!Float.isNaN(this.f1.value) && !this.f1.apply(value) || !Float.isNaN(this.f2.value) && !this.f2.apply(value));
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return Float.isNaN(this.f1.getValue()) && Float.isNaN(this.f2.getValue());
        }
    }

    public static abstract class AbstractDatasetMetadataFilter
    extends AbstractDatasetFilter {
        protected String metadataColumnName;
        protected Vector vector;

        @Override
        public void init(Object object) {
            super.init(object);
            this.vector = this.dataset.getRowMetadata().get(this.metadataColumnName);
            if (this.vector == null) {
                throw new NullPointerException(this.metadataColumnName + " not found.");
            }
        }

        @Override
        public boolean accept(int index) {
            return this.accept(this.vector.getValue(index));
        }

        public abstract boolean accept(Object var1);

        public String getMetadataColumnName() {
            return this.metadataColumnName;
        }

        public void setMetadataColumnName(String metadataColumnName) {
            this.metadataColumnName = metadataColumnName;
        }
    }
}

